/*
 * Decompiled with CFR 0.152.
 */
package xyz.yoinky3000.server_info_api.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import xyz.yoinky3000.server_info_api.ServerInfoAPI;
import xyz.yoinky3000.server_info_api.annotations.ConfigSettings;

@ConfigSettings(fileName="players.json")
public class Players {
    public List<Player> list = new ArrayList<Player>();

    public void updateOrInsertPlayer(String name, UUID uuid) {
        boolean found = false;
        for (Player player : this.list) {
            if (!Objects.equals(player.uuid, uuid)) continue;
            if (!player.name.equals(name)) {
                player.name = name;
                ServerInfoAPI.LOGGER.debug("Updated player name for UUID " + String.valueOf(uuid) + " to " + name);
            } else {
                ServerInfoAPI.LOGGER.debug("Player " + name + " (UUID " + String.valueOf(uuid) + ") already exists with same name. No update needed.");
            }
            found = true;
            break;
        }
        if (!found) {
            Player newPlayer = new Player(name, uuid);
            this.list.add(newPlayer);
            ServerInfoAPI.LOGGER.debug("Added new player: " + name + " (UUID: " + String.valueOf(uuid) + ")");
        }
    }

    public Optional<Player> find(UUID uuid) {
        if (uuid == null) {
            return Optional.empty();
        }
        return this.list.stream().filter(p -> p.uuid != null && p.uuid.equals(uuid)).findFirst();
    }

    public Optional<Player> find(String criteria) {
        if (criteria == null || criteria.trim().isEmpty()) {
            return Optional.empty();
        }
        return this.list.stream().filter(p -> p.name != null && (p.name.equals(criteria) || p.uuid.toString().equals(criteria))).findFirst();
    }

    public static class Player {
        public String name;
        public UUID uuid;

        public Player(String name, UUID uuid) {
            this.name = name;
            this.uuid = uuid;
        }
    }
}

