/*
 * Decompiled with CFR 0.152.
 */
package xyz.yoinky3000.server_info_api.handler;

import fi.iki.elonen.NanoHTTPD;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import xyz.yoinky3000.server_info_api.ServerInfoAPI;
import xyz.yoinky3000.server_info_api.annotations.RouteSettings;
import xyz.yoinky3000.server_info_api.api.APIRequest;
import xyz.yoinky3000.server_info_api.api.APIResponse;
import xyz.yoinky3000.server_info_api.api.APIRoute;
import xyz.yoinky3000.server_info_api.api.RouteDefinition;

public class APIHandler
extends NanoHTTPD {
    private static final List<RouteDefinition> routeDefinitions = new ArrayList<RouteDefinition>();
    public int port;

    public APIHandler(int port) throws IOException {
        super(port);
        this.port = port;
    }

    public NanoHTTPD.Response serve(NanoHTTPD.IHTTPSession session) {
        String path = APIHandler.normalizePath(session.getUri());
        for (RouteDefinition def : routeDefinitions) {
            Map<String, String> params = def.match(path);
            if (params == null) continue;
            if (def.requireMinecraftServer && ServerInfoAPI.SERVER == null) {
                return APIHandler.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.INTERNAL_ERROR, (String)"text/plain", (String)"Server not ready.");
            }
            APIResponse res = def.handler.handle(new APIRequest(session.getUri(), session.getMethod().name(), params), ServerInfoAPI.SERVER);
            return APIHandler.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.lookup((int)res.getStatusCode()), (String)res.getMimeType(), (String)res.getBody());
        }
        return APIHandler.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.NOT_FOUND, (String)"text/plain", (String)"Not Found");
    }

    public void start() throws IOException {
        String template = "\n=========================================================\nAPI running on port %d\nIf you want to change the port, edit %s\n=========================================================\n";
        ServerInfoAPI.LOGGER.info(String.format(template, ServerInfoAPI.config.getData().apiPort, ServerInfoAPI.config.getPath()));
        super.start();
    }

    public void registerInternalRoutes() {
        Reflections reflections = new Reflections("xyz.yoinky3000.server_info_api.api.routes", new Scanner[0]);
        for (Class clazz : reflections.getTypesAnnotatedWith(RouteSettings.class)) {
            if (!APIRoute.class.isAssignableFrom(clazz)) continue;
            try {
                APIRoute handler = (APIRoute)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                APIHandler.registerRoute(handler, false, true);
            }
            catch (Exception e) {
                RouteSettings routeAnnotation = clazz.getAnnotation(RouteSettings.class);
                String path = routeAnnotation.path();
                ServerInfoAPI.LOGGER.error("Failed to register route: {}", (Object)path, (Object)e);
            }
        }
    }

    public static RegisterResult registerRoute(APIRoute handler, boolean override, boolean internal) {
        Class<?> clazz = handler.getClass();
        if (!clazz.isAnnotationPresent(RouteSettings.class)) {
            ServerInfoAPI.LOGGER.error("Cannot register route: Missing @RouteSettings annotation on {}", (Object)clazz.getName());
            return RegisterResult.FAILED;
        }
        RouteSettings annotation = clazz.getAnnotation(RouteSettings.class);
        String path = annotation.path();
        boolean requireMinecraftServer = annotation.requireMinecraftServer();
        return APIHandler.registerRoute(path, handler, requireMinecraftServer, override, internal);
    }

    public static RegisterResult registerRoute(String path, APIRoute handler, boolean requireMinecraftServer, boolean override, boolean internal) {
        path = APIHandler.normalizePath(path);
        Optional<RouteDefinition> routeStatus = APIHandler.routeAvailability(path);
        boolean overrided = false;
        if (routeStatus.isPresent()) {
            if (!override) {
                ServerInfoAPI.LOGGER.error("Cannot register route {}, occupied", (Object)path);
                return RegisterResult.OCCUPIED;
            }
            ServerInfoAPI.LOGGER.warn("Override enabled, removing old handler of route {}", (Object)path);
            routeDefinitions.remove(routeStatus.get());
            overrided = true;
        }
        routeDefinitions.add(new RouteDefinition(path, handler, requireMinecraftServer));
        ServerInfoAPI.LOGGER.info("{}Registered {}route: {}", new Object[]{overrided ? "Overrided and " : "", !internal ? "External " : "", path});
        return overrided ? RegisterResult.OVERRIDED : RegisterResult.SUCCEED;
    }

    private static Optional<RouteDefinition> routeAvailability(String path) {
        return routeDefinitions.stream().filter(def -> def.routePattern.equals(path)).findFirst();
    }

    private static String normalizePath(String path) {
        if (path == null || ((String)path).isEmpty()) {
            return "/";
        }
        if (!((String)(path = ((String)path).trim())).startsWith("/")) {
            path = "/" + (String)path;
        }
        if (((String)(path = ((String)path).replaceAll("/+", "/"))).length() > 1 && ((String)path).endsWith("/")) {
            path = ((String)path).substring(0, ((String)path).length() - 1);
        }
        if (((String)path).isEmpty()) {
            return "/";
        }
        return path;
    }

    public static enum RegisterResult {
        OVERRIDED,
        OCCUPIED,
        SUCCEED,
        FAILED;

    }
}

