/*
 * Decompiled with CFR 0.152.
 */
package xyz.yoinky3000.server_info_api.handler;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import xyz.yoinky3000.server_info_api.ServerInfoAPI;
import xyz.yoinky3000.server_info_api.annotations.ConfigSettings;

public class ConfigHandler<T> {
    private T instance;
    private final Class<T> clazz;
    private final String fileName;
    private final File configFile;

    public ConfigHandler(Class<T> as) {
        if (!as.isAnnotationPresent(ConfigSettings.class)) {
            ServerInfoAPI.LOGGER.error("Cannot identify config settings: Missing @ConfigSettings annotation on {}", (Object)as.getName());
            throw new IllegalArgumentException("Missing @ConfigSettings annotation on " + as.getName());
        }
        this.clazz = as;
        try {
            Constructor<T> constructor = this.clazz.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            this.instance = constructor.newInstance(new Object[0]);
        }
        catch (NoSuchMethodException e) {
            ServerInfoAPI.LOGGER.error("Class {} must have a public no-argument constructor for configuration.", (Object)as.getName(), (Object)e);
            throw new RuntimeException("Configuration class " + as.getName() + " must have a public no-argument constructor.", e);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            ServerInfoAPI.LOGGER.error("Failed to create instance of config class {}.", (Object)as.getName(), (Object)e);
            throw new RuntimeException("Failed to instantiate configuration class " + as.getName(), e);
        }
        ConfigSettings annotation = this.clazz.getAnnotation(ConfigSettings.class);
        this.fileName = annotation.fileName();
        this.configFile = new File(this.getPath());
    }

    public T getData() {
        return this.instance;
    }

    public String getPath() {
        return "config/Server Info API/" + this.fileName;
    }

    public void load() {
        if (!this.configFile.exists()) {
            ServerInfoAPI.LOGGER.warn("Config file {} not exist, creating", (Object)this.getPath());
            this.save();
        } else {
            try (FileReader reader = new FileReader(this.configFile);){
                this.instance = ServerInfoAPI.GSON.fromJson((Reader)reader, this.clazz);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        ServerInfoAPI.LOGGER.debug("Loaded config:\n{}", (Object)ServerInfoAPI.GSON.toJson(this.instance));
    }

    public void save() {
        try {
            this.configFile.getParentFile().mkdirs();
            try (FileWriter writer = new FileWriter(this.configFile);){
                ServerInfoAPI.GSON.toJson(this.instance, (Appendable)writer);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

