/*
 * Decompiled with CFR 0.152.
 */
package com.example.silentban;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.plugin.java.JavaPlugin;

public class SilentBan
extends JavaPlugin
implements Listener {
    private File bannedPlayersFile;
    private FileConfiguration bannedPlayersConfig;
    private String kickMessage;

    @Override
    public void onEnable() {
        this.saveDefaultConfig();
        if (!this.getDataFolder().exists()) {
            this.getDataFolder().mkdirs();
        }
        this.bannedPlayersFile = new File(this.getDataFolder(), "bannedplayers.yml");
        if (!this.bannedPlayersFile.exists()) {
            try {
                this.bannedPlayersFile.createNewFile();
                YamlConfiguration defaultConfig = new YamlConfiguration();
                defaultConfig.set("banned-players", new ArrayList());
                defaultConfig.set("ban-reasons", new YamlConfiguration());
                defaultConfig.save(this.bannedPlayersFile);
            }
            catch (IOException e) {
                this.getLogger().log(Level.SEVERE, "Could not create bannedplayers.yml", e);
            }
        }
        this.bannedPlayersConfig = YamlConfiguration.loadConfiguration(this.bannedPlayersFile);
        this.kickMessage = this.getConfig().getString("kick-message", "There's been an error in your connection. Please try again later.");
        this.getServer().getPluginManager().registerEvents(this, this);
        this.registerCommand("sban", new SilentBanCommand());
        this.registerCommand("sunban", new SilentUnbanCommand());
        this.registerCommand("sbanlist", new SilentBanListCommand());
        this.getLogger().info("SilentBan has been enabled!");
    }

    private void registerCommand(String name, CommandExecutor executor) {
        PluginCommand command = this.getCommand(name);
        if (command != null) {
            command.setExecutor(executor);
        } else {
            this.getLogger().warning("Could not register command: " + name);
        }
    }

    @Override
    public void onDisable() {
        this.saveBannedPlayersConfig();
        this.getLogger().info("SilentBan has been disabled!");
    }

    @EventHandler
    public void onPlayerLogin(PlayerLoginEvent event) {
        Player player = event.getPlayer();
        String playerName = player.getName();
        UUID uuid = player.getUniqueId();
        List<String> bannedPlayers = this.bannedPlayersConfig.getStringList("banned-players");
        for (String entry : bannedPlayers) {
            if (!entry.equals(uuid.toString() + ":" + playerName) && !entry.toLowerCase().equals("name:" + playerName.toLowerCase())) continue;
            event.disallow(PlayerLoginEvent.Result.KICK_OTHER, this.kickMessage);
            if (this.getConfig().getBoolean("log-to-console", true)) {
                this.getLogger().info("Blocked login attempt by silently banned player: " + playerName);
            }
            return;
        }
    }

    private void saveBannedPlayersConfig() {
        try {
            this.bannedPlayersConfig.save(this.bannedPlayersFile);
        }
        catch (IOException e) {
            this.getLogger().severe("Could not save banned players file!");
            e.printStackTrace();
        }
    }

    private class SilentBanCommand
    implements CommandExecutor {
        private SilentBanCommand() {
        }

        @Override
        public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
            Object banKey;
            String entry;
            if (!sender.hasPermission("silentban.ban")) {
                sender.sendMessage("\u00a7cYou don't have permission to use this command.");
                return true;
            }
            if (args.length < 1) {
                sender.sendMessage("\u00a7cUsage: /sban <player> [reason]");
                return true;
            }
            String playerName = args[0];
            String reason = args.length > 1 ? String.join((CharSequence)" ", args).substring(args[0].length() + 1) : "No reason specified";
            Player targetPlayer = SilentBan.this.getServer().getPlayer(playerName);
            UUID uuid = null;
            if (targetPlayer != null) {
                uuid = targetPlayer.getUniqueId();
                playerName = targetPlayer.getName();
            } else {
                sender.sendMessage("\u00a7eWarning: Player not online. Using name-based ban instead of UUID.");
            }
            List<String> bannedPlayers = SilentBan.this.bannedPlayersConfig.getStringList("banned-players");
            if (uuid != null) {
                entry = uuid.toString() + ":" + playerName;
                banKey = uuid.toString();
            } else {
                entry = "name:" + playerName.toLowerCase();
                banKey = "name:" + playerName.toLowerCase();
            }
            if (!bannedPlayers.contains(entry)) {
                bannedPlayers.add(entry);
            }
            SilentBan.this.bannedPlayersConfig.set("banned-players", bannedPlayers);
            SilentBan.this.bannedPlayersConfig.set("ban-reasons." + ((String)banKey).replace(".", "_"), reason);
            SilentBan.this.saveBannedPlayersConfig();
            if (targetPlayer != null) {
                targetPlayer.kickPlayer(SilentBan.this.kickMessage);
            }
            sender.sendMessage("\u00a7aPlayer " + playerName + " has been silently banned. Reason: " + reason);
            return true;
        }
    }

    private class SilentUnbanCommand
    implements CommandExecutor {
        private SilentUnbanCommand() {
        }

        @Override
        public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
            if (!sender.hasPermission("silentban.unban")) {
                sender.sendMessage("\u00a7cYou don't have permission to use this command.");
                return true;
            }
            if (args.length < 1) {
                sender.sendMessage("\u00a7cUsage: /sunban <player>");
                return true;
            }
            String playerName = args[0];
            List<String> bannedPlayers = SilentBan.this.bannedPlayersConfig.getStringList("banned-players");
            ArrayList<String> newBannedPlayers = new ArrayList<String>();
            boolean found = false;
            Object banKey = null;
            for (String entry : bannedPlayers) {
                if (entry.toLowerCase().endsWith(":" + playerName.toLowerCase()) || entry.toLowerCase().equals("name:" + playerName.toLowerCase())) {
                    found = true;
                    String[] parts = entry.split(":");
                    if (parts[0].equals("name")) {
                        banKey = "name:" + playerName.toLowerCase();
                        continue;
                    }
                    banKey = parts[0];
                    continue;
                }
                newBannedPlayers.add(entry);
            }
            if (!found) {
                sender.sendMessage("\u00a7cPlayer " + playerName + " is not silently banned.");
                return true;
            }
            SilentBan.this.bannedPlayersConfig.set("banned-players", newBannedPlayers);
            if (banKey != null) {
                SilentBan.this.bannedPlayersConfig.set("ban-reasons." + ((String)banKey).replace(".", "_"), null);
            }
            SilentBan.this.saveBannedPlayersConfig();
            sender.sendMessage("\u00a7aPlayer " + playerName + " has been silently unbanned.");
            return true;
        }
    }

    private class SilentBanListCommand
    implements CommandExecutor {
        private SilentBanListCommand() {
        }

        @Override
        public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
            if (!sender.hasPermission("silentban.list")) {
                sender.sendMessage("\u00a7cYou don't have permission to use this command.");
                return true;
            }
            List<String> bannedPlayers = SilentBan.this.bannedPlayersConfig.getStringList("banned-players");
            if (bannedPlayers.isEmpty()) {
                sender.sendMessage("\u00a7eThere are no silently banned players.");
                return true;
            }
            sender.sendMessage("\u00a7eSilently banned players (" + bannedPlayers.size() + "):");
            for (String entry : bannedPlayers) {
                String banKey;
                String playerName;
                if (entry.startsWith("name:")) {
                    playerName = entry.substring(5);
                    banKey = entry;
                } else {
                    String[] parts = entry.split(":");
                    playerName = parts.length > 1 ? parts[1] : parts[0];
                    banKey = parts[0];
                }
                String reason = SilentBan.this.bannedPlayersConfig.getString("ban-reasons." + banKey.replace(".", "_"), "No reason specified");
                sender.sendMessage("\u00a77- \u00a7f" + playerName + " \u00a77(Reason: \u00a7f" + reason + "\u00a77)");
            }
            return true;
        }
    }
}

