/*
 * Decompiled with CFR 0.152.
 */
package cherrysamuraitemple.init;

import cherrysamuraitemple.entity.SamuraiEntity;
import cherrysamuraitemple.entity.SteveSamuraiEntity;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber
public class CherrySamuraiTempleModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"cherry_samurai_temple");
    public static final DeferredHolder<EntityType<?>, EntityType<SamuraiEntity>> SAMURAI = CherrySamuraiTempleModEntities.register("samurai", EntityType.Builder.of(SamuraiEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).ridingOffset(-0.6f).sized(0.6f, 1.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<SteveSamuraiEntity>> STEVE_SAMURAI = CherrySamuraiTempleModEntities.register("steve_samurai", EntityType.Builder.of(SteveSamuraiEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).ridingOffset(-0.6f).sized(0.6f, 1.8f));

    private static <T extends Entity> DeferredHolder<EntityType<?>, EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.build(ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"cherry_samurai_temple", (String)registryname))));
    }

    @SubscribeEvent
    public static void init(RegisterSpawnPlacementsEvent event) {
        SamuraiEntity.init(event);
        SteveSamuraiEntity.init(event);
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)SAMURAI.get(), SamuraiEntity.createAttributes().build());
        event.put((EntityType)STEVE_SAMURAI.get(), SteveSamuraiEntity.createAttributes().build());
    }
}

