/*
 * Decompiled with CFR 0.152.
 */
package com.minecraft.betterstaff;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;

public class BetterStaff
extends JavaPlugin
implements Listener {
    private Map<String, String> staffRanks;
    private Map<UUID, String> staffMembers;
    private boolean tabListEnabled;
    private String staffCountFormat;
    private String noStaffOnlineMessage;
    private String staffListHeader;
    private String staffListFormat;
    private String reloadMessage;

    @Override
    public void onEnable() {
        this.saveDefaultConfig();
        this.staffRanks = new HashMap<String, String>();
        this.staffMembers = new HashMap<UUID, String>();
        this.loadConfig();
        this.getServer().getPluginManager().registerEvents(this, this);
        this.setupTabListTask();
        this.getLogger().info("BetterStaff has been enabled!");
    }

    @Override
    public void onDisable() {
        this.getLogger().info("BetterStaff has been disabled!");
    }

    private void loadConfig() {
        FileConfiguration config = this.getConfig();
        this.tabListEnabled = config.getBoolean("tab-list.enabled", true);
        this.staffCountFormat = ChatColor.translateAlternateColorCodes('&', config.getString("messages.staff-count-format", "&a&lStaff Online: &f{count}"));
        this.noStaffOnlineMessage = ChatColor.translateAlternateColorCodes('&', config.getString("messages.no-staff-online", "&c&lNo staff members are currently online."));
        this.staffListHeader = ChatColor.translateAlternateColorCodes('&', config.getString("messages.staff-list-header", "&6&l=== Staff Online ==="));
        this.staffListFormat = ChatColor.translateAlternateColorCodes('&', config.getString("messages.staff-list-format", "&7- {rank}: &f{name}"));
        this.reloadMessage = ChatColor.translateAlternateColorCodes('&', config.getString("messages.reload", "&a&lBetterStaff configuration reloaded successfully!"));
        this.staffRanks.clear();
        for (String rankKey : config.getConfigurationSection("ranks").getKeys(false)) {
            String prefix = ChatColor.translateAlternateColorCodes('&', config.getString("ranks." + rankKey + ".prefix", ""));
            this.staffRanks.put(rankKey, prefix);
        }
        this.staffMembers.clear();
        for (String rankKey : config.getConfigurationSection("staff").getKeys(false)) {
            List<String> members = config.getStringList("staff." + rankKey);
            for (String name : members) {
                try {
                    UUID uuid = Bukkit.getOfflinePlayer(name).getUniqueId();
                    this.staffMembers.put(uuid, rankKey);
                }
                catch (Exception e) {
                    this.getLogger().warning("Could not find player: " + name);
                }
            }
        }
    }

    private void setupTabListTask() {
        if (this.tabListEnabled) {
            Bukkit.getScheduler().runTaskTimer((Plugin)this, this::updateTabList, 20L, 100L);
        }
    }

    private void updateTabList() {
        Team team;
        Scoreboard scoreboard = Bukkit.getScoreboardManager().getMainScoreboard();
        for (String string : this.staffRanks.keySet()) {
            team = scoreboard.getTeam("staff_" + string);
            if (team == null) continue;
            team.unregister();
        }
        for (String string : this.staffRanks.keySet()) {
            team = scoreboard.registerNewTeam("staff_" + string);
            String prefix = this.staffRanks.get(string);
            team.setPrefix(prefix + " ");
            team.setColor(ChatColor.getByChar(prefix.charAt(1)));
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            String rank;
            Team team2;
            UUID uuid = player.getUniqueId();
            if (!this.staffMembers.containsKey(uuid) || (team2 = scoreboard.getTeam("staff_" + (rank = this.staffMembers.get(uuid)))) == null) continue;
            team2.addEntry(player.getName());
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (this.staffMembers.containsKey(player.getUniqueId())) {
            Bukkit.getScheduler().runTaskLater((Plugin)this, () -> {
                this.updateTabList();
                if (player.hasPermission("betterstaff.staff")) {
                    for (Player player2 : Bukkit.getOnlinePlayers()) {
                        if (!player2.hasPermission("betterstaff.notify")) continue;
                        player2.sendMessage(String.valueOf((Object)ChatColor.GREEN) + player.getName() + " has joined as " + this.staffMembers.get(player.getUniqueId()) + "!");
                    }
                }
            }, 10L);
        }
    }

    @Override
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (command.getName().equalsIgnoreCase("betterstaff")) {
            if (args.length == 0) {
                this.showStaffList(sender);
                return true;
            }
            if (args.length == 1 && args[0].equalsIgnoreCase("reload")) {
                if (sender.hasPermission("betterstaff.reload")) {
                    this.reloadConfig();
                    this.loadConfig();
                    this.updateTabList();
                    sender.sendMessage(this.reloadMessage);
                } else {
                    sender.sendMessage(String.valueOf((Object)ChatColor.RED) + "You don't have permission to reload the plugin!");
                }
                return true;
            }
        }
        return false;
    }

    private void showStaffList(CommandSender sender) {
        UUID uuid;
        ArrayList<Player> onlineStaff = new ArrayList<Player>();
        for (Player player : Bukkit.getOnlinePlayers()) {
            uuid = player.getUniqueId();
            if (!this.staffMembers.containsKey(uuid)) continue;
            onlineStaff.add(player);
        }
        if (onlineStaff.isEmpty()) {
            sender.sendMessage(this.noStaffOnlineMessage);
            return;
        }
        sender.sendMessage(this.staffCountFormat.replace("{count}", String.valueOf(onlineStaff.size())));
        sender.sendMessage(this.staffListHeader);
        for (Player player : onlineStaff) {
            uuid = player.getUniqueId();
            String rank = this.staffMembers.get(uuid);
            sender.sendMessage(this.staffListFormat.replace("{rank}", rank).replace("{name}", player.getName()));
        }
    }
}

