/*
 * Decompiled with CFR 0.152.
 */
package rearth.belts.client.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import rearth.belts.BlockEntitiesContent;
import rearth.belts.blocks.ChuteBlockEntity;
import rearth.belts.util.MathHelpers;
import rearth.belts.util.SplineUtil;

public class ChuteBeltRenderer
implements BlockEntityRenderer<ChuteBlockEntity> {
    private static final HashMap<Long, Integer> lightmapCache = new HashMap();

    public void render(ChuteBlockEntity entity, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        if (entity == null || entity.getLevel() == null) {
            return;
        }
        if (entity.getTarget() == null || entity.getTarget().distManhattan((Vec3i)entity.getBlockPos()) < 1) {
            return;
        }
        Optional targetCandidate = entity.getLevel().getBlockEntity(entity.getTarget(), (BlockEntityType)BlockEntitiesContent.CHUTE_BLOCK.get());
        if (targetCandidate.isEmpty()) {
            return;
        }
        ChuteBlockEntity.BeltData beltData = entity.getBeltData();
        if (beltData == null) {
            return;
        }
        int itemRenderDistSq = 4096;
        int beltRenderDistSq = 9216;
        this.renderBeltMesh(entity, matrices, vertexConsumers, overlay, targetCandidate, beltRenderDistSq);
        this.renderBeltItems(entity, matrices, vertexConsumers, overlay, beltData, itemRenderDistSq);
        this.renderBeltFilter(entity, matrices, vertexConsumers, light, overlay, beltRenderDistSq);
    }

    private void renderBeltMesh(ChuteBlockEntity entity, PoseStack matrices, MultiBufferSource vertexConsumers, int overlay, Optional<ChuteBlockEntity> targetCandidate, int beltRenderDistSq) {
        matrices.pushPose();
        matrices.translate(0.0f, -0.045f, 0.0f);
        PoseStack.Pose entry = matrices.last();
        Matrix4f modelMatrix = entry.pose();
        VertexConsumer consumer = vertexConsumers.getBuffer(RenderType.solid());
        int lightRefreshInterval = 82;
        Quad[] quads = this.getOrComputeModel(entity, targetCandidate.get());
        if (quads == null) {
            matrices.popPose();
            return;
        }
        int lastLight = LevelRenderer.getLightColor((BlockAndTintGetter)entity.getLevel(), (BlockPos)entity.getBlockPos());
        for (Quad quad : quads) {
            BlockPos worldPos = quad.worldPos;
            double camDist = Minecraft.getInstance().getCameraEntity().position().distanceToSqr(Vec3.atLowerCornerOf((Vec3i)worldPos));
            if (camDist > (double)beltRenderDistSq) continue;
            Integer worldLight = lightmapCache.computeIfAbsent(quad.worldPos.asLong(), pos -> LevelRenderer.getLightColor((BlockAndTintGetter)entity.getLevel(), (BlockPos)worldPos));
            if (entity.getLevel().getGameTime() % (long)lightRefreshInterval == 0L) {
                lightmapCache.put(quad.worldPos.asLong(), LevelRenderer.getLightColor((BlockAndTintGetter)entity.getLevel(), (BlockPos)quad.worldPos));
            }
            Vertex renderedVertex = quad.a;
            consumer.addVertex(modelMatrix, renderedVertex.x, renderedVertex.y, renderedVertex.z).setColor(-1).setUv(renderedVertex.u, renderedVertex.v).setNormal(entry, 0.0f, 1.0f, 0.0f).setLight(worldLight.intValue()).setOverlay(overlay);
            renderedVertex = quad.b;
            consumer.addVertex(modelMatrix, renderedVertex.x, renderedVertex.y, renderedVertex.z).setColor(-1).setUv(renderedVertex.u, renderedVertex.v).setNormal(entry, 0.0f, 1.0f, 0.0f).setLight(worldLight.intValue()).setOverlay(overlay);
            renderedVertex = quad.c;
            consumer.addVertex(modelMatrix, renderedVertex.x, renderedVertex.y, renderedVertex.z).setColor(-1).setUv(renderedVertex.u, renderedVertex.v).setNormal(entry, 0.0f, 1.0f, 0.0f).setLight(lastLight).setOverlay(overlay);
            renderedVertex = quad.d;
            consumer.addVertex(modelMatrix, renderedVertex.x, renderedVertex.y, renderedVertex.z).setColor(-1).setUv(renderedVertex.u, renderedVertex.v).setNormal(entry, 0.0f, 1.0f, 0.0f).setLight(lastLight).setOverlay(overlay);
            lastLight = worldLight;
        }
        matrices.popPose();
    }

    private Quad[] getOrComputeModel(ChuteBlockEntity entity, ChuteBlockEntity target) {
        if (entity.renderedModel == null) {
            entity.renderedModel = ChuteBeltRenderer.createSplineModel(entity, target);
        }
        return entity.renderedModel;
    }

    private static Quad[] createSplineModel(ChuteBlockEntity entity, ChuteBlockEntity target) {
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(ResourceLocation.fromNamespaceAndPath((String)"belts", (String)"block/conveyorbelt"));
        ArrayList<Quad> result = new ArrayList<Quad>();
        ChuteBlockEntity.BeltData beltData = entity.getBeltData();
        if (beltData == null) {
            return null;
        }
        float segmentSize = 0.75f;
        int segmentCount = (int)Math.ceil(beltData.totalLength() / (double)segmentSize);
        float lineWidth = 0.33f;
        Vec3 conveyorStartDir = Vec3.atLowerCornerOf((Vec3i)entity.getOwnFacing().getNormal());
        Vec3 conveyorEndDir = Vec3.atLowerCornerOf((Vec3i)target.getOwnFacing().getOpposite().getNormal());
        Vec3 beginRight = conveyorStartDir.cross(new Vec3(0.0, 1.0, 0.0)).normalize();
        Vec3 localStart = new Vec3(0.5, 0.5, 0.5).add(conveyorStartDir.scale(-0.5));
        Vec3 lastRight = localStart.add(beginRight.scale((double)lineWidth));
        Vec3 lastLeft = localStart.add(beginRight.scale((double)(-lineWidth)));
        for (int i = 0; i < segmentCount; ++i) {
            Vec3 dirB;
            boolean last = i == segmentCount - 1;
            float progress = (float)i / (float)segmentCount;
            float nextProgress = (float)(i + 1) / (float)segmentCount;
            Vec3 worldPoint = SplineUtil.getPositionOnSpline(beltData, progress);
            Vec3 localPoint = worldPoint.subtract(entity.getBlockPos().getCenter());
            Vec3 worldPointNext = SplineUtil.getPositionOnSpline(beltData, nextProgress);
            Vec3 localPointNext = worldPointNext.subtract(entity.getBlockPos().getCenter());
            BlockPos worldPos = BlockPos.containing((Position)worldPointNext.add(0.5, 0.0, 0.5));
            Vec3 direction = localPointNext.subtract(localPoint);
            Vec3 cross = direction.cross(new Vec3(0.0, 1.0, 0.0)).normalize();
            if (last) {
                cross = conveyorEndDir.cross(new Vec3(0.0, 1.0, 0.0)).normalize();
            }
            Vec3 nextRight = localPointNext.add(cross.scale((double)lineWidth)).add(0.5, 0.5, 0.5);
            Vec3 nextLeft = localPointNext.add(cross.scale((double)(-lineWidth))).add(0.5, 0.5, 0.5);
            Vec3 dirA = lastLeft.subtract(lastRight).normalize();
            double curveStrength = 1.0 - Math.abs(dirA.dot(dirB = nextLeft.subtract(nextRight).normalize()));
            if (curveStrength > 0.025) {
                float midProgress = ((float)i + 0.5f) / (float)segmentCount;
                Vec3 worldPointMid = SplineUtil.getPositionOnSpline(beltData, midProgress);
                Vec3 localPointMid = worldPointMid.subtract(entity.getBlockPos().getCenter());
                Vec3 directionMid = localPointMid.subtract(localPoint);
                Vec3 crossMid = directionMid.cross(new Vec3(0.0, 1.0, 0.0)).normalize();
                Vec3 midRight = localPointMid.add(crossMid.scale((double)lineWidth)).add(0.5, 0.5, 0.5);
                Vec3 midLeft = localPointMid.add(crossMid.scale((double)(-lineWidth))).add(0.5, 0.5, 0.5);
                direction = localPointNext.subtract(localPointMid);
                cross = direction.cross(new Vec3(0.0, 1.0, 0.0)).normalize();
                if (last) {
                    cross = conveyorEndDir.cross(new Vec3(0.0, 1.0, 0.0)).normalize();
                }
                nextRight = localPointNext.add(cross.scale((double)lineWidth)).add(0.5, 0.5, 0.5);
                nextLeft = localPointNext.add(cross.scale((double)(-lineWidth))).add(0.5, 0.5, 0.5);
                ChuteBeltRenderer.addSegmentVertices(midRight, lastRight, midLeft, lastLeft, sprite, worldPos, result, 0.0f, 0.5f);
                ChuteBeltRenderer.addSegmentVertices(nextRight, midRight, nextLeft, midLeft, sprite, worldPos, result, 0.5f, 1.0f);
            } else {
                ChuteBeltRenderer.addSegmentVertices(nextRight, lastRight, nextLeft, lastLeft, sprite, worldPos, result, 0.0f, 1.0f);
            }
            lastRight = nextRight;
            lastLeft = nextLeft;
        }
        return (Quad[])result.toArray(Quad[]::new);
    }

    private static void addSegmentVertices(Vec3 nextRight, Vec3 lastRight, Vec3 nextLeft, Vec3 lastLeft, TextureAtlasSprite sprite, BlockPos worldPos, ArrayList<Quad> result, float vStart, float vEnd) {
        float skirtHeight = 0.15f;
        float uMin = sprite.getU(0.0f);
        float uMax = sprite.getU(1.0f);
        float vMin = sprite.getV(vStart);
        float vMax = sprite.getV(vEnd);
        Vertex botRight = Vertex.create(lastRight, uMin, vMin);
        Vertex topRight = Vertex.create(nextRight, uMin, vMax);
        Vertex topLeft = Vertex.create(nextLeft, uMax, vMax);
        Vertex botLeft = Vertex.create(lastLeft, uMax, vMin);
        Quad quad = new Quad(topRight, topLeft, botLeft, botRight, worldPos);
        result.add(quad);
        uMin = sprite.getU(0.0f);
        uMax = sprite.getU(0.125f);
        vMin = sprite.getV(vStart);
        vMax = sprite.getV(vEnd);
        topRight = Vertex.create(nextRight.add(0.0, (double)(-skirtHeight), 0.0), uMax, vMax);
        topLeft = Vertex.create(nextRight, uMin, vMax);
        botLeft = Vertex.create(lastRight, uMin, vMin);
        botRight = Vertex.create(lastRight.add(0.0, (double)(-skirtHeight), 0.0), uMax, vMin);
        quad = new Quad(topRight, topLeft, botLeft, botRight, worldPos);
        result.add(quad);
        uMin = sprite.getU(0.0f);
        uMax = sprite.getU(0.125f);
        vMin = sprite.getV(vStart);
        vMax = sprite.getV(vEnd);
        topRight = Vertex.create(nextLeft.add(0.0, (double)(-skirtHeight), 0.0), uMax, vMax);
        topLeft = Vertex.create(nextLeft, uMin, vMax);
        botLeft = Vertex.create(lastLeft, uMin, vMin);
        botRight = Vertex.create(lastLeft.add(0.0, (double)(-skirtHeight), 0.0), uMax, vMin);
        quad = new Quad(botRight, botLeft, topLeft, topRight, worldPos);
        result.add(quad);
        uMin = sprite.getU(0.0f);
        uMax = sprite.getU(1.0f);
        vMin = sprite.getV(vStart);
        vMax = sprite.getV(vEnd);
        botRight = Vertex.create(lastRight.add(0.0, (double)(-skirtHeight), 0.0), uMin, vMin);
        topRight = Vertex.create(nextRight.add(0.0, (double)(-skirtHeight), 0.0), uMin, vMax);
        topLeft = Vertex.create(nextLeft.add(0.0, (double)(-skirtHeight), 0.0), uMax, vMax);
        botLeft = Vertex.create(lastLeft.add(0.0, (double)(-skirtHeight), 0.0), uMax, vMin);
        quad = new Quad(botRight, botLeft, topLeft, topRight, worldPos);
        result.add(quad);
    }

    private void renderBeltItems(ChuteBlockEntity entity, PoseStack matrices, MultiBufferSource vertexConsumers, int overlay, ChuteBlockEntity.BeltData beltData, int itemRenderDistSq) {
        Iterable<ChuteBlockEntity.BeltItem> renderedItems = this.getRenderedStacks(entity);
        for (ChuteBlockEntity.BeltItem itemData : renderedItems) {
            boolean useItemTransform;
            ItemStack renderedStack = itemData.stack;
            float renderedProgress = itemData.progress;
            double delta = (double)0.05f / beltData.totalLength();
            double nextProgress = (double)itemData.progress + delta;
            Vec3 worldPoint = SplineUtil.getPositionOnSpline(beltData, renderedProgress);
            Entity cam = Minecraft.getInstance().getCameraEntity();
            double camDist = cam.position().distanceToSqr(worldPoint);
            if (camDist > (double)itemRenderDistSq) continue;
            Vec3 camLookDir = cam.getLookAngle();
            Vec3 itemOffset = worldPoint.subtract(cam.position());
            if (camDist > 1.0 && camLookDir.dot(itemOffset.normalize()) < 0.0) continue;
            Vec3 nextWorldPoint = SplineUtil.getPositionOnSpline(beltData, nextProgress);
            Vec3 localPoint = worldPoint.subtract(entity.getBlockPos().getCenter());
            Vec3 lastRenderPosition = entity.lastRenderedPositions.getOrDefault(itemData.id, localPoint);
            Vec3 renderPosition = MathHelpers.lerp(lastRenderPosition, localPoint, 0.03f);
            entity.lastRenderedPositions.put(itemData.id, renderPosition);
            Vec3 forward = nextWorldPoint.subtract(worldPoint);
            Vec3 flatForward = new Vec3(forward.x, 0.0, forward.z).normalize();
            double dot = new Vec3(1.0, 0.0, 0.0).dot(flatForward);
            double angleRad = Math.acos(dot);
            double angleUp = Math.acos(forward.normalize().dot(flatForward));
            if (forward.y < 0.0) {
                angleUp = -angleUp;
            }
            if (flatForward.z > 0.0) {
                angleRad = -angleRad;
            }
            matrices.pushPose();
            matrices.translate(renderPosition.x, renderPosition.y, renderPosition.z);
            matrices.translate(0.5f, 0.6125f, 0.5f);
            BakedModel bakedmodel = Minecraft.getInstance().getItemRenderer().getModel(renderedStack, entity.getLevel(), null, 0);
            boolean bl = useItemTransform = !bakedmodel.getQuads(null, null, entity.getLevel().random).isEmpty();
            if (useItemTransform) {
                matrices.translate(0.0f, -0.125f, 0.0f);
                matrices.scale(0.8f, 0.8f, 0.8f);
            }
            matrices.mulPose(Axis.YP.rotationDegrees((float)Math.toDegrees(angleRad)));
            if (Math.abs(angleUp) > (double)0.01f) {
                matrices.mulPose(Axis.ZP.rotationDegrees((float)Math.toDegrees(angleUp)));
            }
            matrices.mulPose(Axis.XP.rotationDegrees(90.0f));
            matrices.scale(0.6f, 0.6f, 0.6f);
            BlockPos worldPos = BlockPos.containing((Position)worldPoint);
            Integer worldLight = lightmapCache.computeIfAbsent(worldPos.asLong(), pos -> LevelRenderer.getLightColor((BlockAndTintGetter)entity.getLevel(), (BlockPos)worldPos));
            Minecraft.getInstance().getItemRenderer().renderStatic(renderedStack, ItemDisplayContext.FIXED, worldLight.intValue(), overlay, matrices, vertexConsumers, entity.getLevel(), 0);
            matrices.popPose();
        }
        if (entity.getLevel().getGameTime() % 104L == 0L) {
            this.cleanPositionsCache(entity);
        }
    }

    private void renderBeltFilter(ChuteBlockEntity entity, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay, int itemRenderDistSq) {
        ItemStack renderedStack = entity.filteredItem;
        if (renderedStack.isEmpty()) {
            return;
        }
        Vec3 worldPoint = entity.getBlockPos().getCenter();
        Entity cam = Minecraft.getInstance().getCameraEntity();
        double camDist = cam.position().distanceToSqr(worldPoint);
        if (camDist > (double)itemRenderDistSq) {
            return;
        }
        Vec3 camLookDir = cam.getLookAngle();
        Vec3 itemOffset = worldPoint.subtract(cam.position());
        if (camDist > 5.0 && camLookDir.dot(itemOffset.normalize()) < 0.0) {
            return;
        }
        Direction ownFacing = entity.getOwnFacing();
        Vec3 forwardDir = Vec3.atLowerCornerOf((Vec3i)ownFacing.getNormal());
        Vec3 renderOffset = forwardDir.scale((double)-0.43f);
        matrices.pushPose();
        matrices.translate(0.5f, 0.7f, 0.5f);
        matrices.translate(renderOffset.x, renderOffset.y, renderOffset.z);
        if (ownFacing.getAxis().equals((Object)Direction.Axis.X)) {
            matrices.mulPose(Axis.YP.rotationDegrees(90.0f));
        }
        matrices.scale(0.4f, 0.4f, 0.4f);
        Minecraft.getInstance().getItemRenderer().renderStatic(renderedStack, ItemDisplayContext.FIXED, light, overlay, matrices, vertexConsumers, entity.getLevel(), 0);
        matrices.popPose();
    }

    private Iterable<ChuteBlockEntity.BeltItem> getRenderedStacks(ChuteBlockEntity entity) {
        return entity.getMovingItems();
    }

    private void cleanPositionsCache(ChuteBlockEntity entity) {
        Iterable<ChuteBlockEntity.BeltItem> active = this.getRenderedStacks(entity);
        Map<Short, Vec3> cache = entity.lastRenderedPositions;
        HashMap<Short, Vec3> usedData = new HashMap<Short, Vec3>();
        for (ChuteBlockEntity.BeltItem movedItem : active) {
            Vec3 lastEntry = cache.getOrDefault(movedItem.id, Vec3.ZERO);
            usedData.put(movedItem.id, lastEntry);
        }
        cache.clear();
        cache.putAll(usedData);
    }

    public boolean rendersOutsideBoundingBox(ChuteBlockEntity blockEntity) {
        return true;
    }

    public int getViewDistance() {
        return 96;
    }

    public AABB getRenderBoundingBox(BlockEntity blockEntity) {
        return new AABB(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    public record Quad(Vertex a, Vertex b, Vertex c, Vertex d, BlockPos worldPos) {
    }

    public record Vertex(float x, float y, float z, float u, float v) {
        public static Vertex create(Vec3 pos, float u, float v) {
            return new Vertex((float)pos.x, (float)pos.y, (float)pos.z, u, v);
        }
    }
}

