/*
 * Decompiled with CFR 0.152.
 */
package rearth.belts.blocks;

import dev.architectury.platform.Platform;
import dev.ftb.mods.ftbfiltersystem.api.FTBFilterSystemAPI;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2383;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3545;
import net.minecraft.class_5558;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;
import rearth.belts.BlockContent;
import rearth.belts.BlockEntitiesContent;
import rearth.belts.ItemContent;
import rearth.belts.api.item.ItemApi;
import rearth.belts.client.renderers.ChuteBeltRenderer;
import rearth.belts.util.SplineUtil;

public class ChuteBlockEntity
extends class_2586
implements class_5558<ChuteBlockEntity> {
    private class_2338 target;
    private List<class_2338> midPoints = new ArrayList<class_2338>();
    private final Deque<BeltItem> movingItems = new ArrayDeque<BeltItem>();
    private int outputQueue = 0;
    private BeltData beltData;
    private long lastTargetedTime;
    private class_2338 sourceBeltPos = class_2338.field_10980;
    public class_1799 filteredItem = class_1799.field_8037;
    public ChuteBeltRenderer.Quad[] renderedModel;
    public Map<Short, class_243> lastRenderedPositions = new HashMap<Short, class_243>();
    private boolean networkDirty = false;

    public ChuteBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591)BlockEntitiesContent.CHUTE_BLOCK.get(), pos, state);
    }

    public void tick(class_1937 world, class_2338 pos, class_2680 state, ChuteBlockEntity blockEntity) {
        class_3218 serverWorld;
        if (world == null) {
            return;
        }
        if (this.target == null || this.target.equals((Object)class_2338.field_10980)) {
            if (!world.field_9236 && !this.movingItems.isEmpty()) {
                this.dropContent(world, pos);
            }
            return;
        }
        if (this.beltData == null) {
            this.beltData = BeltData.create(this);
            if (world instanceof class_3218) {
                serverWorld = (class_3218)world;
                serverWorld.method_14178().method_14128(pos);
            }
        }
        if (this.beltData == null) {
            this.target = null;
            this.midPoints = new ArrayList<class_2338>();
            return;
        }
        if (world.field_9236) {
            return;
        }
        this.moveItemsOnBelt();
        this.loadItemsOnBelt();
        if (world.method_8510() % 19L == 0L) {
            this.assignTargetState(world);
        }
        if (this.networkDirty && world instanceof class_3218) {
            serverWorld = (class_3218)world;
            serverWorld.method_14178().method_14128(pos);
            this.networkDirty = false;
        }
    }

    public void dropContent(class_1937 world, class_2338 pos) {
        if (world.method_8510() - this.lastTargetedTime < 20L && !this.sourceBeltPos.equals((Object)class_2338.field_10980) && world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            Optional sourceEntityCandidate = world.method_35230(this.sourceBeltPos, (class_2591)BlockEntitiesContent.CHUTE_BLOCK.get());
            if (sourceEntityCandidate.isPresent() && sourceEntityCandidate.get() != this) {
                ChuteBlockEntity source = (ChuteBlockEntity)((Object)sourceEntityCandidate.get());
                source.dropContent(world, pos);
                source.target = null;
                serverWorld.method_14178().method_14128(this.sourceBeltPos);
                source.networkDirty = true;
                source.method_5431();
            }
        }
        for (BeltItem beltItem : this.movingItems) {
            class_1799 stack = beltItem.stack;
            class_243 spawnAt = pos.method_46558();
            world.method_8649((class_1297)new class_1542(world, spawnAt.field_1352, spawnAt.field_1351, spawnAt.field_1350, stack));
        }
        if (!this.movingItems.isEmpty() || this.target != null && !this.target.equals((Object)class_2338.field_10980)) {
            class_1799 stack = new class_1799((class_1935)ItemContent.BELT.get(), 1);
            class_243 spawnAt = pos.method_46558();
            world.method_8649((class_1297)new class_1542(world, spawnAt.field_1352, spawnAt.field_1351, spawnAt.field_1350, stack));
        }
        this.movingItems.clear();
    }

    private void assignTargetState(class_1937 world) {
        Optional beltTargetCandidate = world.method_35230(this.target, (class_2591)BlockEntitiesContent.CHUTE_BLOCK.get());
        if (beltTargetCandidate.isPresent()) {
            ((ChuteBlockEntity)((Object)beltTargetCandidate.get())).lastTargetedTime = world.method_8510();
            ((ChuteBlockEntity)((Object)beltTargetCandidate.get())).sourceBeltPos = this.field_11867;
        } else {
            this.target = null;
            this.midPoints = new ArrayList<class_2338>();
        }
    }

    private void moveItemsOnBelt() {
        double beltLength = this.beltData.totalLength();
        float beltSpeed = 1.0f;
        double progressDelta = (double)beltSpeed / beltLength / 20.0;
        boolean unloaded = false;
        this.outputQueue = 0;
        for (BeltItem pair : this.movingItems.reversed()) {
            class_1799 insertionStack;
            int insertedAmount;
            ChuteBlockEntity conveyorEndEntity;
            ItemApi.InventoryStorage targetInv;
            Optional conveyorEndEntityCandidate;
            boolean inQueue;
            float itemProgress = pair.progress;
            double newProgress = (double)itemProgress + progressDelta;
            boolean bl = inQueue = newProgress >= (double)this.getPotentialQueueStart();
            if (inQueue) {
                ++this.outputQueue;
            } else {
                pair.progress = (float)newProgress;
                this.networkDirty = true;
            }
            if (!inQueue || this.outputQueue != 1 || (conveyorEndEntityCandidate = this.field_11863.method_35230(this.target, (class_2591)BlockEntitiesContent.CHUTE_BLOCK.get())).isEmpty() || (targetInv = ItemApi.BLOCK.find(this.field_11863, this.target.method_10081((conveyorEndEntity = (ChuteBlockEntity)((Object)conveyorEndEntityCandidate.get())).getOwnFacing().method_10153().method_10163()), null, null, conveyorEndEntity.getOwnFacing())) == null || (insertedAmount = targetInv.insert(insertionStack = pair.stack, true)) != insertionStack.method_7947()) continue;
            targetInv.insert(insertionStack, false);
            this.outputQueue = 0;
            unloaded = true;
            this.networkDirty = true;
        }
        if (unloaded) {
            this.movingItems.removeLast();
        }
    }

    private void loadItemsOnBelt() {
        int extractionInterval = 26;
        long extractionOffset = this.field_11867.method_10063();
        if ((this.field_11863.method_8510() + extractionOffset) % (long)extractionInterval != 0L) {
            return;
        }
        if (this.getPotentialQueueStart() < 0.0f) {
            return;
        }
        ItemApi.InventoryStorage source = ItemApi.BLOCK.find(this.field_11863, this.field_11867.method_10081(this.getOwnFacing().method_10153().method_10163()), null, null, this.getOwnFacing());
        if (source != null) {
            class_1799 extracted = null;
            for (int i = 0; i < source.getSlotCount(); ++i) {
                class_1799 extractingStack = source.getStackInSlot(i).method_7972();
                if (extractingStack.method_7960() || !this.stackMatchesFilter(extractingStack)) continue;
                extractingStack.method_7939(Math.min(extractingStack.method_7947(), 64));
                int extractedAmount = source.extract(extractingStack, false);
                if (extractedAmount <= 0) continue;
                extracted = extractingStack.method_46651(extractedAmount);
                break;
            }
            if (extracted != null) {
                short id = (short)this.field_11863.field_9229.method_39332(Short.MIN_VALUE, Short.MAX_VALUE);
                this.movingItems.addFirst(new BeltItem(id, extracted));
                this.method_5431();
                this.networkDirty = true;
            }
        }
    }

    private boolean stackMatchesFilter(class_1799 stack) {
        FTBFilterSystemAPI.API filterAPI;
        if (this.filteredItem.method_7960()) {
            return true;
        }
        if (Platform.isModLoaded((String)"ftbfiltersystem") && (filterAPI = FTBFilterSystemAPI.api()).isFilterItem(this.filteredItem)) {
            return filterAPI.doesFilterMatch(this.filteredItem, stack);
        }
        return stack.method_7909().equals(this.filteredItem.method_7909());
    }

    private float getPotentialQueueStart() {
        float squashFactor = 0.8f;
        double beltLength = this.beltData.totalLength();
        int queueCount = this.outputQueue;
        double queueSize = (double)((float)queueCount * squashFactor) / beltLength;
        return (float)(1.0 - queueSize);
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        if (this.target != null) {
            nbt.method_10544("target", this.target.method_10063());
        }
        if (!this.midPoints.isEmpty()) {
            List<Long> midpointsArray = this.midPoints.stream().map(class_2338::method_10063).toList();
            nbt.method_10538("midpoints", midpointsArray);
        }
        nbt.method_10566("filter", this.filteredItem.method_57375(registryLookup));
        class_2499 positionsList = new class_2499();
        positionsList.addAll(this.movingItems.stream().map(pair -> {
            class_2487 compound = new class_2487();
            compound.method_10548("a", pair.progress);
            compound.method_10566("b", pair.stack.method_57358(registryLookup));
            compound.method_10575("id", pair.id);
            return compound;
        }).toList());
        nbt.method_10566("moving", (class_2520)positionsList);
    }

    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        this.target = class_2338.method_10092((long)nbt.method_10537("target"));
        long[] midPointsList = nbt.method_10565("midpoints");
        this.midPoints = Arrays.stream(midPointsList).mapToObj(class_2338::method_10092).toList();
        this.filteredItem = class_1799.method_57359((class_7225.class_7874)registryLookup, (class_2487)nbt.method_10562("filter"));
        class_2499 positions = nbt.method_10554("moving", 10);
        this.movingItems.clear();
        this.movingItems.addAll(positions.stream().map(element -> {
            class_2487 compound = (class_2487)element;
            float progress = compound.method_10583("a");
            short id = compound.method_10568("id");
            Optional stackCandidate = class_1799.method_57360((class_7225.class_7874)registryLookup, (class_2520)compound.method_10580("b"));
            class_1799 stack = stackCandidate.isEmpty() ? class_1799.field_8037 : (class_1799)stackCandidate.get();
            return new BeltItem(progress, id, stack);
        }).toList());
        if (this.field_11863 == null) {
            return;
        }
        this.beltData = BeltData.create(this);
        if (this.field_11863.field_9236) {
            this.renderedModel = null;
        }
    }

    public class_2487 method_16887(class_7225.class_7874 registryLookup) {
        class_2487 base = super.method_16887(registryLookup);
        this.method_11007(base, registryLookup);
        return base;
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public Iterable<BeltItem> getMovingItems() {
        return this.movingItems;
    }

    public class_2338 getTarget() {
        return this.target;
    }

    public BeltData getBeltData() {
        return this.beltData;
    }

    public class_2350 getOwnFacing() {
        return (class_2350)this.method_11010().method_11654((class_2769)class_2383.field_11177);
    }

    public boolean isUsed() {
        boolean usedAsTarget = this.field_11863.method_8510() - this.lastTargetedTime < 40L;
        boolean usedAsSource = this.target != null && !this.target.equals((Object)class_2338.field_10980);
        return usedAsTarget || usedAsSource;
    }

    public void assignFromBeltItem(class_2338 target, List<class_2338> midpoints) {
        this.target = target;
        this.midPoints = midpoints;
        this.beltData = BeltData.create(this);
        this.networkDirty = true;
        this.method_5431();
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            serverWorld.method_14178().method_14128(this.field_11867);
        }
    }

    public List<class_3545<class_2338, class_2350>> getMidPointsWithTangents() {
        return this.midPoints.stream().filter(point -> this.field_11863.method_8320(point).method_26204().equals(BlockContent.CONVEYOR_SUPPORT_BLOCK.get())).map(point -> new class_3545(point, (Object)((class_2350)this.field_11863.method_8320(point).method_11654((class_2769)class_2383.field_11177)))).toList();
    }

    public void assignFilterItem(class_1799 stack, class_1657 player) {
        if (stack.method_7960()) {
            this.resetFilterItem(player);
            return;
        }
        player.method_43496((class_2561)class_2561.method_43471((String)"message.belts.filter_set"));
        this.filteredItem = stack.method_7972();
        this.method_5431();
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            serverWorld.method_14178().method_14128(this.field_11867);
        }
    }

    public void resetFilterItem(class_1657 player) {
        player.method_43496((class_2561)class_2561.method_43471((String)"message.belts.filter_reset"));
        this.filteredItem = class_1799.field_8037;
        this.method_5431();
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            serverWorld.method_14178().method_14128(this.field_11867);
        }
    }

    public record BeltData(List<class_3545<class_243, class_243>> allPoints, double totalLength, Double[] segmentLengths) {
        @Nullable
        public static BeltData create(ChuteBlockEntity entity) {
            if (entity.method_10997() == null || entity.target == null || entity.target.equals((Object)class_2338.field_10980)) {
                return null;
            }
            Optional targetCandidate = entity.method_10997().method_35230(entity.getTarget(), (class_2591)BlockEntitiesContent.CHUTE_BLOCK.get());
            if (targetCandidate.isEmpty()) {
                return null;
            }
            class_2338 conveyorStartPoint = entity.method_11016();
            class_2338 conveyorEndPoint = entity.getTarget();
            class_243 conveyorStartDir = class_243.method_24954((class_2382)entity.getOwnFacing().method_10163());
            class_2350 conveyorFacing = ((ChuteBlockEntity)((Object)targetCandidate.get())).getOwnFacing();
            class_243 conveyorEndDir = class_243.method_24954((class_2382)conveyorFacing.method_10153().method_10163());
            List<class_3545<class_2338, class_2350>> conveyorMidPointsVisual = entity.getMidPointsWithTangents();
            class_243 conveyorStartPointVisual = conveyorStartPoint.method_46558().method_1019(conveyorStartDir.method_1021(-0.5));
            class_243 conveyorEndPointVisual = conveyorEndPoint.method_46558().method_1019(conveyorEndDir.method_1021(0.5));
            List<class_3545<class_243, class_243>> transformedMidPoints = conveyorMidPointsVisual.stream().map(elem -> new class_3545((Object)((class_2338)elem.method_15442()).method_46558(), (Object)class_243.method_24954((class_2382)((class_2350)elem.method_15441()).method_10163()))).toList();
            List<class_3545<class_243, class_243>> segmentPoints = SplineUtil.getPointPairs(conveyorStartPointVisual, conveyorStartDir, conveyorEndPointVisual, conveyorEndDir, transformedMidPoints);
            Double[] segmentLengths = new Double[segmentPoints.size() - 1];
            double totalLength = 0.0;
            for (int i = 0; i < segmentPoints.size() - 1; ++i) {
                class_3545<class_243, class_243> from = segmentPoints.get(i);
                class_3545<class_243, class_243> to = segmentPoints.get(i + 1);
                double length = SplineUtil.getLineLength((class_243)from.method_15442(), (class_243)from.method_15441(), (class_243)to.method_15442(), ((class_243)to.method_15441()).method_1021(1.0));
                segmentLengths[i] = length;
                totalLength += length;
            }
            return new BeltData(segmentPoints, totalLength, segmentLengths);
        }
    }

    public static class BeltItem {
        public float progress;
        public final short id;
        public final class_1799 stack;

        public BeltItem(short id, class_1799 stack) {
            this.id = id;
            this.stack = stack;
        }

        public BeltItem(float progress, short id, class_1799 stack) {
            this.id = id;
            this.stack = stack;
            this.progress = progress;
        }
    }
}

