/*
 * Decompiled with CFR 0.152.
 */
package rearth.belts.client.renderers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1297;
import net.minecraft.class_1723;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_761;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_827;
import org.joml.Matrix4f;
import rearth.belts.BlockEntitiesContent;
import rearth.belts.blocks.ChuteBlockEntity;
import rearth.belts.util.MathHelpers;
import rearth.belts.util.SplineUtil;

public class ChuteBeltRenderer
implements class_827<ChuteBlockEntity> {
    private static final HashMap<Long, Integer> lightmapCache = new HashMap();

    public void render(ChuteBlockEntity entity, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
        if (entity == null || entity.method_10997() == null) {
            return;
        }
        if (entity.getTarget() == null || entity.getTarget().method_19455((class_2382)entity.method_11016()) < 1) {
            return;
        }
        Optional targetCandidate = entity.method_10997().method_35230(entity.getTarget(), (class_2591)BlockEntitiesContent.CHUTE_BLOCK.get());
        if (targetCandidate.isEmpty()) {
            return;
        }
        ChuteBlockEntity.BeltData beltData = entity.getBeltData();
        if (beltData == null) {
            return;
        }
        int itemRenderDistSq = 4096;
        int beltRenderDistSq = 9216;
        this.renderBeltMesh(entity, matrices, vertexConsumers, overlay, targetCandidate, beltRenderDistSq);
        this.renderBeltItems(entity, matrices, vertexConsumers, overlay, beltData, itemRenderDistSq);
        this.renderBeltFilter(entity, matrices, vertexConsumers, light, overlay, beltRenderDistSq);
    }

    private void renderBeltMesh(ChuteBlockEntity entity, class_4587 matrices, class_4597 vertexConsumers, int overlay, Optional<ChuteBlockEntity> targetCandidate, int beltRenderDistSq) {
        matrices.method_22903();
        matrices.method_46416(0.0f, -0.045f, 0.0f);
        class_4587.class_4665 entry = matrices.method_23760();
        Matrix4f modelMatrix = entry.method_23761();
        class_4588 consumer = vertexConsumers.getBuffer(class_1921.method_23577());
        int lightRefreshInterval = 82;
        Quad[] quads = this.getOrComputeModel(entity, targetCandidate.get());
        if (quads == null) {
            matrices.method_22909();
            return;
        }
        int lastLight = class_761.method_23794((class_1920)entity.method_10997(), (class_2338)entity.method_11016());
        for (Quad quad : quads) {
            class_2338 worldPos = quad.worldPos;
            double camDist = class_310.method_1551().method_1560().method_19538().method_1025(class_243.method_24954((class_2382)worldPos));
            if (camDist > (double)beltRenderDistSq) continue;
            Integer worldLight = lightmapCache.computeIfAbsent(quad.worldPos.method_10063(), pos -> class_761.method_23794((class_1920)entity.method_10997(), (class_2338)worldPos));
            if (entity.method_10997().method_8510() % (long)lightRefreshInterval == 0L) {
                lightmapCache.put(quad.worldPos.method_10063(), class_761.method_23794((class_1920)entity.method_10997(), (class_2338)quad.worldPos));
            }
            Vertex renderedVertex = quad.a;
            consumer.method_22918(modelMatrix, renderedVertex.x, renderedVertex.y, renderedVertex.z).method_39415(-1).method_22913(renderedVertex.u, renderedVertex.v).method_60831(entry, 0.0f, 1.0f, 0.0f).method_60803(worldLight.intValue()).method_22922(overlay);
            renderedVertex = quad.b;
            consumer.method_22918(modelMatrix, renderedVertex.x, renderedVertex.y, renderedVertex.z).method_39415(-1).method_22913(renderedVertex.u, renderedVertex.v).method_60831(entry, 0.0f, 1.0f, 0.0f).method_60803(worldLight.intValue()).method_22922(overlay);
            renderedVertex = quad.c;
            consumer.method_22918(modelMatrix, renderedVertex.x, renderedVertex.y, renderedVertex.z).method_39415(-1).method_22913(renderedVertex.u, renderedVertex.v).method_60831(entry, 0.0f, 1.0f, 0.0f).method_60803(lastLight).method_22922(overlay);
            renderedVertex = quad.d;
            consumer.method_22918(modelMatrix, renderedVertex.x, renderedVertex.y, renderedVertex.z).method_39415(-1).method_22913(renderedVertex.u, renderedVertex.v).method_60831(entry, 0.0f, 1.0f, 0.0f).method_60803(lastLight).method_22922(overlay);
            lastLight = worldLight;
        }
        matrices.method_22909();
    }

    private Quad[] getOrComputeModel(ChuteBlockEntity entity, ChuteBlockEntity target) {
        if (entity.renderedModel == null) {
            entity.renderedModel = ChuteBeltRenderer.createSplineModel(entity, target);
        }
        return entity.renderedModel;
    }

    private static Quad[] createSplineModel(ChuteBlockEntity entity, ChuteBlockEntity target) {
        class_1058 sprite = (class_1058)class_310.method_1551().method_1549(class_1723.field_21668).apply(class_2960.method_60655((String)"belts", (String)"block/conveyorbelt"));
        ArrayList<Quad> result = new ArrayList<Quad>();
        ChuteBlockEntity.BeltData beltData = entity.getBeltData();
        if (beltData == null) {
            return null;
        }
        float segmentSize = 0.75f;
        int segmentCount = (int)Math.ceil(beltData.totalLength() / (double)segmentSize);
        float lineWidth = 0.33f;
        class_243 conveyorStartDir = class_243.method_24954((class_2382)entity.getOwnFacing().method_10163());
        class_243 conveyorEndDir = class_243.method_24954((class_2382)target.getOwnFacing().method_10153().method_10163());
        class_243 beginRight = conveyorStartDir.method_1036(new class_243(0.0, 1.0, 0.0)).method_1029();
        class_243 localStart = new class_243(0.5, 0.5, 0.5).method_1019(conveyorStartDir.method_1021(-0.5));
        class_243 lastRight = localStart.method_1019(beginRight.method_1021((double)lineWidth));
        class_243 lastLeft = localStart.method_1019(beginRight.method_1021((double)(-lineWidth)));
        for (int i = 0; i < segmentCount; ++i) {
            class_243 dirB;
            boolean last = i == segmentCount - 1;
            float progress = (float)i / (float)segmentCount;
            float nextProgress = (float)(i + 1) / (float)segmentCount;
            class_243 worldPoint = SplineUtil.getPositionOnSpline(beltData, progress);
            class_243 localPoint = worldPoint.method_1020(entity.method_11016().method_46558());
            class_243 worldPointNext = SplineUtil.getPositionOnSpline(beltData, nextProgress);
            class_243 localPointNext = worldPointNext.method_1020(entity.method_11016().method_46558());
            class_2338 worldPos = class_2338.method_49638((class_2374)worldPointNext.method_1031(0.5, 0.0, 0.5));
            class_243 direction = localPointNext.method_1020(localPoint);
            class_243 cross = direction.method_1036(new class_243(0.0, 1.0, 0.0)).method_1029();
            if (last) {
                cross = conveyorEndDir.method_1036(new class_243(0.0, 1.0, 0.0)).method_1029();
            }
            class_243 nextRight = localPointNext.method_1019(cross.method_1021((double)lineWidth)).method_1031(0.5, 0.5, 0.5);
            class_243 nextLeft = localPointNext.method_1019(cross.method_1021((double)(-lineWidth))).method_1031(0.5, 0.5, 0.5);
            class_243 dirA = lastLeft.method_1020(lastRight).method_1029();
            double curveStrength = 1.0 - Math.abs(dirA.method_1026(dirB = nextLeft.method_1020(nextRight).method_1029()));
            if (curveStrength > 0.025) {
                float midProgress = ((float)i + 0.5f) / (float)segmentCount;
                class_243 worldPointMid = SplineUtil.getPositionOnSpline(beltData, midProgress);
                class_243 localPointMid = worldPointMid.method_1020(entity.method_11016().method_46558());
                class_243 directionMid = localPointMid.method_1020(localPoint);
                class_243 crossMid = directionMid.method_1036(new class_243(0.0, 1.0, 0.0)).method_1029();
                class_243 midRight = localPointMid.method_1019(crossMid.method_1021((double)lineWidth)).method_1031(0.5, 0.5, 0.5);
                class_243 midLeft = localPointMid.method_1019(crossMid.method_1021((double)(-lineWidth))).method_1031(0.5, 0.5, 0.5);
                direction = localPointNext.method_1020(localPointMid);
                cross = direction.method_1036(new class_243(0.0, 1.0, 0.0)).method_1029();
                if (last) {
                    cross = conveyorEndDir.method_1036(new class_243(0.0, 1.0, 0.0)).method_1029();
                }
                nextRight = localPointNext.method_1019(cross.method_1021((double)lineWidth)).method_1031(0.5, 0.5, 0.5);
                nextLeft = localPointNext.method_1019(cross.method_1021((double)(-lineWidth))).method_1031(0.5, 0.5, 0.5);
                ChuteBeltRenderer.addSegmentVertices(midRight, lastRight, midLeft, lastLeft, sprite, worldPos, result, 0.0f, 0.5f);
                ChuteBeltRenderer.addSegmentVertices(nextRight, midRight, nextLeft, midLeft, sprite, worldPos, result, 0.5f, 1.0f);
            } else {
                ChuteBeltRenderer.addSegmentVertices(nextRight, lastRight, nextLeft, lastLeft, sprite, worldPos, result, 0.0f, 1.0f);
            }
            lastRight = nextRight;
            lastLeft = nextLeft;
        }
        return (Quad[])result.toArray(Quad[]::new);
    }

    private static void addSegmentVertices(class_243 nextRight, class_243 lastRight, class_243 nextLeft, class_243 lastLeft, class_1058 sprite, class_2338 worldPos, ArrayList<Quad> result, float vStart, float vEnd) {
        float skirtHeight = 0.15f;
        float uMin = sprite.method_4580(0.0f);
        float uMax = sprite.method_4580(1.0f);
        float vMin = sprite.method_4570(vStart);
        float vMax = sprite.method_4570(vEnd);
        Vertex botRight = Vertex.create(lastRight, uMin, vMin);
        Vertex topRight = Vertex.create(nextRight, uMin, vMax);
        Vertex topLeft = Vertex.create(nextLeft, uMax, vMax);
        Vertex botLeft = Vertex.create(lastLeft, uMax, vMin);
        Quad quad = new Quad(topRight, topLeft, botLeft, botRight, worldPos);
        result.add(quad);
        uMin = sprite.method_4580(0.0f);
        uMax = sprite.method_4580(0.125f);
        vMin = sprite.method_4570(vStart);
        vMax = sprite.method_4570(vEnd);
        topRight = Vertex.create(nextRight.method_1031(0.0, (double)(-skirtHeight), 0.0), uMax, vMax);
        topLeft = Vertex.create(nextRight, uMin, vMax);
        botLeft = Vertex.create(lastRight, uMin, vMin);
        botRight = Vertex.create(lastRight.method_1031(0.0, (double)(-skirtHeight), 0.0), uMax, vMin);
        quad = new Quad(topRight, topLeft, botLeft, botRight, worldPos);
        result.add(quad);
        uMin = sprite.method_4580(0.0f);
        uMax = sprite.method_4580(0.125f);
        vMin = sprite.method_4570(vStart);
        vMax = sprite.method_4570(vEnd);
        topRight = Vertex.create(nextLeft.method_1031(0.0, (double)(-skirtHeight), 0.0), uMax, vMax);
        topLeft = Vertex.create(nextLeft, uMin, vMax);
        botLeft = Vertex.create(lastLeft, uMin, vMin);
        botRight = Vertex.create(lastLeft.method_1031(0.0, (double)(-skirtHeight), 0.0), uMax, vMin);
        quad = new Quad(botRight, botLeft, topLeft, topRight, worldPos);
        result.add(quad);
        uMin = sprite.method_4580(0.0f);
        uMax = sprite.method_4580(1.0f);
        vMin = sprite.method_4570(vStart);
        vMax = sprite.method_4570(vEnd);
        botRight = Vertex.create(lastRight.method_1031(0.0, (double)(-skirtHeight), 0.0), uMin, vMin);
        topRight = Vertex.create(nextRight.method_1031(0.0, (double)(-skirtHeight), 0.0), uMin, vMax);
        topLeft = Vertex.create(nextLeft.method_1031(0.0, (double)(-skirtHeight), 0.0), uMax, vMax);
        botLeft = Vertex.create(lastLeft.method_1031(0.0, (double)(-skirtHeight), 0.0), uMax, vMin);
        quad = new Quad(botRight, botLeft, topLeft, topRight, worldPos);
        result.add(quad);
    }

    private void renderBeltItems(ChuteBlockEntity entity, class_4587 matrices, class_4597 vertexConsumers, int overlay, ChuteBlockEntity.BeltData beltData, int itemRenderDistSq) {
        Iterable<ChuteBlockEntity.BeltItem> renderedItems = this.getRenderedStacks(entity);
        for (ChuteBlockEntity.BeltItem itemData : renderedItems) {
            boolean useItemTransform;
            class_1799 renderedStack = itemData.stack;
            float renderedProgress = itemData.progress;
            double delta = (double)0.05f / beltData.totalLength();
            double nextProgress = (double)itemData.progress + delta;
            class_243 worldPoint = SplineUtil.getPositionOnSpline(beltData, renderedProgress);
            class_1297 cam = class_310.method_1551().method_1560();
            double camDist = cam.method_19538().method_1025(worldPoint);
            if (camDist > (double)itemRenderDistSq) continue;
            class_243 camLookDir = cam.method_5720();
            class_243 itemOffset = worldPoint.method_1020(cam.method_19538());
            if (camDist > 1.0 && camLookDir.method_1026(itemOffset.method_1029()) < 0.0) continue;
            class_243 nextWorldPoint = SplineUtil.getPositionOnSpline(beltData, nextProgress);
            class_243 localPoint = worldPoint.method_1020(entity.method_11016().method_46558());
            class_243 lastRenderPosition = entity.lastRenderedPositions.getOrDefault(itemData.id, localPoint);
            class_243 renderPosition = MathHelpers.lerp(lastRenderPosition, localPoint, 0.03f);
            entity.lastRenderedPositions.put(itemData.id, renderPosition);
            class_243 forward = nextWorldPoint.method_1020(worldPoint);
            class_243 flatForward = new class_243(forward.field_1352, 0.0, forward.field_1350).method_1029();
            double dot = new class_243(1.0, 0.0, 0.0).method_1026(flatForward);
            double angleRad = Math.acos(dot);
            double angleUp = Math.acos(forward.method_1029().method_1026(flatForward));
            if (forward.field_1351 < 0.0) {
                angleUp = -angleUp;
            }
            if (flatForward.field_1350 > 0.0) {
                angleRad = -angleRad;
            }
            matrices.method_22903();
            matrices.method_22904(renderPosition.field_1352, renderPosition.field_1351, renderPosition.field_1350);
            matrices.method_46416(0.5f, 0.6125f, 0.5f);
            class_1087 bakedmodel = class_310.method_1551().method_1480().method_4019(renderedStack, entity.method_10997(), null, 0);
            boolean bl = useItemTransform = !bakedmodel.method_4707(null, null, entity.method_10997().field_9229).isEmpty();
            if (useItemTransform) {
                matrices.method_46416(0.0f, -0.125f, 0.0f);
                matrices.method_22905(0.8f, 0.8f, 0.8f);
            }
            matrices.method_22907(class_7833.field_40716.rotationDegrees((float)Math.toDegrees(angleRad)));
            if (Math.abs(angleUp) > (double)0.01f) {
                matrices.method_22907(class_7833.field_40718.rotationDegrees((float)Math.toDegrees(angleUp)));
            }
            matrices.method_22907(class_7833.field_40714.rotationDegrees(90.0f));
            matrices.method_22905(0.6f, 0.6f, 0.6f);
            class_2338 worldPos = class_2338.method_49638((class_2374)worldPoint);
            Integer worldLight = lightmapCache.computeIfAbsent(worldPos.method_10063(), pos -> class_761.method_23794((class_1920)entity.method_10997(), (class_2338)worldPos));
            class_310.method_1551().method_1480().method_23178(renderedStack, class_811.field_4319, worldLight.intValue(), overlay, matrices, vertexConsumers, entity.method_10997(), 0);
            matrices.method_22909();
        }
        if (entity.method_10997().method_8510() % 104L == 0L) {
            this.cleanPositionsCache(entity);
        }
    }

    private void renderBeltFilter(ChuteBlockEntity entity, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay, int itemRenderDistSq) {
        class_1799 renderedStack = entity.filteredItem;
        if (renderedStack.method_7960()) {
            return;
        }
        class_243 worldPoint = entity.method_11016().method_46558();
        class_1297 cam = class_310.method_1551().method_1560();
        double camDist = cam.method_19538().method_1025(worldPoint);
        if (camDist > (double)itemRenderDistSq) {
            return;
        }
        class_243 camLookDir = cam.method_5720();
        class_243 itemOffset = worldPoint.method_1020(cam.method_19538());
        if (camDist > 5.0 && camLookDir.method_1026(itemOffset.method_1029()) < 0.0) {
            return;
        }
        class_2350 ownFacing = entity.getOwnFacing();
        class_243 forwardDir = class_243.method_24954((class_2382)ownFacing.method_10163());
        class_243 renderOffset = forwardDir.method_1021((double)-0.43f);
        matrices.method_22903();
        matrices.method_46416(0.5f, 0.7f, 0.5f);
        matrices.method_22904(renderOffset.field_1352, renderOffset.field_1351, renderOffset.field_1350);
        if (ownFacing.method_10166().equals((Object)class_2350.class_2351.field_11048)) {
            matrices.method_22907(class_7833.field_40716.rotationDegrees(90.0f));
        }
        matrices.method_22905(0.4f, 0.4f, 0.4f);
        class_310.method_1551().method_1480().method_23178(renderedStack, class_811.field_4319, light, overlay, matrices, vertexConsumers, entity.method_10997(), 0);
        matrices.method_22909();
    }

    private Iterable<ChuteBlockEntity.BeltItem> getRenderedStacks(ChuteBlockEntity entity) {
        return entity.getMovingItems();
    }

    private void cleanPositionsCache(ChuteBlockEntity entity) {
        Iterable<ChuteBlockEntity.BeltItem> active = this.getRenderedStacks(entity);
        Map<Short, class_243> cache = entity.lastRenderedPositions;
        HashMap<Short, class_243> usedData = new HashMap<Short, class_243>();
        for (ChuteBlockEntity.BeltItem movedItem : active) {
            class_243 lastEntry = cache.getOrDefault(movedItem.id, class_243.field_1353);
            usedData.put(movedItem.id, lastEntry);
        }
        cache.clear();
        cache.putAll(usedData);
    }

    public boolean rendersOutsideBoundingBox(ChuteBlockEntity blockEntity) {
        return true;
    }

    public int method_33893() {
        return 96;
    }

    public class_238 getRenderBoundingBox(class_2586 blockEntity) {
        return new class_238(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    public record Quad(Vertex a, Vertex b, Vertex c, Vertex d, class_2338 worldPos) {
    }

    public record Vertex(float x, float y, float z, float u, float v) {
        public static Vertex create(class_243 pos, float u, float v) {
            return new Vertex((float)pos.field_1352, (float)pos.field_1351, (float)pos.field_1350, u, v);
        }
    }
}

