/*
 * Decompiled with CFR 0.152.
 */
package rearth.belts.fabric;

import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.SlottedStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;
import rearth.belts.Belts;
import rearth.belts.api.item.BlockItemApi;
import rearth.belts.api.item.ItemApi;

public class FabricItemApi
implements BlockItemApi {
    @Override
    public ItemApi.InventoryStorage find(class_1937 world, class_2338 pos, @Nullable class_2680 state, @Nullable class_2586 entity, @Nullable class_2350 direction) {
        Storage candidate = (Storage)ItemStorage.SIDED.find(world, pos, state, entity, (Object)direction);
        if (candidate == null) {
            return null;
        }
        return new FabricStorageWrapper((Storage<ItemVariant>)candidate);
    }

    public static class FabricStorageWrapper
    implements ItemApi.InventoryStorage {
        public final Storage<ItemVariant> storage;

        public FabricStorageWrapper(Storage<ItemVariant> storage) {
            this.storage = storage;
        }

        @Override
        public boolean supportsInsertion() {
            return this.storage.supportsInsertion();
        }

        @Override
        public int insert(class_1799 inserted, boolean simulate) {
            if (inserted.method_7960()) {
                return 0;
            }
            try (Transaction transaction = Transaction.openOuter();){
                long insertCount = this.storage.insert((Object)ItemVariant.of((class_1799)inserted), (long)inserted.method_7947(), (TransactionContext)transaction);
                if (!simulate) {
                    transaction.commit();
                }
                int n = (int)insertCount;
                return n;
            }
        }

        @Override
        public int insertToSlot(class_1799 inserted, int slot, boolean simulate) {
            if (inserted.method_7960()) {
                return 0;
            }
            Storage<ItemVariant> storage = this.storage;
            if (storage instanceof SlottedStorage) {
                SlottedStorage slottedStorage = (SlottedStorage)storage;
                try (Transaction transaction = Transaction.openOuter();){
                    long insertCount = slottedStorage.getSlot(slot).insert((Object)ItemVariant.of((class_1799)inserted), (long)inserted.method_7947(), (TransactionContext)transaction);
                    if (!simulate) {
                        transaction.commit();
                    }
                    int n = (int)insertCount;
                    return n;
                }
            }
            return 0;
        }

        @Override
        public boolean supportsExtraction() {
            return this.storage.supportsExtraction();
        }

        @Override
        public int extract(class_1799 extracted, boolean simulate) {
            if (extracted.method_7960()) {
                return 0;
            }
            try (Transaction transaction = Transaction.openOuter();){
                long extractedCount = this.storage.extract((Object)ItemVariant.of((class_1799)extracted), (long)extracted.method_7947(), (TransactionContext)transaction);
                if (!simulate) {
                    transaction.commit();
                }
                int n = (int)extractedCount;
                return n;
            }
        }

        @Override
        public int extractFromSlot(class_1799 extracted, int slot, boolean simulate) {
            if (extracted.method_7960()) {
                return 0;
            }
            Storage<ItemVariant> storage = this.storage;
            if (storage instanceof SlottedStorage) {
                SlottedStorage slottedStorage = (SlottedStorage)storage;
                try (Transaction transaction = Transaction.openOuter();){
                    long extractedCount = slottedStorage.getSlot(slot).extract((Object)ItemVariant.of((class_1799)extracted), (long)extracted.method_7947(), (TransactionContext)transaction);
                    if (!simulate) {
                        transaction.commit();
                    }
                    int n = (int)extractedCount;
                    return n;
                }
            }
            return 0;
        }

        @Override
        public void setStackInSlot(int slot, class_1799 stack) {
            Belts.LOGGER.error("Unable to set stack in slot: {}, stack is: {}", (Object)slot, (Object)stack);
            Belts.LOGGER.error("This should never happen");
        }

        @Override
        public class_1799 getStackInSlot(int slot) {
            Storage<ItemVariant> storage = this.storage;
            if (storage instanceof SlottedStorage) {
                SlottedStorage slottedStorage = (SlottedStorage)storage;
                return ((ItemVariant)slottedStorage.getSlot(slot).getResource()).toStack((int)slottedStorage.getSlot(slot).getAmount());
            }
            return class_1799.field_8037;
        }

        @Override
        public int getSlotCount() {
            Storage<ItemVariant> storage = this.storage;
            if (storage instanceof SlottedStorage) {
                SlottedStorage slottedStorage = (SlottedStorage)storage;
                return slottedStorage.getSlotCount();
            }
            return 1;
        }

        @Override
        public int getSlotLimit(int slot) {
            Storage<ItemVariant> storage = this.storage;
            if (storage instanceof SlottedStorage) {
                SlottedStorage slottedStorage = (SlottedStorage)storage;
                return (int)slottedStorage.getSlot(slot).getCapacity();
            }
            return 64;
        }
    }
}

