/*
 * Decompiled with CFR 0.152.
 */
package rearth.belts.util;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_3545;
import rearth.belts.blocks.ChuteBlockEntity;

public class SplineUtil {
    public static class_243 getPositionOnSpline(ChuteBlockEntity.BeltData data, double t) {
        return SplineUtil.getPositionOnSpline(data.allPoints(), data.totalLength(), data.segmentLengths(), t);
    }

    public static class_243 getPositionOnSpline(class_243 start, class_243 startDir, class_243 end, class_243 endDir, List<class_3545<class_2338, class_2350>> middlePoints, double t) {
        List<class_3545<class_243, class_243>> transformedMidPoints = middlePoints.stream().map(elem -> new class_3545((Object)((class_2338)elem.method_15442()).method_46558(), (Object)class_243.method_24954((class_2382)((class_2350)elem.method_15441()).method_10163()))).toList();
        List<class_3545<class_243, class_243>> allPairs = SplineUtil.getPointPairs(start, startDir, end, endDir, transformedMidPoints);
        Double[] segmentLengths = new Double[allPairs.size() - 1];
        double totalLength = 0.0;
        for (int i = 0; i < allPairs.size() - 1; ++i) {
            class_3545<class_243, class_243> from = allPairs.get(i);
            class_3545<class_243, class_243> to = allPairs.get(i + 1);
            double length = SplineUtil.getLineLength((class_243)from.method_15442(), (class_243)from.method_15441(), (class_243)to.method_15442(), ((class_243)to.method_15441()).method_1021(1.0));
            segmentLengths[i] = length;
            totalLength += length;
        }
        return SplineUtil.getPositionOnSpline(allPairs, totalLength, segmentLengths, t);
    }

    public static class_243 getPositionOnSpline(List<class_3545<class_243, class_243>> allPoints, double totalLength, Double[] segmentLengths, double t) {
        t = Math.clamp(t, 0.0, 1.0);
        double targetLength = totalLength * t;
        double traversedLength = 0.0;
        for (int i = 0; i < allPoints.size() - 1; ++i) {
            Double segmentLength = segmentLengths[i];
            if (targetLength >= traversedLength && targetLength < traversedLength + segmentLength) {
                class_3545<class_243, class_243> from = allPoints.get(i);
                class_3545<class_243, class_243> to = allPoints.get(i + 1);
                double offset = targetLength - traversedLength;
                double delta = offset / segmentLength;
                double mappedT = SplineUtil.remapProgress(delta);
                return SplineUtil.getPointOnHermiteSpline((class_243)from.method_15442(), ((class_243)from.method_15441()).method_1021(segmentLength * 1.5), (class_243)to.method_15442(), ((class_243)to.method_15441()).method_1021(segmentLength * 1.5), mappedT);
            }
            traversedLength += segmentLength.doubleValue();
        }
        return (class_243)allPoints.getLast().method_15442();
    }

    private static double remapProgress(double x) {
        return 0.4791667 * x + 1.5625 * (x * x) - 1.041667 * (x * x * x);
    }

    public static double getLineLength(class_243 from, class_243 fromTangent, class_243 to, class_243 toTangent) {
        double approxLength = from.method_1022(to);
        if (fromTangent.method_1025(toTangent) < 0.1) {
            approxLength += 1.0;
        }
        class_243 midPointA = SplineUtil.getPointOnHermiteSpline(from, fromTangent.method_1021(approxLength), to, toTangent.method_1021(approxLength), 0.33f);
        class_243 midPointB = SplineUtil.getPointOnHermiteSpline(from, fromTangent.method_1021(approxLength), to, toTangent.method_1021(approxLength), 0.66f);
        return from.method_1022(midPointA) + midPointA.method_1022(midPointB) + midPointB.method_1022(to);
    }

    public static double getTotalLength(List<class_3545<class_243, class_243>> points) {
        double res = 0.0;
        for (int i = 0; i < points.size() - 1; ++i) {
            class_3545<class_243, class_243> current = points.get(i);
            class_3545<class_243, class_243> next = points.get(i + 1);
            double segmentLength = SplineUtil.getLineLength((class_243)current.method_15442(), (class_243)current.method_15441(), (class_243)next.method_15442(), (class_243)next.method_15441());
            res += segmentLength;
        }
        return res;
    }

    public static List<class_3545<class_243, class_243>> getPointPairs(class_243 start, class_243 startDir, class_243 end, class_243 endDir, List<class_3545<class_243, class_243>> middlePoints) {
        ArrayList<Object> pendingPoints = new ArrayList<Object>();
        pendingPoints.addAll(middlePoints);
        pendingPoints.add(new class_3545((Object)end, (Object)endDir));
        ArrayList<class_3545<class_243, class_243>> pointsWithTangents = new ArrayList<class_3545<class_243, class_243>>();
        pointsWithTangents.add(new class_3545((Object)start, (Object)startDir));
        class_243 currentFrom = start.method_1019(startDir.method_1021((double)0.3f));
        while (!pendingPoints.isEmpty()) {
            double distB;
            class_3545 pair = (class_3545)pendingPoints.removeFirst();
            if (((class_243)pair.method_15442()).equals((Object)end)) {
                pointsWithTangents.add((class_3545<class_243, class_243>)new class_3545((Object)end, (Object)endDir));
                break;
            }
            class_243 currentTo = (class_243)pair.method_15442();
            double distA = currentFrom.method_1022(((class_243)pair.method_15442()).method_1019((class_243)pair.method_15441()));
            class_243 currentToDir = distA > (distB = currentFrom.method_1022(((class_243)pair.method_15442()).method_1020((class_243)pair.method_15441()))) ? (class_243)pair.method_15441() : ((class_243)pair.method_15441()).method_1021(-1.0);
            currentFrom = currentTo.method_1019(currentToDir.method_1021((double)-0.3f));
            pointsWithTangents.add((class_3545<class_243, class_243>)new class_3545((Object)currentTo, (Object)currentToDir));
        }
        return pointsWithTangents;
    }

    public static class_243 getPointOnHermiteSpline(class_243 pointA, class_243 tangentA, class_243 pointB, class_243 tangentB, double t) {
        if (t < 0.0) {
            t = 0.0;
        }
        if (t > 1.0) {
            t = 1.0;
        }
        double t2 = t * t;
        double t3 = t2 * t;
        double h00 = 2.0 * t3 - 3.0 * t2 + 1.0;
        double h10 = t3 - 2.0 * t2 + t;
        double h01 = -2.0 * t3 + 3.0 * t2;
        double h11 = t3 - t2;
        class_243 termP0 = pointA.method_1021(h00);
        class_243 termM0 = tangentA.method_1021(h10);
        class_243 termP1 = pointB.method_1021(h01);
        class_243 termM1 = tangentB.method_1021(h11);
        return termP0.method_1019(termM0).method_1019(termP1).method_1019(termM1);
    }
}

