/*
 * Decompiled with CFR 0.152.
 */
package net.lunakibby.timekeeper.network;

import java.util.function.Supplier;
import net.lunakibby.timekeeper.TimekeeperLunaMod;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.saveddata.SavedDataType;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.common.util.ValueIOSerializable;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

@EventBusSubscriber
public class TimekeeperLunaModVariables {
    public static final DeferredRegister<AttachmentType<?>> ATTACHMENT_TYPES = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.ATTACHMENT_TYPES, (String)"timekeeper_luna");
    public static final Supplier<AttachmentType<PlayerVariables>> PLAYER_VARIABLES = ATTACHMENT_TYPES.register("player_variables", () -> AttachmentType.serializable(() -> new PlayerVariables()).build());

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        TimekeeperLunaMod.addNetworkMessage(SavedDataSyncMessage.TYPE, SavedDataSyncMessage.STREAM_CODEC, SavedDataSyncMessage::handleData);
        TimekeeperLunaMod.addNetworkMessage(PlayerVariablesSyncMessage.TYPE, PlayerVariablesSyncMessage.STREAM_CODEC, PlayerVariablesSyncMessage::handleData);
    }

    @SubscribeEvent
    public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new PlayerVariablesSyncMessage((PlayerVariables)player2.getData(PLAYER_VARIABLES)), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new PlayerVariablesSyncMessage((PlayerVariables)player2.getData(PLAYER_VARIABLES)), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @SubscribeEvent
    public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new PlayerVariablesSyncMessage((PlayerVariables)player2.getData(PLAYER_VARIABLES)), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @SubscribeEvent
    public static void onPlayerTickUpdateSyncPlayerVariables(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            if (((PlayerVariables)player2.getData(TimekeeperLunaModVariables.PLAYER_VARIABLES))._syncDirty) {
                PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new PlayerVariablesSyncMessage((PlayerVariables)player2.getData(PLAYER_VARIABLES)), (CustomPacketPayload[])new CustomPacketPayload[0]);
                ((PlayerVariables)player2.getData(TimekeeperLunaModVariables.PLAYER_VARIABLES))._syncDirty = false;
            }
        }
    }

    @SubscribeEvent
    public static void clonePlayer(PlayerEvent.Clone event) {
        PlayerVariables original = (PlayerVariables)event.getOriginal().getData(PLAYER_VARIABLES);
        PlayerVariables clone = new PlayerVariables();
        clone.messageSent = original.messageSent;
        if (!event.isWasDeath()) {
            // empty if block
        }
        event.getEntity().setData(PLAYER_VARIABLES, (Object)clone);
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().level());
            WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().level());
            if (mapdata != null) {
                PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SavedDataSyncMessage(0, mapdata), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            if (worlddata != null) {
                PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SavedDataSyncMessage(1, worlddata), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().level());
            if (worlddata != null) {
                PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SavedDataSyncMessage(1, worlddata), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    @SubscribeEvent
    public static void onWorldTick(LevelTickEvent.Post event) {
        Level level = event.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            WorldVariables worldVariables = WorldVariables.get((LevelAccessor)level2);
            if (worldVariables._syncDirty) {
                PacketDistributor.sendToPlayersInDimension((ServerLevel)level2, (CustomPacketPayload)new SavedDataSyncMessage(1, worldVariables), (CustomPacketPayload[])new CustomPacketPayload[0]);
                worldVariables._syncDirty = false;
            }
            MapVariables mapVariables = MapVariables.get((LevelAccessor)level2);
            if (mapVariables._syncDirty) {
                PacketDistributor.sendToAllPlayers((CustomPacketPayload)new SavedDataSyncMessage(0, mapVariables), (CustomPacketPayload[])new CustomPacketPayload[0]);
                mapVariables._syncDirty = false;
            }
        }
    }

    public record SavedDataSyncMessage(int dataType, SavedData data) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<SavedDataSyncMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"timekeeper_luna", (String)"saved_data_sync"));
        public static final StreamCodec<RegistryFriendlyByteBuf, SavedDataSyncMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
            buffer.writeInt(message.dataType);
            SavedData patt0$temp = message.data;
            if (patt0$temp instanceof MapVariables) {
                MapVariables mapVariables = (MapVariables)patt0$temp;
                buffer.writeNbt((Tag)mapVariables.save(new CompoundTag(), (HolderLookup.Provider)buffer.registryAccess()));
            } else {
                SavedData patt1$temp = message.data;
                if (patt1$temp instanceof WorldVariables) {
                    WorldVariables worldVariables = (WorldVariables)patt1$temp;
                    buffer.writeNbt((Tag)worldVariables.save(new CompoundTag(), (HolderLookup.Provider)buffer.registryAccess()));
                }
            }
        }, buffer -> {
            int dataType = buffer.readInt();
            CompoundTag nbt = buffer.readNbt();
            SavedData data = null;
            if (nbt != null) {
                SavedData savedData = data = dataType == 0 ? new MapVariables() : new WorldVariables();
                if (data instanceof MapVariables) {
                    MapVariables mapVariables = (MapVariables)data;
                    mapVariables.read(nbt, (HolderLookup.Provider)buffer.registryAccess());
                } else if (data instanceof WorldVariables) {
                    WorldVariables worldVariables = (WorldVariables)data;
                    worldVariables.read(nbt, (HolderLookup.Provider)buffer.registryAccess());
                }
            }
            return new SavedDataSyncMessage(dataType, data);
        });

        public CustomPacketPayload.Type<SavedDataSyncMessage> type() {
            return TYPE;
        }

        public static void handleData(SavedDataSyncMessage message, IPayloadContext context) {
            if (context.flow() == PacketFlow.CLIENTBOUND && message.data != null) {
                context.enqueueWork(() -> {
                    if (message.dataType == 0) {
                        MapVariables.clientSide.read(((MapVariables)message.data).save(new CompoundTag(), (HolderLookup.Provider)context.player().registryAccess()), (HolderLookup.Provider)context.player().registryAccess());
                    } else {
                        WorldVariables.clientSide.read(((WorldVariables)message.data).save(new CompoundTag(), (HolderLookup.Provider)context.player().registryAccess()), (HolderLookup.Provider)context.player().registryAccess());
                    }
                }).exceptionally(e -> {
                    context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                    return null;
                });
            }
        }
    }

    public record PlayerVariablesSyncMessage(PlayerVariables data) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<PlayerVariablesSyncMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"timekeeper_luna", (String)"player_variables_sync"));
        public static final StreamCodec<RegistryFriendlyByteBuf, PlayerVariablesSyncMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
            TagValueOutput output = TagValueOutput.createWithoutContext((ProblemReporter)ProblemReporter.DISCARDING);
            message.data.serialize((ValueOutput)output);
            buffer.writeNbt((Tag)output.buildResult());
        }, buffer -> {
            PlayerVariablesSyncMessage message = new PlayerVariablesSyncMessage(new PlayerVariables());
            message.data.deserialize(TagValueInput.create((ProblemReporter)ProblemReporter.DISCARDING, (HolderLookup.Provider)buffer.registryAccess(), (CompoundTag)buffer.readNbt()));
            return message;
        });

        public CustomPacketPayload.Type<PlayerVariablesSyncMessage> type() {
            return TYPE;
        }

        public static void handleData(PlayerVariablesSyncMessage message, IPayloadContext context) {
            if (context.flow() == PacketFlow.CLIENTBOUND && message.data != null) {
                context.enqueueWork(() -> {
                    TagValueOutput output = TagValueOutput.createWithContext((ProblemReporter)ProblemReporter.DISCARDING, (HolderLookup.Provider)context.player().registryAccess());
                    message.data.serialize((ValueOutput)output);
                    ((PlayerVariables)context.player().getData(PLAYER_VARIABLES)).deserialize(TagValueInput.create((ProblemReporter)ProblemReporter.DISCARDING, (HolderLookup.Provider)context.player().registryAccess(), (CompoundTag)output.buildResult()));
                }).exceptionally(e -> {
                    context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                    return null;
                });
            }
        }
    }

    public static class PlayerVariables
    implements ValueIOSerializable {
        boolean _syncDirty = false;
        public boolean messageSent = false;

        public void serialize(ValueOutput output) {
            output.putBoolean("messageSent", this.messageSent);
        }

        public void deserialize(ValueInput input) {
            this.messageSent = input.getBooleanOr("messageSent", false);
        }

        public void markSyncDirty() {
            this._syncDirty = true;
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final SavedDataType<MapVariables> TYPE = new SavedDataType("timekeeper_luna_mapvars", ctx -> new MapVariables(), ctx -> CompoundTag.CODEC.xmap(tag -> {
            MapVariables instance = new MapVariables();
            instance.read((CompoundTag)tag, (HolderLookup.Provider)ctx.levelOrThrow().registryAccess());
            return instance;
        }, instance -> instance.save(new CompoundTag(), (HolderLookup.Provider)ctx.levelOrThrow().registryAccess())));
        boolean _syncDirty = false;
        public double yearLengthTFC = 96.0;
        public double yearLengthSerene = 96.0;
        public boolean tkAnnouncement = true;
        public double tfcYears = 0.0;
        public double tfcDaysYears = 0.0;
        public double tfcDays = 0.0;
        public double sereneYears = 0.0;
        public double sereneDaysYears = 0.0;
        public double sereneDays = 0.0;
        public double realYears = 0.0;
        public double realHoursDays = 0.0;
        public double realHours = 0.0;
        public double realDaysYears = 0.0;
        public double realDays = 0.0;
        public double numYears = 0.0;
        public double numDaysYear = 0.0;
        public double numDays = 0.0;
        public boolean holidayAllowSilly = true;
        public boolean holidayAllowPagan = true;
        public boolean holidayAllowMinecraft = true;
        public boolean holidayAllowCreator = true;
        public boolean holidayAllowCommon = true;
        public boolean doHolidayAnnouncements = true;
        public double announcementtime = 0.0;
        static MapVariables clientSide = new MapVariables();

        public void read(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            this.yearLengthTFC = nbt.getDoubleOr("yearLengthTFC", 0.0);
            this.yearLengthSerene = nbt.getDoubleOr("yearLengthSerene", 0.0);
            this.tkAnnouncement = nbt.getBooleanOr("tkAnnouncement", false);
            this.tfcYears = nbt.getDoubleOr("tfcYears", 0.0);
            this.tfcDaysYears = nbt.getDoubleOr("tfcDaysYears", 0.0);
            this.tfcDays = nbt.getDoubleOr("tfcDays", 0.0);
            this.sereneYears = nbt.getDoubleOr("sereneYears", 0.0);
            this.sereneDaysYears = nbt.getDoubleOr("sereneDaysYears", 0.0);
            this.sereneDays = nbt.getDoubleOr("sereneDays", 0.0);
            this.realYears = nbt.getDoubleOr("realYears", 0.0);
            this.realHoursDays = nbt.getDoubleOr("realHoursDays", 0.0);
            this.realHours = nbt.getDoubleOr("realHours", 0.0);
            this.realDaysYears = nbt.getDoubleOr("realDaysYears", 0.0);
            this.realDays = nbt.getDoubleOr("realDays", 0.0);
            this.numYears = nbt.getDoubleOr("numYears", 0.0);
            this.numDaysYear = nbt.getDoubleOr("numDaysYear", 0.0);
            this.numDays = nbt.getDoubleOr("numDays", 0.0);
            this.holidayAllowSilly = nbt.getBooleanOr("holidayAllowSilly", false);
            this.holidayAllowPagan = nbt.getBooleanOr("holidayAllowPagan", false);
            this.holidayAllowMinecraft = nbt.getBooleanOr("holidayAllowMinecraft", false);
            this.holidayAllowCreator = nbt.getBooleanOr("holidayAllowCreator", false);
            this.holidayAllowCommon = nbt.getBooleanOr("holidayAllowCommon", false);
            this.doHolidayAnnouncements = nbt.getBooleanOr("doHolidayAnnouncements", false);
            this.announcementtime = nbt.getDoubleOr("announcementtime", 0.0);
        }

        public CompoundTag save(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            nbt.putDouble("yearLengthTFC", this.yearLengthTFC);
            nbt.putDouble("yearLengthSerene", this.yearLengthSerene);
            nbt.putBoolean("tkAnnouncement", this.tkAnnouncement);
            nbt.putDouble("tfcYears", this.tfcYears);
            nbt.putDouble("tfcDaysYears", this.tfcDaysYears);
            nbt.putDouble("tfcDays", this.tfcDays);
            nbt.putDouble("sereneYears", this.sereneYears);
            nbt.putDouble("sereneDaysYears", this.sereneDaysYears);
            nbt.putDouble("sereneDays", this.sereneDays);
            nbt.putDouble("realYears", this.realYears);
            nbt.putDouble("realHoursDays", this.realHoursDays);
            nbt.putDouble("realHours", this.realHours);
            nbt.putDouble("realDaysYears", this.realDaysYears);
            nbt.putDouble("realDays", this.realDays);
            nbt.putDouble("numYears", this.numYears);
            nbt.putDouble("numDaysYear", this.numDaysYear);
            nbt.putDouble("numDays", this.numDays);
            nbt.putBoolean("holidayAllowSilly", this.holidayAllowSilly);
            nbt.putBoolean("holidayAllowPagan", this.holidayAllowPagan);
            nbt.putBoolean("holidayAllowMinecraft", this.holidayAllowMinecraft);
            nbt.putBoolean("holidayAllowCreator", this.holidayAllowCreator);
            nbt.putBoolean("holidayAllowCommon", this.holidayAllowCommon);
            nbt.putBoolean("doHolidayAnnouncements", this.doHolidayAnnouncements);
            nbt.putDouble("announcementtime", this.announcementtime);
            return nbt;
        }

        public void markSyncDirty() {
            this.setDirty();
            this._syncDirty = true;
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAccessor = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAccessor.getLevel().getServer().getLevel(Level.OVERWORLD).getDataStorage().computeIfAbsent(TYPE);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final SavedDataType<WorldVariables> TYPE = new SavedDataType("timekeeper_luna_worldvars", ctx -> new WorldVariables(), ctx -> CompoundTag.CODEC.xmap(tag -> {
            WorldVariables instance = new WorldVariables();
            instance.read((CompoundTag)tag, (HolderLookup.Provider)ctx.levelOrThrow().registryAccess());
            return instance;
        }, instance -> instance.save(new CompoundTag(), (HolderLookup.Provider)ctx.levelOrThrow().registryAccess())));
        boolean _syncDirty = false;
        static WorldVariables clientSide = new WorldVariables();

        public void read(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
        }

        public CompoundTag save(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            return nbt;
        }

        public void markSyncDirty() {
            this.setDirty();
            this._syncDirty = true;
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.getDataStorage().computeIfAbsent(TYPE);
            }
            return clientSide;
        }
    }
}

