/*
 * Decompiled with CFR 0.152.
 */
package com.github.ygimenez.model;

import com.github.ygimenez.model.ButtonId;
import com.github.ygimenez.model.EmojiId;
import com.github.ygimenez.model.IdCursor;
import com.github.ygimenez.model.Mapping;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.dv8tion.jda.api.entities.emoji.Emoji;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EmojiMapping<V>
implements Mapping<V> {
    private final Map<ButtonId<?>, V> mapping;
    private final IdCursor<Emoji> cursor = new IdCursor();

    public EmojiMapping() {
        this(new LinkedHashMap());
    }

    public EmojiMapping(Map<ButtonId<?>, V> mapping) {
        this.mapping = mapping;
    }

    @Override
    public Map<ButtonId<?>, V> toMap() {
        return this.mapping;
    }

    public int size() {
        return this.mapping.size();
    }

    public boolean isEmpty() {
        return this.mapping.isEmpty();
    }

    public boolean containsKey(Emoji key) {
        this.cursor.setId(key);
        return this.mapping.containsKey(this.cursor);
    }

    public boolean containsValue(V value) {
        return this.mapping.containsValue(value);
    }

    public V get(Emoji key) {
        this.cursor.setId(key);
        return this.mapping.get(this.cursor);
    }

    @Nullable
    public V put(Emoji key, V value) {
        return this.mapping.put(new EmojiId(key), value);
    }

    public V remove(Emoji key) {
        this.cursor.setId(key);
        return this.mapping.remove(this.cursor);
    }

    public void putAll(@NotNull Map<? extends Emoji, ? extends V> m) {
        m.forEach(this::put);
    }

    public void clear() {
        this.mapping.clear();
    }

    @NotNull
    public Set<ButtonId<?>> keySet() {
        return this.mapping.keySet();
    }

    @NotNull
    public Collection<V> values() {
        return this.mapping.values();
    }

    @NotNull
    public Set<Map.Entry<ButtonId<?>, V>> entrySet() {
        return this.mapping.entrySet();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EmojiMapping that = (EmojiMapping)o;
        return Objects.equals(this.mapping, that.mapping);
    }

    public int hashCode() {
        return Objects.hashCode(this.mapping);
    }
}

