/*
 * Decompiled with CFR 0.152.
 */
package com.github.ygimenez.model;

import com.github.ygimenez.method.Pages;
import com.github.ygimenez.model.ButtonId;
import com.github.ygimenez.model.EmbedCluster;
import com.github.ygimenez.model.EmojiId;
import com.github.ygimenez.model.Page;
import com.github.ygimenez.model.TextId;
import com.github.ygimenez.type.Action;
import java.util.EnumMap;
import java.util.Map;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.interactions.components.buttons.Button;
import net.dv8tion.jda.api.interactions.components.buttons.ButtonStyle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InteractPage
extends Page {
    private final Map<ButtonStyle, ButtonStyle> styles = new EnumMap<ButtonStyle, ButtonStyle>(ButtonStyle.class);
    private final Map<Action, String> caption = new EnumMap<Action, String>(Action.class);

    protected InteractPage(@NotNull Object content) {
        super(content);
    }

    public static InteractPage of(@NotNull String content) {
        return new InteractPage(content);
    }

    public static InteractPage of(@NotNull MessageEmbed content) {
        return new InteractPage(content);
    }

    public static InteractPage of(@NotNull EmbedCluster content) {
        return new InteractPage(content);
    }

    public Map<ButtonStyle, ButtonStyle> getStyles() {
        return this.styles;
    }

    public void overrideStyle(ButtonStyle original, ButtonStyle override) {
        this.styles.put(original, override);
    }

    public Map<Action, String> getCaptions() {
        return this.caption;
    }

    public Button makeButton(@NotNull Action action) {
        ButtonStyle style = this.styles.getOrDefault((Object)action.getStyle(), ButtonStyle.SECONDARY);
        String key = action.name() + "." + (int)(Math.random() * 2.147483647E9);
        if (action == Action.NONE) {
            return Button.secondary(key, "\u200b").asDisabled();
        }
        return Button.of(style, key, this.caption.get((Object)action), Pages.getPaginator().getEmoji(action));
    }

    public Button makeButton(@Nullable ButtonId<?> id) {
        if (id != null) {
            String key = id.extractId() + "." + (int)(Math.random() * 2.147483647E9);
            if (id instanceof TextId) {
                return Button.of(id.getStyle(), key, id.getLabel());
            }
            if (id instanceof EmojiId) {
                return Button.of(id.getStyle(), key, id.getLabel(), ((EmojiId)id).getId());
            }
        }
        return Button.secondary(String.valueOf((int)(Math.random() * 2.147483647E9)), "\u200b").asDisabled();
    }
}

