/*
 * Decompiled with CFR 0.152.
 */
package com.github.ygimenez.model;

import com.github.ygimenez.model.EmbedCluster;
import java.util.stream.Collectors;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.MessageEmbed;
import org.jetbrains.annotations.NotNull;

public class Page {
    private final Object content;

    protected Page(@NotNull Object content) throws IllegalArgumentException {
        if (!(content instanceof String || content instanceof MessageEmbed || content instanceof EmbedCluster)) {
            throw new IllegalArgumentException("Page content must be either a String or a MessageEmbed");
        }
        this.content = content;
    }

    public static Page of(@NotNull String content) {
        return new Page(content);
    }

    public static Page of(@NotNull MessageEmbed content) {
        return new Page(content);
    }

    public static Page of(@NotNull EmbedCluster content) {
        return new Page(content);
    }

    public Object getContent() {
        return this.content;
    }

    public String toString() {
        if (this.content instanceof Message) {
            return ((Message)this.content).getContentRaw();
        }
        if (this.content instanceof MessageEmbed) {
            return ((MessageEmbed)this.content).getDescription();
        }
        if (this.content instanceof EmbedCluster) {
            return ((EmbedCluster)this.content).getEmbeds().stream().map(MessageEmbed::getDescription).collect(Collectors.joining("\n"));
        }
        return "Unknown type";
    }
}

