/*
 * Decompiled with CFR 0.152.
 */
package com.github.ygimenez.model;

import com.github.ygimenez.listener.EventHandler;
import com.github.ygimenez.model.PUtilsConfig;
import com.github.ygimenez.model.TaskScheduler;
import com.github.ygimenez.model.ThrowingConsumer;
import com.github.ygimenez.type.Action;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import net.dv8tion.jda.api.entities.emoji.Emoji;
import net.dv8tion.jda.api.interactions.InteractionHook;
import net.dv8tion.jda.api.interactions.components.LayoutComponent;
import net.dv8tion.jda.internal.utils.JDALogger;
import org.slf4j.Logger;

public class Paginator {
    private final TaskScheduler scheduler = new TaskScheduler();
    private final EventHandler evtHandler = new EventHandler();
    private Object handler = null;
    private boolean removeOnReact = false;
    private boolean eventLocked = false;
    private boolean deleteOnCancel = false;
    private Map<Action, Emoji> emotes = new EnumMap<Action, Emoji>(Action.class);
    private ThrowingConsumer<InteractionHook> onRemove = hook -> hook.editOriginalComponents(new LayoutComponent[0]).submit();
    private Logger logger = null;

    protected Paginator() {
    }

    public Paginator(Object handler) {
        this.handler = handler;
    }

    public Object getHandler() {
        return this.handler;
    }

    protected void setHandler(Object handler) {
        this.handler = handler;
        this.logger = JDALogger.getLog("Pagination-Utils");
    }

    public boolean isRemoveOnReact() {
        return this.removeOnReact;
    }

    protected void setRemoveOnReact(boolean removeOnReact) {
        this.removeOnReact = removeOnReact;
    }

    public boolean isEventLocked() {
        return this.eventLocked;
    }

    protected void setEventLocked(boolean hashLocking) {
        this.eventLocked = hashLocking;
    }

    public boolean isDeleteOnCancel() {
        return this.deleteOnCancel;
    }

    protected void setDeleteOnCancel(boolean deleteOnCancel) {
        this.deleteOnCancel = deleteOnCancel;
    }

    public ThrowingConsumer<InteractionHook> getOnRemove() {
        return this.onRemove;
    }

    public void setOnRemove(ThrowingConsumer<InteractionHook> onRemove) {
        this.onRemove = onRemove;
    }

    public Map<Action, Emoji> getEmotes() {
        return this.emotes;
    }

    public Emoji getEmoji(Action action) {
        return this.emotes.getOrDefault((Object)action, action.getEmoji());
    }

    protected void finishEmotes() {
        this.emotes = Collections.unmodifiableMap(this.emotes);
    }

    public TaskScheduler getScheduler() {
        return this.scheduler;
    }

    public EventHandler getEvtHandler() {
        return this.evtHandler;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void log(PUtilsConfig.LogLevel level, String msg, Throwable t) {
        if (PUtilsConfig.getLogLevel().compareTo(level) >= 0) {
            this.logger.error("[{}] {}", level.name().replace("_", " "), msg, t);
        }
    }

    public void log(PUtilsConfig.LogLevel level, String msg) {
        if (PUtilsConfig.getLogLevel().compareTo(level) >= 0) {
            this.logger.error("[{}] {}", (Object)level.name().replace("_", " "), (Object)msg);
        }
    }
}

