/*
 * Decompiled with CFR 0.152.
 */
package com.github.ygimenez.model;

import com.github.ygimenez.exception.AlreadyAssignedException;
import com.github.ygimenez.exception.InvalidHandlerException;
import com.github.ygimenez.exception.InvalidStateException;
import com.github.ygimenez.method.Pages;
import com.github.ygimenez.model.Paginator;
import com.github.ygimenez.model.ThrowingConsumer;
import com.github.ygimenez.type.Action;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.entities.emoji.Emoji;
import net.dv8tion.jda.api.interactions.InteractionHook;
import net.dv8tion.jda.api.sharding.ShardManager;
import org.jetbrains.annotations.NotNull;

public class PaginatorBuilder {
    private final Paginator paginator;

    private PaginatorBuilder(@NotNull Paginator paginator) {
        this.paginator = paginator;
    }

    public static PaginatorBuilder createPaginator() {
        return new PaginatorBuilder(new Paginator());
    }

    public static PaginatorBuilder createPaginator(@NotNull JDA handler) {
        return new PaginatorBuilder(new Paginator(handler));
    }

    public static PaginatorBuilder createPaginator(@NotNull ShardManager handler) {
        return new PaginatorBuilder(new Paginator(handler));
    }

    public static Paginator createSimplePaginator(@NotNull JDA handler) {
        Paginator p = new Paginator(handler);
        p.finishEmotes();
        return p;
    }

    public static Paginator createSimplePaginator(@NotNull ShardManager handler) {
        Paginator p = new Paginator(handler);
        p.finishEmotes();
        return p;
    }

    public Object getHandler() {
        return this.paginator.getHandler();
    }

    public PaginatorBuilder setHandler(@NotNull JDA handler) {
        this.paginator.setHandler(handler);
        return this;
    }

    public PaginatorBuilder setHandler(@NotNull ShardManager handler) {
        this.paginator.setHandler(handler);
        return this;
    }

    public boolean willRemoveOnReact() {
        return this.paginator.isRemoveOnReact();
    }

    public PaginatorBuilder shouldRemoveOnReact(boolean shouldRemove) {
        this.paginator.setRemoveOnReact(shouldRemove);
        return this;
    }

    public boolean isEventLocking() {
        return this.paginator.isRemoveOnReact();
    }

    public PaginatorBuilder shouldEventLock(boolean shouldLock) {
        this.paginator.setEventLocked(shouldLock);
        return this;
    }

    public boolean shouldDeleteOnCancel() {
        return this.paginator.isDeleteOnCancel();
    }

    public PaginatorBuilder setDeleteOnCancel(boolean deleteOnCancel) {
        this.paginator.setDeleteOnCancel(deleteOnCancel);
        return this;
    }

    public ThrowingConsumer<InteractionHook> getOnRemove() {
        return this.paginator.getOnRemove();
    }

    public PaginatorBuilder setOnRemove(ThrowingConsumer<InteractionHook> onRemove) {
        this.paginator.setOnRemove(onRemove);
        return this;
    }

    public Emoji getEmote(@NotNull Action action) {
        return this.paginator.getEmoji(action);
    }

    public PaginatorBuilder setEmote(@NotNull Action action, @NotNull String code) throws InvalidHandlerException {
        return this.setEmote(action, Emoji.fromFormatted(code));
    }

    public PaginatorBuilder setEmote(@NotNull Action action, @NotNull Emoji emoji) throws InvalidHandlerException {
        if (this.paginator.getHandler() == null) {
            throw new InvalidHandlerException();
        }
        if (this.paginator.getEmotes().containsValue(emoji)) {
            throw new AlreadyAssignedException();
        }
        this.paginator.getEmotes().put(action, emoji);
        return this;
    }

    public Paginator build() {
        if (this.paginator.getHandler() == null) {
            throw new InvalidStateException();
        }
        this.paginator.finishEmotes();
        return this.paginator;
    }

    public void activate() throws InvalidHandlerException {
        if (this.paginator.getHandler() == null) {
            throw new InvalidStateException();
        }
        this.paginator.finishEmotes();
        Pages.activate(this.paginator);
    }
}

