/*
 * Decompiled with CFR 0.152.
 */
package com.github.ygimenez.model;

import com.github.ygimenez.model.ButtonId;
import java.util.Objects;
import java.util.regex.Pattern;
import net.dv8tion.jda.api.interactions.components.buttons.ButtonStyle;
import org.jetbrains.annotations.NotNull;

public class TextId
implements ButtonId<String> {
    public static final Pattern ID_PATTERN = Pattern.compile("\\.(?=\\d+$)");
    private final String id;
    private final String label;
    private final ButtonStyle style;

    public TextId(@NotNull String id) {
        this(id, id, ButtonStyle.SECONDARY);
    }

    public TextId(@NotNull String id, String label) {
        this(id, label, ButtonStyle.SECONDARY);
    }

    public TextId(@NotNull String id, @NotNull ButtonStyle style) {
        this(id, id, style);
    }

    public TextId(@NotNull String id, @NotNull String label, @NotNull ButtonStyle style) {
        if (id.contains(".")) {
            id = ID_PATTERN.split(id)[0];
        }
        this.id = id;
        this.label = label;
        this.style = style;
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    @NotNull
    public String getLabel() {
        return this.label;
    }

    @Override
    public ButtonStyle getStyle() {
        return this.style;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ButtonId)) {
            return false;
        }
        ButtonId textId = (ButtonId)o;
        return Objects.equals(this.id, textId.getId());
    }

    public int hashCode() {
        return Objects.hashCode(this.id);
    }
}

