/*
 * Decompiled with CFR 0.152.
 */
package com.github.ygimenez.model;

import com.github.ygimenez.model.ButtonId;
import com.github.ygimenez.model.IdCursor;
import com.github.ygimenez.model.Mapping;
import com.github.ygimenez.model.TextId;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextMapping<V>
implements Mapping<V> {
    private final Map<ButtonId<?>, V> mapping;
    private final IdCursor<String> cursor = new IdCursor();

    public TextMapping() {
        this(new LinkedHashMap());
    }

    public TextMapping(Map<ButtonId<?>, V> mapping) {
        this.mapping = mapping;
    }

    @Override
    public Map<ButtonId<?>, V> toMap() {
        return this.mapping;
    }

    public int size() {
        return this.mapping.size();
    }

    public boolean isEmpty() {
        return this.mapping.isEmpty();
    }

    public boolean containsKey(String key) {
        this.cursor.setId(key);
        return this.mapping.containsKey(this.cursor);
    }

    public boolean containsValue(V value) {
        return this.mapping.containsValue(value);
    }

    public V get(String key) {
        this.cursor.setId(key);
        return this.mapping.get(this.cursor);
    }

    @Nullable
    public V put(String key, V value) {
        return this.mapping.put(new TextId(key), value);
    }

    public V remove(String key) {
        this.cursor.setId(key);
        return this.mapping.remove(this.cursor);
    }

    public void putAll(@NotNull Map<? extends String, ? extends V> m) {
        m.forEach(this::put);
    }

    public void clear() {
        this.mapping.clear();
    }

    @NotNull
    public Set<ButtonId<?>> keySet() {
        return this.mapping.keySet();
    }

    @NotNull
    public Collection<V> values() {
        return this.mapping.values();
    }

    @NotNull
    public Set<Map.Entry<ButtonId<?>, V>> entrySet() {
        return this.mapping.entrySet();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TextMapping that = (TextMapping)o;
        return Objects.equals(this.mapping, that.mapping);
    }

    public int hashCode() {
        return Objects.hashCode(this.mapping);
    }
}

