/*
 * Decompiled with CFR 0.152.
 */
package com.github.ygimenez.model.helper;

import com.github.ygimenez.method.Pages;
import com.github.ygimenez.model.ButtonId;
import com.github.ygimenez.model.ButtonWrapper;
import com.github.ygimenez.model.EmojiId;
import com.github.ygimenez.model.EmojiMapping;
import com.github.ygimenez.model.TextId;
import com.github.ygimenez.model.TextMapping;
import com.github.ygimenez.model.ThrowingConsumer;
import com.github.ygimenez.model.helper.BaseHelper;
import com.github.ygimenez.type.Action;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.emoji.Emoji;
import net.dv8tion.jda.api.interactions.components.ActionComponent;
import net.dv8tion.jda.api.interactions.components.ActionRow;
import net.dv8tion.jda.api.interactions.components.LayoutComponent;
import net.dv8tion.jda.api.interactions.components.buttons.Button;
import net.dv8tion.jda.api.interactions.components.buttons.ButtonStyle;
import net.dv8tion.jda.api.utils.messages.MessageRequest;
import org.jetbrains.annotations.NotNull;

public class ButtonizeHelper
extends BaseHelper<ButtonizeHelper, Map<ButtonId<?>, ThrowingConsumer<ButtonWrapper>>> {
    private Consumer<Message> onFinalization = null;

    public ButtonizeHelper(boolean useButtons) {
        super(ButtonizeHelper.class, new LinkedHashMap(), useButtons);
    }

    public ButtonizeHelper(@NotNull Map<ButtonId<?>, ThrowingConsumer<ButtonWrapper>> buttons, boolean useButtons) {
        super(ButtonizeHelper.class, buttons, useButtons);
    }

    public ButtonizeHelper(@NotNull TextMapping<ThrowingConsumer<ButtonWrapper>> buttons, boolean useButtons) {
        this(buttons.toMap(), useButtons);
    }

    public ButtonizeHelper(@NotNull EmojiMapping<ThrowingConsumer<ButtonWrapper>> buttons, boolean useButtons) {
        this(buttons.toMap(), useButtons);
    }

    public ButtonizeHelper addAction(@NotNull Emoji emoji, @NotNull ThrowingConsumer<ButtonWrapper> action) {
        return this.addAction(emoji, ButtonStyle.SECONDARY, action);
    }

    public ButtonizeHelper addAction(@NotNull Emoji emoji, @NotNull ButtonStyle style, @NotNull ThrowingConsumer<ButtonWrapper> action) {
        ((Map)this.getContent()).put(new EmojiId(emoji, style), action);
        return this;
    }

    public ButtonizeHelper addAction(@NotNull String label, @NotNull ThrowingConsumer<ButtonWrapper> action) {
        return this.addAction(label, ButtonStyle.SECONDARY, action);
    }

    public ButtonizeHelper addAction(@NotNull String label, @NotNull ButtonStyle style, @NotNull ThrowingConsumer<ButtonWrapper> action) {
        ((Map)this.getContent()).put(new TextId(label, style), action);
        return this;
    }

    public ButtonizeHelper clearActions() {
        ((Map)this.getContent()).clear();
        return this;
    }

    public Consumer<Message> getOnFinalization() {
        return this.onFinalization;
    }

    public ButtonizeHelper setOnFinalization(Consumer<Message> onFinalization) {
        this.onFinalization = onFinalization;
        return this;
    }

    @Override
    public <Out extends MessageRequest<Out>> List<LayoutComponent> getComponents(Out action) {
        if (!this.isUsingButtons()) {
            return List.of();
        }
        ArrayList<LayoutComponent> rows = new ArrayList<LayoutComponent>();
        ArrayList<Button> row = new ArrayList<Button>();
        for (ButtonId k : ((Map)this.getContent()).keySet()) {
            Object id;
            if (row.size() == 5) {
                rows.add(ActionRow.of(row));
                row = new ArrayList();
            }
            if (k instanceof TextId) {
                id = k.extractId();
                row.add(Button.of(k.getStyle(), (String)id, (String)id));
                continue;
            }
            id = ((EmojiId)k).getId();
            row.add(Button.of(k.getStyle(), k.extractId(), (Emoji)id));
        }
        boolean hasCancel = ((Map)this.getContent()).keySet().stream().anyMatch(b -> Objects.equals(b.getId(), Pages.getPaginator().getEmoji(Action.CANCEL)));
        if (!hasCancel && this.isCancellable()) {
            Button button = Button.danger(Action.CANCEL.name(), Pages.getPaginator().getEmoji(Action.CANCEL));
            if (rows.size() == 5 && row.size() == 5) {
                row.set(4, button);
            } else if (row.size() == 5) {
                rows.add(ActionRow.of(row));
                row = new ArrayList();
                row.add(button);
            } else {
                row.add(button);
            }
        }
        rows.add(ActionRow.of(row));
        return rows;
    }

    @Override
    public boolean shouldUpdate(Message msg) {
        Set ids2;
        if (!this.isUsingButtons()) {
            return false;
        }
        Predicate<Set> checks = ids -> !this.isCancellable() || ids.contains(Action.getId(Pages.getPaginator().getEmoji(Action.CANCEL)));
        return !(checks = checks.and(ids -> {
            for (ButtonId id : ((Map)this.getContent()).keySet()) {
                String key = id instanceof EmojiId ? Action.getId(((EmojiId)id).getId()) : String.valueOf(id.getId());
                if (ids.contains(key)) continue;
                return false;
            }
            return true;
        })).test(ids2 = msg.getButtons().stream().map(ActionComponent::getId).collect(Collectors.toSet()));
    }

    @Override
    public ButtonizeHelper clone() {
        return new ButtonizeHelper(new LinkedHashMap((Map)this.getContent()), this.isUsingButtons());
    }
}

