/*
 * Decompiled with CFR 0.152.
 */
package com.github.ygimenez.model.helper;

import com.github.ygimenez.method.Pages;
import com.github.ygimenez.model.ButtonId;
import com.github.ygimenez.model.EmojiId;
import com.github.ygimenez.model.EmojiMapping;
import com.github.ygimenez.model.InteractPage;
import com.github.ygimenez.model.Page;
import com.github.ygimenez.model.TextId;
import com.github.ygimenez.model.TextMapping;
import com.github.ygimenez.model.helper.BaseHelper;
import com.github.ygimenez.type.Action;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.entities.emoji.Emoji;
import net.dv8tion.jda.api.interactions.components.ActionComponent;
import net.dv8tion.jda.api.interactions.components.ActionRow;
import net.dv8tion.jda.api.interactions.components.LayoutComponent;
import net.dv8tion.jda.api.interactions.components.buttons.Button;
import net.dv8tion.jda.api.interactions.components.buttons.ButtonStyle;
import net.dv8tion.jda.api.utils.messages.MessageRequest;
import org.jetbrains.annotations.NotNull;

public class CategorizeHelper
extends BaseHelper<CategorizeHelper, Map<ButtonId<?>, Page>> {
    public CategorizeHelper(boolean useButtons) {
        super(CategorizeHelper.class, new LinkedHashMap(), useButtons);
    }

    public CategorizeHelper(Map<ButtonId<?>, Page> categories, boolean useButtons) {
        super(CategorizeHelper.class, categories, useButtons);
    }

    public CategorizeHelper(TextMapping<Page> categories, boolean useButtons) {
        this(categories.toMap(), useButtons);
    }

    public CategorizeHelper(@NotNull EmojiMapping<Page> categories, boolean useButtons) {
        this(categories.toMap(), useButtons);
    }

    public CategorizeHelper addCategory(@NotNull Emoji emoji, @NotNull Page page) {
        return this.addCategory(emoji, ButtonStyle.SECONDARY, page);
    }

    public CategorizeHelper addCategory(@NotNull Emoji emoji, @NotNull ButtonStyle style, @NotNull Page page) {
        ((Map)this.getContent()).put(new EmojiId(emoji, style), page);
        return this;
    }

    public CategorizeHelper addCategory(@NotNull String label, @NotNull Page page) {
        return this.addCategory(label, ButtonStyle.SECONDARY, page);
    }

    public CategorizeHelper addCategory(@NotNull String label, @NotNull ButtonStyle style, @NotNull Page page) {
        ((Map)this.getContent()).put(new TextId(label, style), page);
        return this;
    }

    public CategorizeHelper clearCategories() {
        ((Map)this.getContent()).clear();
        return this;
    }

    @Override
    public <Out extends MessageRequest<Out>> List<LayoutComponent> getComponents(Out action) {
        if (!this.isUsingButtons()) {
            return List.of();
        }
        ArrayList<LayoutComponent> rows = new ArrayList<LayoutComponent>();
        ArrayList<Button> row = new ArrayList<Button>();
        for (Map.Entry e : ((Map)this.getContent()).entrySet()) {
            InteractPage p;
            if (row.size() == 5) {
                rows.add(ActionRow.of(row));
                row = new ArrayList();
            }
            if ((p = (InteractPage)e.getValue()) == null) continue;
            Button b = p.makeButton((ButtonId)e.getKey());
            if (p.getContent() instanceof MessageEmbed) {
                for (MessageEmbed embed : action.getEmbeds()) {
                    if (!embed.equals(p.getContent())) continue;
                    b = b.asDisabled();
                    break;
                }
            } else if (action.getContent().equals(p.getContent())) {
                b = b.asDisabled();
            }
            row.add(b);
        }
        if (this.isCancellable()) {
            Button button = Button.danger(Action.CANCEL.name(), Pages.getPaginator().getEmoji(Action.CANCEL));
            if (rows.size() == 5 && row.size() == 5) {
                row.set(4, button);
            } else if (row.size() == 5) {
                rows.add(ActionRow.of(row));
                row = new ArrayList();
                row.add(button);
            } else {
                row.add(button);
            }
        }
        rows.add(ActionRow.of(row));
        return rows;
    }

    @Override
    public boolean shouldUpdate(Message msg) {
        Set ids2;
        if (!this.isUsingButtons()) {
            return false;
        }
        Predicate<Set> checks = ids -> !this.isCancellable() || ids.contains(Action.getId(Pages.getPaginator().getEmoji(Action.CANCEL)));
        return !(checks = checks.and(ids -> {
            for (ButtonId id : ((Map)this.getContent()).keySet()) {
                String key = id instanceof EmojiId ? Action.getId(((EmojiId)id).getId()) : String.valueOf(id.getId());
                if (ids.contains(key)) continue;
                return false;
            }
            return true;
        })).test(ids2 = msg.getButtons().stream().map(ActionComponent::getId).collect(Collectors.toSet()));
    }

    @Override
    public CategorizeHelper clone() {
        return new CategorizeHelper(new LinkedHashMap((Map)this.getContent()), this.isUsingButtons());
    }
}

