/*
 * Decompiled with CFR 0.152.
 */
package com.github.ygimenez.model.helper;

import com.github.ygimenez.exception.NullPageException;
import com.github.ygimenez.model.InteractPage;
import com.github.ygimenez.model.Page;
import com.github.ygimenez.model.ThrowingFunction;
import com.github.ygimenez.model.helper.BaseHelper;
import com.github.ygimenez.type.Action;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.interactions.components.ActionRow;
import net.dv8tion.jda.api.interactions.components.ItemComponent;
import net.dv8tion.jda.api.interactions.components.LayoutComponent;
import net.dv8tion.jda.api.utils.messages.MessageRequest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LazyPaginateHelper
extends BaseHelper<LazyPaginateHelper, List<Page>> {
    private final ThrowingFunction<Integer, Page> pageLoader;
    private final boolean cache;

    public LazyPaginateHelper(@NotNull ThrowingFunction<Integer, Page> pageLoader, boolean useButtons) {
        super(LazyPaginateHelper.class, new ArrayList(), useButtons);
        this.pageLoader = pageLoader;
        this.cache = true;
        this.load(0);
    }

    public LazyPaginateHelper(@NotNull ThrowingFunction<Integer, Page> pageLoader, @Nullable List<Page> initialPages, boolean useButtons) {
        super(LazyPaginateHelper.class, initialPages, useButtons);
        this.pageLoader = pageLoader;
        this.cache = initialPages != null;
        this.load(0);
    }

    public LazyPaginateHelper addPage(@NotNull Page page) {
        if (!this.cache) {
            throw new IllegalStateException();
        }
        ((List)this.getContent()).add(page);
        return this;
    }

    public LazyPaginateHelper clearPages() {
        ((List)this.getContent()).clear();
        return this;
    }

    public ThrowingFunction<Integer, Page> getPageLoader() {
        return this.pageLoader;
    }

    @Nullable
    public Page load(int page) {
        if (this.cache) {
            for (int maxIndex = ((List)this.getContent()).size() - 1; maxIndex < page; ++maxIndex) {
                ((List)this.getContent()).add(null);
            }
        }
        Page p = this.pageLoader.apply(page);
        if (this.cache) {
            ((List)this.getContent()).set(page, p);
        }
        return p;
    }

    @Override
    public <Out extends MessageRequest<Out>> List<LayoutComponent> getComponents(Out action) {
        if (!this.isUsingButtons()) {
            return List.of();
        }
        final InteractPage p = (InteractPage)this.load(0);
        if (p == null) {
            throw new NullPageException();
        }
        return List.of(ActionRow.of((Collection<? extends ItemComponent>)new ArrayList<ItemComponent>(){
            {
                this.add(p.makeButton(Action.PREVIOUS).asDisabled());
                if (LazyPaginateHelper.this.isCancellable()) {
                    this.add(p.makeButton(Action.CANCEL));
                }
                this.add(p.makeButton(Action.NEXT));
            }
        }));
    }

    @Override
    public boolean shouldUpdate(Message msg) {
        if (!this.isUsingButtons()) {
            return true;
        }
        Predicate<Set> checks = e -> e.containsAll(Set.of(Action.PREVIOUS, Action.NEXT));
        Set actions = msg.getButtons().stream().map(Action::fromButton).collect(Collectors.toSet());
        if (this.isCancellable()) {
            checks = checks.and(e -> e.contains((Object)Action.CANCEL));
        }
        return !checks.test(actions);
    }

    @Override
    public LazyPaginateHelper clone() {
        return new LazyPaginateHelper(this.pageLoader, this.cache ? new ArrayList((Collection)this.getContent()) : null, this.isUsingButtons());
    }
}

