/*
 * Decompiled with CFR 0.152.
 */
package com.github.ygimenez.model.helper;

import com.github.ygimenez.model.InteractPage;
import com.github.ygimenez.model.Page;
import com.github.ygimenez.model.helper.BaseHelper;
import com.github.ygimenez.type.Action;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.interactions.components.ActionRow;
import net.dv8tion.jda.api.interactions.components.ItemComponent;
import net.dv8tion.jda.api.interactions.components.LayoutComponent;
import net.dv8tion.jda.api.utils.messages.MessageRequest;
import org.jetbrains.annotations.NotNull;

public class PaginateHelper
extends BaseHelper<PaginateHelper, List<Page>> {
    private int skipAmount = 0;
    private boolean fastForward = false;

    public PaginateHelper(boolean useButtons) {
        super(PaginateHelper.class, new ArrayList(), useButtons);
    }

    public PaginateHelper(@NotNull List<Page> pages, boolean useButtons) {
        super(PaginateHelper.class, pages, useButtons);
    }

    public PaginateHelper addPage(@NotNull Page page) {
        ((List)this.getContent()).add(page);
        return this;
    }

    public PaginateHelper clearPages() {
        ((List)this.getContent()).clear();
        return this;
    }

    public int getSkipAmount() {
        return this.skipAmount;
    }

    public PaginateHelper setSkipAmount(int skipAmount) {
        this.skipAmount = skipAmount;
        return this;
    }

    public boolean isFastForward() {
        return this.fastForward;
    }

    public PaginateHelper setFastForward(boolean fastForward) {
        this.fastForward = fastForward;
        return this;
    }

    @Override
    public <Out extends MessageRequest<Out>> List<LayoutComponent> getComponents(Out action) {
        if (!this.isUsingButtons()) {
            return List.of();
        }
        final InteractPage p = (InteractPage)((List)this.getContent()).get(0);
        ArrayList<LayoutComponent> rows = new ArrayList<LayoutComponent>();
        LinkedList<ItemComponent> row = new LinkedList<ItemComponent>(){
            {
                this.add(p.makeButton(Action.PREVIOUS).asDisabled());
                if (PaginateHelper.this.isCancellable()) {
                    this.add(p.makeButton(Action.CANCEL));
                }
                this.add(p.makeButton(Action.NEXT));
            }
        };
        if (this.skipAmount > 1 && this.fastForward) {
            row.addFirst(p.makeButton(Action.NONE));
            row.addLast(p.makeButton(Action.NONE));
        } else if (this.skipAmount > 1) {
            row.addFirst(p.makeButton(Action.SKIP_BACKWARD).asDisabled());
            row.addLast(p.makeButton(Action.SKIP_FORWARD));
        } else if (this.fastForward) {
            row.addFirst(p.makeButton(Action.GOTO_FIRST).asDisabled());
            row.addLast(p.makeButton(Action.GOTO_LAST));
        }
        rows.add(ActionRow.of((Collection<? extends ItemComponent>)row));
        if (this.skipAmount > 1 && this.fastForward) {
            rows.add(ActionRow.of((Collection<? extends ItemComponent>)new ArrayList<ItemComponent>(){
                {
                    this.add(p.makeButton(Action.GOTO_FIRST).asDisabled());
                    this.add(p.makeButton(Action.SKIP_BACKWARD).asDisabled());
                    if (PaginateHelper.this.isCancellable()) {
                        this.add(p.makeButton(Action.NONE));
                    }
                    this.add(p.makeButton(Action.SKIP_FORWARD));
                    this.add(p.makeButton(Action.GOTO_LAST));
                }
            }));
        }
        return rows;
    }

    @Override
    public boolean shouldUpdate(Message msg) {
        if (this.isUsingButtons()) {
            return true;
        }
        Predicate<Set> checks = e -> e.containsAll(Set.of(Action.PREVIOUS, Action.NEXT));
        Set actions = msg.getButtons().stream().map(Action::fromButton).collect(Collectors.toSet());
        if (this.isCancellable()) {
            checks = checks.and(e -> e.contains((Object)Action.CANCEL));
        }
        if (this.skipAmount > 1) {
            checks = checks.and(e -> e.containsAll(Set.of(Action.SKIP_BACKWARD, Action.SKIP_FORWARD)));
        }
        if (this.fastForward) {
            checks = checks.and(e -> e.containsAll(Set.of(Action.GOTO_FIRST, Action.GOTO_LAST)));
        }
        return !checks.test(actions);
    }

    @Override
    public PaginateHelper clone() {
        return new PaginateHelper(new ArrayList<Page>((Collection)this.getContent()), this.isUsingButtons());
    }
}

