/*
 * Decompiled with CFR 0.152.
 */
package com.github.ygimenez.type;

import com.github.ygimenez.method.Pages;
import com.github.ygimenez.model.TextId;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import net.dv8tion.jda.api.entities.MessageReaction;
import net.dv8tion.jda.api.entities.emoji.CustomEmoji;
import net.dv8tion.jda.api.entities.emoji.Emoji;
import net.dv8tion.jda.api.entities.emoji.EmojiUnion;
import net.dv8tion.jda.api.interactions.components.buttons.Button;
import net.dv8tion.jda.api.interactions.components.buttons.ButtonStyle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum Action {
    NEXT(Emoji.fromUnicode("\u25b6"), ButtonStyle.SECONDARY),
    PREVIOUS(Emoji.fromUnicode("\u25c0"), ButtonStyle.SECONDARY),
    ACCEPT(Emoji.fromUnicode("\u2705"), ButtonStyle.SUCCESS),
    CANCEL(Emoji.fromUnicode("\u274e"), ButtonStyle.DANGER),
    SKIP_FORWARD(Emoji.fromUnicode("\u23e9"), ButtonStyle.SECONDARY),
    SKIP_BACKWARD(Emoji.fromUnicode("\u23ea"), ButtonStyle.SECONDARY),
    GOTO_FIRST(Emoji.fromUnicode("\u23ee"), ButtonStyle.SECONDARY),
    GOTO_LAST(Emoji.fromUnicode("\u23ed"), ButtonStyle.SECONDARY),
    NONE(null, ButtonStyle.SECONDARY);

    private final Emoji emj;
    private final ButtonStyle style;

    private Action(Emoji emj, ButtonStyle style) {
        this.emj = emj;
        this.style = style;
    }

    public Emoji getEmoji() {
        return this.emj;
    }

    public ButtonStyle getStyle() {
        return this.style;
    }

    public static Action getByEmoji(@NotNull Emoji emoji) {
        for (Map.Entry<Action, Emoji> entry : Pages.getPaginator().getEmotes().entrySet()) {
            if (!Objects.equals(entry.getValue(), emoji)) continue;
            return entry.getKey();
        }
        for (Action emt : Action.values()) {
            if (!Objects.equals(emt.emj, emoji)) continue;
            return emt;
        }
        return NONE;
    }

    public static boolean isNative(@NotNull Button btn) {
        if (btn.getId() == null) {
            return false;
        }
        String id = TextId.ID_PATTERN.split(btn.getId())[0];
        for (Action emt : Action.values()) {
            if (!emt.name().equals(id)) continue;
            return true;
        }
        return false;
    }

    public static boolean isNative(@NotNull MessageReaction react) {
        EmojiUnion emj = Emoji.fromFormatted(react.getEmoji().getAsReactionCode());
        for (Action emt : Action.values()) {
            if (!emt.emj.equals(emj)) continue;
            return false;
        }
        return true;
    }

    public static String getId(@NotNull Emoji emj) {
        if (emj instanceof CustomEmoji) {
            return ((CustomEmoji)emj).getId();
        }
        return emj.getName();
    }

    @Nullable
    public static Action fromButton(@NotNull Button btn) {
        return Arrays.stream(Action.values()).filter(e -> btn.getId() != null && btn.getId().contains(e.name())).findFirst().orElse(null);
    }
}

