/*
 * Decompiled with CFR 0.152.
 */
package me.m0dii.corecord;

import com.github.ygimenez.exception.InvalidHandlerException;
import com.github.ygimenez.method.Pages;
import com.github.ygimenez.model.PaginatorBuilder;
import com.github.ygimenez.type.Action;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Optional;
import me.m0dii.corecord.CoSQL;
import me.m0dii.corecord.bukkit.Metrics;
import me.m0dii.corecord.charts.MultiLineChart;
import me.m0dii.corecord.commands.CoreCoCommand;
import me.m0dii.corecord.listeners.DiscordListener;
import me.m0dii.corecord.listeners.LoggerListener;
import me.m0dii.corecord.listeners.PlayerJoin;
import me.m0dii.corecord.utils.Config;
import me.m0dii.corecord.utils.Messenger;
import me.m0dii.corecord.utils.UpdateChecker;
import me.m0dii.corecord.utils.WebhookLogger;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.JDABuilder;
import net.dv8tion.jda.api.requests.GatewayIntent;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class CoreCord
extends JavaPlugin {
    private static CoreCord instance;
    private Config cfg;
    private JDA discord;
    private DiscordListener msgListener;
    private CoSQL coSQL;

    public String getSpigotLink() {
        return "https://www.spigotmc.org/resources/91863/";
    }

    public JDA getDiscord() {
        if (this.discord == null) {
            this.initializeDiscordBOT();
        }
        return this.discord;
    }

    public CoSQL getCoSQL() {
        if (this.coSQL == null) {
            this.coSQL = new CoSQL(this);
        }
        return this.coSQL;
    }

    public void onEnable() {
        instance = this;
        this.prepareConfig();
        PluginManager pm = this.getServer().getPluginManager();
        this.msgListener = new DiscordListener(this);
        this.coSQL = new CoSQL(this);
        pm.registerEvents((Listener)new PlayerJoin(this), (Plugin)this);
        pm.registerEvents((Listener)new LoggerListener(this), (Plugin)this);
        Optional.ofNullable(this.getCommand("corecord")).ifPresent(cmd -> cmd.setExecutor((CommandExecutor)new CoreCoCommand(this)));
        this.setupMetrics();
        this.initializeDiscordBOT();
        Messenger.info("");
        Messenger.info("  __  __  ___  ");
        Messenger.info(" |  \\/  |/ _ \\ ");
        Messenger.info(" | \\  / | | | |");
        Messenger.info(" | |\\/| | | | |");
        Messenger.info(" | |  | | |_| |");
        Messenger.info(" |_|  |_|\\___/");
        Messenger.info("");
        Messenger.info("M0-CoreCord has been enabled!");
        this.checkForUpdates();
    }

    private void checkForUpdates() {
        new UpdateChecker(this, 91863).getVersion(ver -> {
            String curr = this.getPluginMeta().getVersion();
            if (!curr.equalsIgnoreCase(ver.replace("v", ""))) {
                Messenger.info("You are running an outdated version of M0-CoreCord.");
                Messenger.info("Latest version: " + ver + ", you are using: " + curr);
                Messenger.info("You can download the latest version on Spigot:");
                Messenger.info(this.getSpigotLink());
            }
        });
    }

    private void setupMetrics() {
        Metrics metrics = new Metrics(this, 11173);
        MultiLineChart c = new MultiLineChart("players_and_servers", () -> {
            HashMap<String, Integer> valueMap = new HashMap<String, Integer>();
            valueMap.put("servers", 1);
            valueMap.put("players", Bukkit.getOnlinePlayers().size());
            return valueMap;
        });
        metrics.addCustomChart(c);
    }

    public void onDisable() {
        if (this.discord != null) {
            this.discord.shutdownNow();
        }
        if (CoSQL.connection != null) {
            try {
                if (!CoSQL.connection.isClosed()) {
                    CoSQL.connection.close();
                    Messenger.info("SQL connection has been closed successfully.");
                }
            }
            catch (SQLException ex) {
                Messenger.debug(ex.getMessage());
                Messenger.warn("Failed to close SQL connection..");
            }
        }
        for (WebhookLogger logger : this.cfg.getLoggers().values()) {
            logger.close();
        }
        Messenger.info("M0-CoreCord has been disabled.");
    }

    private void prepareConfig() {
        File configFile = new File(this.getDataFolder(), "config.yml");
        if (!configFile.exists()) {
            configFile.getParentFile().mkdirs();
            this.copy(this.getResource("config.yml"), configFile);
        }
        YamlConfiguration.loadConfiguration((File)configFile);
        this.cfg = new Config();
        this.cfg.load(this);
        this.copy(this.getResource("config.yml_default"), new File(this.getDataFolder(), "config.yml_default"));
    }

    private void initializeDiscordBOT() {
        try {
            this.discord = JDABuilder.createDefault(this.cfg.getBotToken()).enableIntents(GatewayIntent.GUILD_MESSAGES, GatewayIntent.DIRECT_MESSAGES, GatewayIntent.MESSAGE_CONTENT, GatewayIntent.GUILD_MEMBERS).build();
            this.discord.awaitReady();
            this.discord.addEventListener(this.msgListener);
            PaginatorBuilder paginator = PaginatorBuilder.createPaginator().setHandler(this.discord).shouldRemoveOnReact(true).setEmote(Action.CANCEL, this.cfg.getEmbedClose()).setEmote(Action.NEXT, this.cfg.getEmbedRight()).setEmote(Action.PREVIOUS, this.cfg.getEmbedLeft()).setDeleteOnCancel(this.cfg.isDeleteOnClose());
            Pages.activate(paginator.build());
            Messenger.info("Logged in successfully as " + this.discord.getSelfUser().getAsTag());
        }
        catch (InvalidHandlerException | InterruptedException ex) {
            Messenger.warn("Discord BOT has failed to connect..");
            Messenger.warn("Please check the configuration and make sure token is correct.");
            Messenger.debug(ex.getMessage());
        }
    }

    private void copy(InputStream in, File file) {
        if (in != null) {
            try {
                int len;
                FileOutputStream out = new FileOutputStream(file);
                byte[] buf = new byte[1024];
                while ((len = in.read(buf)) > 0) {
                    ((OutputStream)out).write(buf, 0, len);
                }
                ((OutputStream)out).close();
                in.close();
            }
            catch (Exception ex) {
                Messenger.warn("Error copying config file..");
                Messenger.debug(ex.getMessage());
            }
        }
    }

    public static CoreCord getInstance() {
        return instance;
    }

    public Config getCfg() {
        return this.cfg;
    }
}

