/*
 * Decompiled with CFR 0.152.
 */
package me.m0dii.corecord.utils;

import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.m0dii.corecord.CoreCord;
import me.m0dii.corecord.utils.Message;
import me.m0dii.corecord.utils.Messenger;
import me.m0dii.corecord.utils.Utils;
import me.m0dii.corecord.utils.WebhookLogger;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.Plugin;

public class Config {
    private String cfgVersion;
    private boolean debugging = false;
    private boolean useMySQL;
    private String host;
    private String database;
    private String username;
    private String password;
    private int port;
    private String embedLeft;
    private String embedRight;
    private String embedClose;
    private String embedColor;
    private String embedTitle;
    private String embedFooter;
    private boolean deleteOnClose;
    private int rowsInPage;
    private boolean showCount;
    private String dateFormat;
    private String botToken;
    private String botPrefix;
    private boolean channelWhitelist;
    private List<String> allowedRoles;
    private List<String> allowedChannels;
    private List<String> excludedData;
    private boolean notifyUpdate;
    private FileConfiguration cfg;
    private Map<Message, String> messages;
    private Map<String, WebhookLogger> webhooks = new HashMap<String, WebhookLogger>();

    public String getMessage(Message message) {
        return this.messages.getOrDefault((Object)message, "");
    }

    public void reload(CoreCord plugin) {
        plugin.reloadConfig();
        this.load(plugin);
    }

    public void load(CoreCord plugin) {
        this.cfg = plugin.getConfig();
        this.messages = new EnumMap<Message, String>(Message.class);
        this.useMySQL = this.cfg.getBoolean("use-mysql", true);
        this.host = this.getStr("mysql-host", "localhost");
        this.database = this.getStr("mysql-database", "database");
        this.username = this.getStr("mysql-username", "root");
        this.password = this.getStr("mysql-password");
        this.port = this.cfg.getInt("mysql-port", 3306);
        this.botToken = this.getStr("discord-bot-token");
        if (this.botToken.isEmpty() || this.botToken.equals("your-token")) {
            Messenger.warn("Discord bot token is not set in the config! Please set it to use Discord features. The plugin will be disabled.");
            plugin.getServer().getPluginManager().disablePlugin((Plugin)plugin);
            return;
        }
        this.botPrefix = this.getStr("command-prefix", "co!");
        this.allowedRoles = this.cfg.getStringList("allowed-roles");
        this.debugging = this.cfg.getBoolean("debug");
        this.deleteOnClose = this.cfg.getBoolean("delete-on-close");
        this.rowsInPage = this.cfg.getInt("rows-in-page", 5);
        this.showCount = this.cfg.getBoolean("always-show-count", true);
        this.embedLeft = this.getStr("embed-page-left");
        this.embedRight = this.getStr("embed-page-right");
        this.embedClose = this.getStr("embed-close");
        this.embedColor = this.getStr("embed-color");
        this.embedTitle = this.getStr("embed-title");
        this.embedFooter = this.getStr("embed-footer");
        this.messages.put(Message.EMBED_SPECIFY_TIME, this.getStr("messages.discord.specify-time"));
        this.messages.put(Message.EMBED_CONFIG_RELOAD, this.getStr("messages.discord.config-reloaded"));
        this.messages.put(Message.EMBED_RESULT_COUNT, this.getStr("messages.discord.result-count"));
        this.messages.put(Message.EMBED_NO_RESULTS_FILTER, this.getStr("messages.discord.no-results-filter"));
        this.messages.put(Message.EMBED_NO_RESULTS, this.getStr("messages.discord.no-results"));
        this.messages.put(Message.GAME_CONFIG_RELOAD, this.getStr("messages.game.config-reloaded"));
        this.messages.put(Message.COORDINATE_ROW, this.getStr("messages.discord.coordinates"));
        this.dateFormat = this.getStr("date-format");
        this.cfgVersion = this.getStr("cfg-version");
        this.notifyUpdate = this.cfg.getBoolean("notify-update", true);
        this.channelWhitelist = this.cfg.getBoolean("channel-whitelist", false);
        this.allowedChannels = this.cfg.getStringList("channels-ids");
        this.excludedData = this.cfg.getStringList("result-excludes");
        Utils.setDateFormat(this.dateFormat);
        Messenger.debug("Config has been loaded successfully.");
        Messenger.debug("Allowed role IDs to use the commands:");
        for (String r : this.allowedRoles) {
            Messenger.debug(r);
        }
        this.loadWebhooks();
    }

    public Map<String, WebhookLogger> getLoggers() {
        return this.webhooks;
    }

    public WebhookLogger getWebhook(String ... actions) {
        return this.webhooks.values().stream().filter(l -> Arrays.stream(actions).anyMatch(l::hasAction)).findFirst().orElse(null);
    }

    private void loadWebhooks() {
        this.webhooks = new HashMap<String, WebhookLogger>();
        ConfigurationSection loggerSection = this.cfg.getConfigurationSection("webhook-loggers");
        if (loggerSection == null) {
            Messenger.warn("No webhook loggers found in config.");
            return;
        }
        for (String key : loggerSection.getKeys(false)) {
            ConfigurationSection section = this.cfg.getConfigurationSection("webhook-loggers." + key);
            if (section == null) continue;
            String url = section.getString("url");
            String channelID = section.getString("channel-id");
            if (url != null && !"webhook-url-goes-here".equals(url)) {
                WebhookLogger webhook = new WebhookLogger(url, channelID);
                webhook.addActions(section.getStringList("actions"));
                this.webhooks.put(channelID, webhook);
                continue;
            }
            Messenger.warn("Webhook logger '" + key + "' does not have a valid URL.");
        }
    }

    private String getStr(String path) {
        return this.cfg.getString(path, "");
    }

    private String getStr(String path, String def) {
        return this.cfg.getString(path, def);
    }

    public boolean isDebugEnabled() {
        return this.debugging;
    }

    public String getEmbedLeft() {
        if (this.embedLeft.isEmpty()) {
            return "\u2b05\ufe0f";
        }
        return this.embedLeft;
    }

    public String getEmbedRight() {
        if (this.embedLeft.isEmpty()) {
            return "\u27a1\ufe0f\ufe0f";
        }
        return this.embedRight;
    }

    public String getEmbedColor() {
        if (this.embedLeft.isEmpty()) {
            return "#00FFFF";
        }
        return this.embedColor;
    }

    public String getEmbedTitle() {
        if (this.embedTitle.isEmpty()) {
            return "CoreCord";
        }
        return this.embedTitle;
    }

    public int getRowsInPage() {
        if (this.rowsInPage > 25) {
            this.rowsInPage = 25;
            Messenger.debug("Too many rows in one page. Defaulting to 25.");
        }
        return this.rowsInPage;
    }

    public String getCfgVersion() {
        if (this.cfgVersion == null || this.cfgVersion.trim().isEmpty()) {
            return "1.0";
        }
        return this.cfgVersion;
    }

    public boolean isUseMySQL() {
        return this.useMySQL;
    }

    public String getHost() {
        return this.host;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public int getPort() {
        return this.port;
    }

    public String getEmbedClose() {
        return this.embedClose;
    }

    public String getEmbedFooter() {
        return this.embedFooter;
    }

    public boolean isDeleteOnClose() {
        return this.deleteOnClose;
    }

    public boolean isShowCount() {
        return this.showCount;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public String getBotToken() {
        return this.botToken;
    }

    public String getBotPrefix() {
        return this.botPrefix;
    }

    public boolean isChannelWhitelist() {
        return this.channelWhitelist;
    }

    public List<String> getAllowedRoles() {
        return this.allowedRoles;
    }

    public List<String> getAllowedChannels() {
        return this.allowedChannels;
    }

    public List<String> getExcludedData() {
        return this.excludedData;
    }

    public boolean isNotifyUpdate() {
        return this.notifyUpdate;
    }
}

