/*
 * Decompiled with CFR 0.152.
 */
package me.m0dii.corecord.utils;

import club.minnced.discord.webhook.WebhookClient;
import club.minnced.discord.webhook.WebhookClientBuilder;
import club.minnced.discord.webhook.send.WebhookEmbedBuilder;
import club.minnced.discord.webhook.send.WebhookMessageBuilder;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.jetbrains.annotations.NotNull;

public class WebhookLogger {
    private WebhookClient client;
    private final List<String> actions;
    private final String channelID;

    public WebhookLogger(@NotNull String url, @Nullable String channelID) {
        this.channelID = channelID;
        this.actions = new ArrayList<String>();
        this.setUp(url);
    }

    private void setUp(String url) {
        WebhookClientBuilder builder = new WebhookClientBuilder(url);
        this.setThreadFactory(builder);
        this.client = builder.build();
    }

    public void send(String username, String msg) {
        this.client.send(this.getMsgBuilder(username, msg).build());
    }

    public void close() {
        this.client.close();
    }

    public boolean hasAction(String action) {
        return this.actions.contains(action);
    }

    public void addActions(List<String> actions) {
        this.actions.addAll(actions);
    }

    public WebhookMessageBuilder getMsgBuilder(String username, @Nullable String msg) {
        WebhookMessageBuilder builder = new WebhookMessageBuilder().setAvatarUrl("https://minotar.net/avatar/" + username).setUsername(username);
        if (msg != null) {
            builder.setContent(msg.trim());
        }
        return builder;
    }

    public WebhookMessageBuilder getMsgBuilder(String username, WebhookEmbedBuilder embed) {
        WebhookMessageBuilder builder = new WebhookMessageBuilder().setAvatarUrl("https://minotar.net/avatar/" + username).setUsername(username);
        if (embed != null) {
            builder.addEmbeds(embed.build());
        }
        return builder;
    }

    public void setThreadFactory(WebhookClientBuilder builder) {
        builder.setThreadFactory((Runnable job) -> {
            Thread thread = new Thread(job);
            thread.setDaemon(true);
            return thread;
        }).setWait(true);
    }

    public WebhookClient getClient(String webhookUrl) {
        WebhookClientBuilder builder = new WebhookClientBuilder(webhookUrl);
        this.setThreadFactory(builder);
        return builder.build();
    }
}

