/*
 * Decompiled with CFR 0.152.
 */
package dev.letsgoaway.geyserextras;

import dev.letsgoaway.geyserextras.ServerType;
import dev.letsgoaway.geyserextras.core.GeyserExtras;
import dev.letsgoaway.geyserextras.core.parity.java.blockdisplay.BlockDisplayEntity;
import dev.letsgoaway.geyserextras.core.utils.IsAvailable;
import java.text.DecimalFormat;
import java.time.Duration;
import java.time.Instant;

public class InitializeLogger {
    private static Instant start;

    public static void start() {
        start = Instant.now();
        InitializeLogger.info("--------------GeyserExtras--------------");
        InitializeLogger.info("Version: 2.0.0-BETA-9");
        InitializeLogger.info("Server Type: " + ServerType.get());
        InitializeLogger.info("Platform Type: " + ServerType.platform().platformName());
        if (ServerType.type != ServerType.BUNGEECORD && ServerType.type != ServerType.EXTENSION) {
            InitializeLogger.info("Floodgate installed: " + (IsAvailable.floodgate() ? "Yes" : "No"));
        }
        if (ServerType.type != ServerType.EXTENSION) {
            InitializeLogger.info("PacketEvents installed: " + (IsAvailable.packetevents() ? "Yes" : "No"));
            if (IsAvailable.packetevents()) {
                InitializeLogger.warn("Some features require PacketEvents, which can be downloaded at https://modrinth.com/plugin/packetevents.");
                InitializeLogger.warn("Features that require PacketEvents will not run!");
            }
        }
    }

    public static void end() {
        if (GeyserExtras.GE.getConfig().isEnableBlockDisplayWorkaround()) {
            BlockDisplayEntity.buildEntityDef();
        }
        DecimalFormat r3 = new DecimalFormat("0.000");
        Instant finish = Instant.now();
        InitializeLogger.info("Done! (" + r3.format((double)Duration.between(start, finish).toMillis() / 1000.0) + "s)");
        if (ServerType.type != ServerType.STANDALONE) {
            InitializeLogger.info("----------------------------------------");
        } else {
            InitializeLogger.info("-----------------------------------------------");
        }
        GeyserExtras.SERVER.onGeyserExtrasInitialize();
    }

    public static void endNoDone() {
        InitializeLogger.info("----------------------------------------");
    }

    public static void logTask(String start, Runnable task, String end) {
        InitializeLogger.info(start);
        task.run();
        InitializeLogger.info(end);
    }

    public static void logTask(Runnable task, String onComplete) {
        task.run();
        InitializeLogger.info(onComplete);
    }

    private static void info(String s) {
        GeyserExtras.SERVER.log(s);
    }

    private static void warn(String s) {
        GeyserExtras.SERVER.warn(s);
    }
}

