/*
 * Decompiled with CFR 0.152.
 */
package dev.letsgoaway.geyserextras.core.parity.java.menus.packs;

import dev.letsgoaway.geyserextras.core.ExtrasPlayer;
import dev.letsgoaway.geyserextras.core.form.BedrockMenu;
import dev.letsgoaway.geyserextras.core.form.elements.Button;
import dev.letsgoaway.geyserextras.core.parity.java.menus.packs.PackMenu;
import java.util.UUID;
import org.geysermc.cumulus.form.SimpleForm;
import org.geysermc.cumulus.util.FormImage;
import org.geysermc.geyser.api.pack.ResourcePack;
import org.geysermc.geyser.api.pack.ResourcePackManifest;

public class PackManagerMenu
extends BedrockMenu {
    private final ResourcePack pack;
    private final UUID packID;
    private boolean openingSubMenu = false;

    public PackManagerMenu(ResourcePack pack) {
        this.pack = pack;
        this.packID = pack.manifest().header().uuid();
    }

    @Override
    public SimpleForm create(ExtrasPlayer player) {
        ResourcePackManifest.Header header = this.pack.manifest().header();
        this.setTitle(header.name());
        String info = header.description() + "\n\n%manifestvalidation.packid " + header.uuid() + "\n%manifestvalidation.packversion " + header.version().toString() + "\n";
        this.setHeader(info);
        if (!player.getPreferences().getSelectedPacks().contains(this.packID)) {
            this.add(new Button("%gui.select", FormImage.Type.PATH, "textures/ui/plus.png", () -> this.addPack(player)));
        } else {
            int pos = player.getPreferences().getSelectedPacks().indexOf(this.packID);
            if (pos != 0) {
                this.add(new Button("%gui.up", FormImage.Type.PATH, "textures/ui/up_arrow.png", () -> this.up(player)));
            }
            this.add(new Button("%addExternalServerScreen.removeButtonLabel", FormImage.Type.PATH, "textures/ui/minus.png", () -> this.removePack(player)));
            if (pos != player.getPreferences().getSelectedPacks().size() - 1) {
                this.add(new Button("%gui.down", FormImage.Type.PATH, "textures/ui/down_arrow.png", () -> this.down(player)));
            }
        }
        return super.create(player);
    }

    @Override
    public void onClose(ExtrasPlayer player) {
        super.onClose(player);
        player.sendForm(new PackMenu());
    }

    @Override
    public void onButtonClick(ExtrasPlayer player) {
        super.onButtonClick(player);
        if (!this.openingSubMenu) {
            player.setPacksUpdated(true);
            player.sendForm(new PackMenu());
        }
    }

    private void addPack(ExtrasPlayer player) {
        player.getPreferences().getSelectedPacks().add(0, this.packID);
    }

    private void removePack(ExtrasPlayer player) {
        player.getPreferences().getSelectedPacks().remove(this.packID);
    }

    private void up(ExtrasPlayer player) {
        int lastPos = player.getPreferences().getSelectedPacks().indexOf(this.packID);
        player.getPreferences().getSelectedPacks().remove(this.packID);
        player.getPreferences().getSelectedPacks().add(Math.max(0, lastPos - 1), this.packID);
    }

    private void down(ExtrasPlayer player) {
        int lastPos = player.getPreferences().getSelectedPacks().indexOf(this.packID);
        player.getPreferences().getSelectedPacks().remove(this.packID);
        player.getPreferences().getSelectedPacks().add(lastPos + 1, this.packID);
    }
}

