/*
 * Decompiled with CFR 0.152.
 */
package dev.letsgoaway.geyserextras.core.version;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import dev.letsgoaway.geyserextras.ServerType;
import dev.letsgoaway.geyserextras.core.GeyserExtras;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;

public class PluginVersion {
    public static final String GE_VERSION = "2.0.0-BETA-9";
    public static String latestVersion = "";
    public static String latestVersionModrinthID = "";

    public static boolean checkForUpdate() {
        if (!GeyserExtras.GE.getConfig().isCheckForUpdates()) {
            return false;
        }
        try {
            if (!ServerType.isExtension()) {
                URL url = new URL("https://api.modrinth.com/v2/project/geyserextras/version");
                URLConnection request = url.openConnection();
                request.setConnectTimeout(5000);
                request.setRequestProperty("User-Agent", "GeyserExtras/GeyserExtras/2.0.0-BETA-9");
                request.connect();
                JsonElement root = JsonParser.parseReader((Reader)new InputStreamReader((InputStream)request.getContent()));
                for (JsonElement version : root.getAsJsonArray()) {
                    ArrayList loadersArray = new ArrayList();
                    JsonArray loaders = version.getAsJsonObject().get("loaders").getAsJsonArray();
                    loaders.forEach(loader -> loadersArray.add(loader.getAsString()));
                    if (!loadersArray.contains(ServerType.type.name().toLowerCase())) continue;
                    latestVersion = version.getAsJsonObject().get("version_number").getAsString();
                    latestVersionModrinthID = version.getAsJsonObject().get("id").getAsString();
                    return !latestVersion.equals(GE_VERSION);
                }
            } else {
                URL url = new URL("https://api.github.com/repos/GeyserExtras/GeyserExtras/tags");
                URLConnection request = url.openConnection();
                request.setConnectTimeout(5000);
                request.setRequestProperty("User-Agent", "GeyserExtras/GeyserExtras/2.0.0-BETA-9");
                request.connect();
                JsonElement root = JsonParser.parseReader((Reader)new InputStreamReader((InputStream)request.getContent()));
                JsonArray rootobj = root.getAsJsonArray();
                latestVersion = rootobj.get(0).getAsJsonObject().get("name").getAsString();
                return !latestVersion.equals(GE_VERSION);
            }
            return false;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static void checkForUpdatesAndPrintToLog() {
        if (!GeyserExtras.GE.getConfig().isCheckForUpdates()) {
            return;
        }
        new Thread(() -> {
            if (PluginVersion.checkForUpdate()) {
                GeyserExtras.SERVER.warn("There is a new update to GeyserExtras!");
                GeyserExtras.SERVER.warn("You are on version 2.0.0-BETA-9 but the latest version is " + latestVersion + ".");
                if (!ServerType.isExtension()) {
                    GeyserExtras.SERVER.warn("Download & Changelog: https://modrinth.com/plugin/geyserextras/version/" + latestVersionModrinthID);
                } else {
                    GeyserExtras.SERVER.warn("Download & Changelog: https://github.com/GeyserExtras/GeyserExtras/releases/latest");
                }
            } else {
                GeyserExtras.SERVER.warn("GeyserExtras is on the latest version.");
            }
        }).start();
    }
}

