/*
 * Decompiled with CFR 0.152.
 */
package dev.letsgoaway.geyserextras.core.injectors.bedrock;

import dev.letsgoaway.geyserextras.core.ExtrasPlayer;
import dev.letsgoaway.geyserextras.core.injectors.bedrock.input.BedrockBlockInteractions;
import org.cloudburstmc.protocol.bedrock.data.PlayerAuthInputData;
import org.cloudburstmc.protocol.bedrock.packet.PlayerAuthInputPacket;
import org.geysermc.api.util.InputMode;
import org.geysermc.geyser.api.connection.GeyserConnection;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.geyser.translator.protocol.bedrock.entity.player.input.BedrockPlayerAuthInputTranslator;

@Translator(packet=PlayerAuthInputPacket.class)
public class BedrockPlayerAuthInputInjector
extends PacketTranslator<PlayerAuthInputPacket> {
    BedrockPlayerAuthInputTranslator translator = new BedrockPlayerAuthInputTranslator();

    public void translate(GeyserSession session, PlayerAuthInputPacket packet) {
        this.translator.translate(session, packet);
        ExtrasPlayer player = ExtrasPlayer.get((GeyserConnection)session);
        if (player == null) {
            return;
        }
        player.setEmoting(packet.getInputData().contains(PlayerAuthInputData.EMOTING));
        for (PlayerAuthInputData input : packet.getInputData()) {
            switch (input) {
                case PERFORM_BLOCK_ACTIONS: {
                    BedrockBlockInteractions.translate(session, packet.getPlayerActions());
                    break;
                }
                case MISSED_SWING: {
                    player.getCooldownHandler().setDigTicks(-1);
                    player.getCooldownHandler().setLastSwingTime(System.currentTimeMillis());
                    if (!session.inputMode().equals((Object)InputMode.TOUCH)) break;
                    player.swingArm();
                }
            }
        }
    }
}

