/*
 * Decompiled with CFR 0.152.
 */
package dev.letsgoaway.geyserextras.core.injectors.bedrock;

import dev.letsgoaway.geyserextras.core.ExtrasPlayer;
import dev.letsgoaway.geyserextras.core.GeyserExtras;
import dev.letsgoaway.geyserextras.core.preferences.bindings.Remappable;
import dev.letsgoaway.geyserextras.core.utils.IsAvailable;
import java.util.concurrent.TimeUnit;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacket;
import org.cloudburstmc.protocol.bedrock.packet.ServerSettingsRequestPacket;
import org.cloudburstmc.protocol.bedrock.packet.ServerSettingsResponsePacket;
import org.geysermc.cumulus.form.CustomForm;
import org.geysermc.cumulus.form.Form;
import org.geysermc.cumulus.form.impl.FormDefinitions;
import org.geysermc.geyser.api.connection.GeyserConnection;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.protocol.bedrock.BedrockServerSettingsRequestTranslator;

public class BedrockServerSettingsRequestInjector
extends BedrockServerSettingsRequestTranslator {
    public void translate(GeyserSession session, ServerSettingsRequestPacket packet) {
        if (!GeyserExtras.GE.getConfig().isEnableGeyserExtrasMenu()) {
            super.translate(session, packet);
            return;
        }
        ExtrasPlayer player = ExtrasPlayer.get((GeyserConnection)session);
        if (IsAvailable.floodgate()) {
            player.sendSystemToast(player.translateGE("ge.form_error_toast.line1"), player.translateGE("ge.form_error_toast.line2"));
            super.translate(session, packet);
            return;
        }
        player.getPreferences().runAction(Remappable.SETTINGS);
        CustomForm form = player.getPreferences().getSettingsMenuForm().open(player);
        int formId = session.getFormCache().addForm((Form)form);
        String jsonData = FormDefinitions.instance().codecFor((Form)form).jsonData((Form)form);
        session.scheduleInEventLoop(() -> {
            ServerSettingsResponsePacket serverSettingsResponsePacket = new ServerSettingsResponsePacket();
            serverSettingsResponsePacket.setFormData(jsonData);
            serverSettingsResponsePacket.setFormId(formId);
            session.sendUpstreamPacket((BedrockPacket)serverSettingsResponsePacket);
        }, 1L, TimeUnit.SECONDS);
    }
}

