/*
 * Decompiled with CFR 0.152.
 */
package dev.letsgoaway.geyserextras.core.cache;

import dev.letsgoaway.geyserextras.core.ExtrasPlayer;
import dev.letsgoaway.geyserextras.core.GeyserExtras;
import dev.letsgoaway.geyserextras.core.cache.Cache;
import dev.letsgoaway.geyserextras.core.cache.HTTP;
import dev.letsgoaway.geyserextras.core.parity.java.menus.packs.PackLoader;
import dev.letsgoaway.geyserextras.core.version.Version3;
import dev.letsgoaway.relocate.com.fasterxml.jackson.databind.JsonNode;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.geysermc.geyser.api.event.bedrock.SessionLoadResourcePacksEvent;
import org.geysermc.geyser.api.pack.PackCodec;
import org.geysermc.geyser.api.pack.ResourcePack;
import org.geysermc.geyser.api.pack.option.PriorityOption;
import org.geysermc.geyser.api.pack.option.ResourcePackOption;
import org.geysermc.geyser.api.pack.option.SubpackOption;
import org.geysermc.geyser.pack.option.GeyserPriorityOption;

public class PackCacheUtils {
    public static Path PACKS_FOLDER;
    public static Path GEYSER_OPTIONAL_PACK;
    public static Path GEYSER_EXTRAS_PACK;
    public static ResourcePack RP_GEYSER_OPTIONAL;
    public static ResourcePack RP_GEYSER_EXTRAS;

    public static void initialize() {
        File gopWorkaroundPack;
        PACKS_FOLDER = Cache.CACHE_FOLDER.resolve("packs/");
        GEYSER_OPTIONAL_PACK = PACKS_FOLDER.resolve("GeyserOptionalPack.mcpack");
        GEYSER_EXTRAS_PACK = PACKS_FOLDER.resolve("GeyserExtrasPack.mcpack");
        GeyserExtras.SERVER.log("Checking for pack updates...");
        try {
            InputStream in;
            Files.createDirectories(PACKS_FOLDER, new FileAttribute[0]);
            boolean optionalPackNeedsUpdate = PackCacheUtils.checkOptionalPack();
            boolean extrasPackNeedsUpdate = PackCacheUtils.checkExtrasPack();
            if (optionalPackNeedsUpdate || extrasPackNeedsUpdate) {
                Cache.saveCacheDates();
            }
            if (optionalPackNeedsUpdate) {
                GeyserExtras.SERVER.log("Downloading GeyserOptionalPack...");
                in = HTTP.request("https://download.geysermc.org/v2/projects/geyseroptionalpack/versions/latest/builds/latest/downloads/geyseroptionalpack");
                Files.copy(in, GEYSER_OPTIONAL_PACK, StandardCopyOption.REPLACE_EXISTING);
                GeyserExtras.SERVER.log("GeyserOptionalPack downloaded!");
            }
            if (extrasPackNeedsUpdate) {
                GeyserExtras.SERVER.log("Downloading GeyserExtrasPack...");
                in = HTTP.request("https://raw.githubusercontent.com/GeyserExtras/GeyserExtrasPack/main/GeyserExtrasPack.mcpack");
                Files.copy(in, GEYSER_EXTRAS_PACK, StandardCopyOption.REPLACE_EXISTING);
                GeyserExtras.SERVER.log("GeyserExtrasPack downloaded!");
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error while downloading resources!", e);
        }
        GeyserExtras.SERVER.log("Loading resources...");
        RP_GEYSER_OPTIONAL = ResourcePack.create((PackCodec)PackCodec.path((Path)GEYSER_OPTIONAL_PACK));
        RP_GEYSER_EXTRAS = ResourcePack.create((PackCodec)PackCodec.path((Path)GEYSER_EXTRAS_PACK));
        Path geyserMCPacks = GeyserExtras.GE.geyserApi.packDirectory();
        File geWorkaroundPack = geyserMCPacks.resolve("GeyserExtrasPack.mcpack").toFile();
        if (geWorkaroundPack.exists() && geWorkaroundPack.delete()) {
            GeyserExtras.SERVER.log("Deleted GeyserExtrasPack.mcpack from GeyserMC packs folder");
        }
        if ((gopWorkaroundPack = geyserMCPacks.resolve("GeyserOptionalPack.mcpack").toFile()).exists() && gopWorkaroundPack.delete()) {
            GeyserExtras.SERVER.log("Deleted GeyserOptionalPack.mcpack from GeyserMC packs folder");
        }
    }

    private static boolean checkOptionalPack() {
        if (!GEYSER_OPTIONAL_PACK.toFile().exists()) {
            return true;
        }
        if (!GeyserExtras.GE.getConfig().isCheckForUpdates()) {
            return false;
        }
        Version3 oldVersion = Version3.fromArray(Cache.CACHE_DATES.lastOptionalPackVersion);
        Version3 latestOptionalPackVersion = PackCacheUtils.getPackVersion("https://raw.githubusercontent.com/GeyserMC/GeyserOptionalPack/master/manifest.json");
        Cache.CACHE_DATES.lastOptionalPackVersion = latestOptionalPackVersion.asArray();
        return latestOptionalPackVersion.isNewer(oldVersion);
    }

    private static boolean checkExtrasPack() {
        if (!GEYSER_EXTRAS_PACK.toFile().exists()) {
            return true;
        }
        if (!GeyserExtras.GE.getConfig().isCheckForUpdates()) {
            return false;
        }
        Version3 oldVersion = Version3.fromArray(Cache.CACHE_DATES.lastExtrasPackVersion);
        Version3 latestExtrasPackVersion = PackCacheUtils.getPackVersion("https://raw.githubusercontent.com/GeyserExtras/GeyserExtrasPack/main/src/pack/manifest.json");
        Cache.CACHE_DATES.lastExtrasPackVersion = latestExtrasPackVersion.asArray();
        return latestExtrasPackVersion.isNewer(oldVersion);
    }

    private static Version3 getPackVersion(String url) {
        try {
            byte[] data = new URL(url).openStream().readAllBytes();
            JsonNode manifestJson = Cache.JSON_MAPPER.readTree(data);
            ArrayList<Integer> versionArray = new ArrayList<Integer>();
            for (JsonNode node : manifestJson.get("header").get("version")) {
                versionArray.add(node.asInt());
            }
            return Version3.fromList(versionArray);
        }
        catch (Exception e) {
            return Version3.fromString("0.0.0");
        }
    }

    public static void onPackLoadEvent(ExtrasPlayer player, SessionLoadResourcePacksEvent ev) {
        try {
            if (!ev.resourcePacks().contains(RP_GEYSER_OPTIONAL)) {
                ev.register(RP_GEYSER_OPTIONAL, new ResourcePackOption[]{GeyserPriorityOption.HIGHEST});
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (!ev.resourcePacks().contains(RP_GEYSER_EXTRAS)) {
                ev.register(RP_GEYSER_EXTRAS, new ResourcePackOption[]{GeyserPriorityOption.HIGHEST});
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        List<UUID> packsToLoad = player.getPreferences().getSelectedPacks();
        for (UUID pack : packsToLoad) {
            ResourcePack rp = PackLoader.PACKS.get(pack);
            try {
                if (ev.resourcePacks().contains(rp)) continue;
                String subpack = "";
                if (player.getPreferences().getSelectedSubpacks().containsKey(pack)) {
                    subpack = player.getPreferences().getSelectedSubpacks().get(pack);
                }
                ev.register(rp, new ResourcePackOption[]{PriorityOption.priority((int)(99 - packsToLoad.indexOf(pack))), SubpackOption.named((String)subpack)});
            }
            catch (Exception exception) {}
        }
    }
}

