/*
 * Decompiled with CFR 0.152.
 */
package dev.letsgoaway.geyserextras.core.injectors.java;

import dev.letsgoaway.geyserextras.core.ExtrasPlayer;
import java.util.EnumSet;
import org.geysermc.geyser.api.connection.GeyserConnection;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.geyser.translator.protocol.java.entity.player.JavaPlayerInfoUpdateTranslator;
import org.geysermc.mcprotocollib.protocol.data.game.PlayerListEntry;
import org.geysermc.mcprotocollib.protocol.data.game.PlayerListEntryAction;
import org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.ClientboundPlayerInfoUpdatePacket;

@Translator(packet=ClientboundPlayerInfoUpdatePacket.class)
public class JavaPlayerInfoUpdateInjector
extends JavaPlayerInfoUpdateTranslator {
    public void translate(GeyserSession session, ClientboundPlayerInfoUpdatePacket packet) {
        super.translate(session, packet);
        ExtrasPlayer player = ExtrasPlayer.get((GeyserConnection)session);
        EnumSet actions = packet.getActions();
        for (PlayerListEntry entry : packet.getEntries()) {
            PlayerListEntry cached = this.getCached(player, entry);
            if (actions.contains(PlayerListEntryAction.UPDATE_LISTED)) {
                if (cached == null) {
                    if (entry.isListed()) {
                        player.getTabListData().getPlayers().put(entry.getProfileId(), entry);
                    }
                } else {
                    cached.setListed(entry.isListed());
                    if (entry.isListed()) {
                        player.getTabListData().getPlayers().put(entry.getProfileId(), cached);
                        continue;
                    }
                    player.getTabListData().getPlayers().remove(entry.getProfileId());
                    continue;
                }
            }
            if (cached == null) continue;
            if (actions.contains(PlayerListEntryAction.UPDATE_DISPLAY_NAME)) {
                cached.setDisplayName(entry.getDisplayName());
            }
            if (actions.contains(PlayerListEntryAction.UPDATE_LATENCY)) {
                cached.setLatency(entry.getLatency());
            }
            if (actions.contains(PlayerListEntryAction.UPDATE_GAME_MODE)) {
                cached.setGameMode(entry.getGameMode());
            }
            player.getTabListData().getPlayers().put(entry.getProfileId(), cached);
        }
    }

    private PlayerListEntry getCached(ExtrasPlayer player, PlayerListEntry entry) {
        return player.getTabListData().getPlayers().get(entry.getProfileId());
    }
}

