/*
 * Decompiled with CFR 0.152.
 */
package dev.letsgoaway.geyserextras.core.parity.java.combat;

import dev.letsgoaway.geyserextras.core.ExtrasPlayer;
import dev.letsgoaway.geyserextras.core.utils.GUIElements;
import dev.letsgoaway.geyserextras.core.utils.MathUtils;
import dev.letsgoaway.geyserextras.core.utils.TickMath;
import java.util.Iterator;
import java.util.List;
import lombok.Generated;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.item.Items;
import org.geysermc.geyser.item.type.Item;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.util.CooldownUtils;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.GameMode;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponentTypes;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.ItemEnchantments;

public class CooldownHandler {
    private static final List<Item> readyToAttackIndicatorItems = List.of(Items.NETHERITE_AXE, Items.DIAMOND_AXE, Items.GOLDEN_AXE, Items.IRON_AXE, Items.STONE_AXE, Items.WOODEN_AXE, Items.NETHERITE_PICKAXE, Items.DIAMOND_PICKAXE, Items.GOLDEN_PICKAXE, Items.IRON_PICKAXE, Items.STONE_PICKAXE, Items.WOODEN_PICKAXE, Items.NETHERITE_SHOVEL, Items.DIAMOND_SHOVEL, Items.GOLDEN_SHOVEL, Items.IRON_SHOVEL, Items.STONE_SHOVEL, Items.WOODEN_SHOVEL, Items.NETHERITE_SWORD, Items.DIAMOND_SWORD, Items.GOLDEN_SWORD, Items.IRON_SWORD, Items.STONE_SWORD, Items.WOODEN_SWORD, Items.TRIDENT, Items.MACE);
    private static final String[] crosshair = new String[]{"\uf821", "\uf810", "\uf811", "\uf812", "\uf813", "\uf814", "\uf815", "\uf816", "\uf817", "\uf818", "\uf819", "\uf81a", "\uf81b", "\uf81c", "\uf81d", "\uf81e", "\uf81f"};
    private static final String[] hotbar = new String[]{"\uf800", "\uf801", "\uf802", "\uf803", "\uf804", "\uf805", "\uf806", "\uf807", "\uf808", "\uf809", "\uf80a", "\uf80b", "\uf80c", "\uf80d", "\uf80e", "\uf80f"};
    private static final String crosshairAttackReady = "\uf820";
    private final ExtrasPlayer player;
    public double attackSpeed = 4.0;
    public int digTicks = -1;
    public boolean readyToAttack = false;
    private GeyserSession session;
    private long lastSwingTime;
    private long lastHotbarTime = 0L;
    private long lastMouseoverID = 0L;
    private boolean skipNextItemUse1 = false;
    private long lastBlockRightClickTime = 0L;
    private boolean lastClickWasAirClick = false;
    private String lastCharSent = "";
    private double averagePing = 0.0;
    private long pingSample = 0L;
    private long pingSampleSize = 0L;
    private int lastPing = -1;

    public CooldownHandler(ExtrasPlayer player) {
        this.player = player;
        this.lastSwingTime = System.currentTimeMillis();
        this.session = player.getSession();
    }

    public boolean isTool() {
        return readyToAttackIndicatorItems.contains(this.session.getPlayerInventory().getItemInHand().asItem());
    }

    public void tick() {
        this.calculateAveragePing();
        this.readyToAttack = this.lastMouseoverID != 0L && this.session.getMouseoverEntity() != null && this.isTool() ? this.session.getMouseoverEntity().isAlive() : false;
        double time = (double)System.currentTimeMillis() + (this.player.getPreferences().isAdjustCooldownWithPing() && (double)TickMath.toMillis((float)this.getCooldownPeriod()) > this.averagePing ? this.averagePing : 0.0) - (double)this.lastSwingTime;
        double cooldown = MathUtils.restrain(time * this.attackSpeed / 1000.0, 1.0);
        this.sendCooldown(cooldown);
    }

    private void sendCooldown(double progress) {
        CooldownUtils.CooldownType position = this.session.getPreferencesCache().getCooldownPreference();
        if (position.equals((Object)CooldownUtils.CooldownType.DISABLED)) {
            return;
        }
        if (this.digTicks != -1 || progress == 1.0) {
            switch (this.session.getPreferencesCache().getCooldownPreference()) {
                case TITLE: {
                    if (this.readyToAttack && !this.lastCharSent.equals(crosshairAttackReady)) {
                        this.lastCharSent = crosshairAttackReady;
                        this.player.sendTitle("", this.lastCharSent, 0, Integer.MAX_VALUE, 0);
                        break;
                    }
                    if (this.readyToAttack || this.lastCharSent.isEmpty()) break;
                    this.lastCharSent = "";
                    this.player.resetTitle();
                    break;
                }
                case ACTIONBAR: {
                    if (this.lastCharSent.isEmpty()) break;
                    this.lastCharSent = "";
                    this.player.sendActionbarTitle(" ");
                }
            }
            return;
        }
        switch (this.session.getPreferencesCache().getCooldownPreference()) {
            case TITLE: {
                String curChar;
                int max = crosshair.length - 1;
                int cooldown = Math.toIntExact(Math.round(progress * (double)max + (double)0.475f));
                if (cooldown > max) {
                    cooldown = max;
                }
                if (this.lastCharSent.equals(curChar = crosshair[cooldown])) {
                    return;
                }
                this.lastCharSent = curChar;
                this.player.sendTitle("", this.lastCharSent, 0, MathUtils.ceil((float)this.getCooldownPeriod()), 0);
                break;
            }
            case ACTIONBAR: {
                int max = hotbar.length - 1;
                int cooldown = Math.toIntExact(Math.round(progress * (double)max + (double)0.475f));
                if (cooldown > max) {
                    cooldown = max;
                }
                StringBuilder curChar = new StringBuilder(" " + hotbar[cooldown]);
                if (!GUIElements.ITEM_TEXT_POPUP.isHidden(this.session) && (double)System.currentTimeMillis() / ((double)this.lastHotbarTime + this.getHBStayTime()) < 1.0) {
                    ItemEnchantments enchantments;
                    GeyserItemStack heldItem;
                    if (this.session.getGameMode().equals((Object)GameMode.SURVIVAL) || this.session.getGameMode().equals((Object)GameMode.ADVENTURE)) {
                        curChar.append("\n\n\n");
                    }
                    if ((heldItem = this.session.getPlayerInventory().getItemInHand()).asItem().equals(Items.DEBUG_STICK)) {
                        curChar.append("\n\n");
                    }
                    if ((enchantments = (ItemEnchantments)heldItem.getComponent(DataComponentTypes.ENCHANTMENTS)) != null) {
                        Iterator iterator = enchantments.getEnchantments().keySet().iterator();
                        while (iterator.hasNext()) {
                            int enchID = (Integer)iterator.next();
                            if (enchID == 22) continue;
                            curChar.append("\n\n");
                        }
                    }
                }
                curChar.append(" ");
                if (this.lastCharSent.contentEquals(curChar)) {
                    return;
                }
                this.lastCharSent = curChar.toString();
                this.player.sendActionbarTitle(this.lastCharSent);
            }
        }
    }

    public double getCooldownPeriod() {
        return 1.0 / this.attackSpeed * 20.0;
    }

    private void calculateAveragePing() {
        int ping = this.session.ping();
        if (ping != this.lastPing) {
            this.pingSample += (long)ping;
            ++this.pingSampleSize;
            this.lastPing = ping;
        }
        this.averagePing = (double)this.pingSample / (double)this.pingSampleSize;
    }

    public void setLastHotbarTime(long time) {
        this.lastHotbarTime = time;
        this.setLastSwingTime(time);
    }

    private double getHBStayTime() {
        double textTime = 3.5;
        GeyserItemStack item = this.session.getPlayerInventory().getItemInHand();
        ItemEnchantments enchantments = (ItemEnchantments)item.getComponent(DataComponentTypes.ENCHANTMENTS);
        if (enchantments != null) {
            Iterator iterator = enchantments.getEnchantments().keySet().iterator();
            while (iterator.hasNext()) {
                int enchID = (Integer)iterator.next();
                if (enchID == 22) continue;
                textTime += 0.75;
            }
        }
        if (this.player.getPreferences().isAdjustCooldownWithPing() && this.lastPing >= 40 && textTime - this.averagePing / 1000.0 > 0.0) {
            textTime -= this.averagePing / 1000.0;
        }
        return textTime * 1000.0;
    }

    @Generated
    public double getAttackSpeed() {
        return this.attackSpeed;
    }

    @Generated
    public void setAttackSpeed(double attackSpeed) {
        this.attackSpeed = attackSpeed;
    }

    @Generated
    public void setDigTicks(int digTicks) {
        this.digTicks = digTicks;
    }

    @Generated
    public int getDigTicks() {
        return this.digTicks;
    }

    @Generated
    public void setLastSwingTime(long lastSwingTime) {
        this.lastSwingTime = lastSwingTime;
    }

    @Generated
    public void setLastMouseoverID(long lastMouseoverID) {
        this.lastMouseoverID = lastMouseoverID;
    }

    @Generated
    public void setSkipNextItemUse1(boolean skipNextItemUse1) {
        this.skipNextItemUse1 = skipNextItemUse1;
    }

    @Generated
    public boolean isSkipNextItemUse1() {
        return this.skipNextItemUse1;
    }

    @Generated
    public void setLastBlockRightClickTime(long lastBlockRightClickTime) {
        this.lastBlockRightClickTime = lastBlockRightClickTime;
    }

    @Generated
    public long getLastBlockRightClickTime() {
        return this.lastBlockRightClickTime;
    }

    @Generated
    public void setLastClickWasAirClick(boolean lastClickWasAirClick) {
        this.lastClickWasAirClick = lastClickWasAirClick;
    }

    @Generated
    public boolean isLastClickWasAirClick() {
        return this.lastClickWasAirClick;
    }

    @Generated
    public double getAveragePing() {
        return this.averagePing;
    }

    @Generated
    public long getPingSample() {
        return this.pingSample;
    }

    @Generated
    public long getPingSampleSize() {
        return this.pingSampleSize;
    }

    @Generated
    public int getLastPing() {
        return this.lastPing;
    }
}

