/*
 * Decompiled with CFR 0.152.
 */
package dev.letsgoaway.geyserextras.core.parity.java.menus.tablist;

import dev.letsgoaway.geyserextras.core.ExtrasPlayer;
import dev.letsgoaway.geyserextras.core.utils.IdUtils;
import java.util.LinkedHashMap;
import java.util.UUID;
import lombok.Generated;
import org.geysermc.geyser.platform.spigot.shaded.net.kyori.adventure.text.Component;
import org.geysermc.geyser.translator.text.MessageTranslator;
import org.geysermc.mcprotocollib.protocol.data.game.PlayerListEntry;

public class TabListData {
    private final ExtrasPlayer player;
    private final LinkedHashMap<UUID, PlayerListEntry> players;
    private String header = " ";
    private String footer = " ";

    public TabListData(ExtrasPlayer player) {
        this.player = player;
        this.players = new LinkedHashMap();
    }

    public static String getPlayerListName(PlayerListEntry entry) {
        if (entry.getDisplayName() == null && entry.getProfile() != null) {
            return "\u00a78" + entry.getProfile().getName();
        }
        return MessageTranslator.convertMessage((Component)entry.getDisplayName());
    }

    public static String getPlayerListHead(PlayerListEntry entry) {
        return "https://starlightskins.lunareclipse.studio/render/pixel/" + TabListData.getPlayerListID(entry.getProfileId()) + "/face?cameraWidth=8";
    }

    private static String getPlayerListID(UUID profileID) {
        long XUID = IdUtils.getBedrockXUID(profileID);
        if (XUID != -1L) {
            return "." + XUID;
        }
        return profileID.toString();
    }

    public static String getPingIcon(PlayerListEntry entry) {
        String pingIcon = "\uf834";
        int ping = entry.getLatency();
        if (ping < 0) {
            pingIcon = "\uf835";
        } else if (ping < 150) {
            pingIcon = "\uf830";
        } else if (ping < 300) {
            pingIcon = "\uf831";
        } else if (ping < 600) {
            pingIcon = "\uf832";
        } else if (ping < 1000) {
            pingIcon = "\uf833";
        }
        return pingIcon;
    }

    @Generated
    public LinkedHashMap<UUID, PlayerListEntry> getPlayers() {
        return this.players;
    }

    @Generated
    public void setHeader(String header) {
        this.header = header;
    }

    @Generated
    public String getHeader() {
        return this.header;
    }

    @Generated
    public void setFooter(String footer) {
        this.footer = footer;
    }

    @Generated
    public String getFooter() {
        return this.footer;
    }
}

