/*
 * Decompiled with CFR 0.152.
 */
package dev.letsgoaway.geyserextras.spigot;

import dev.letsgoaway.geyserextras.Server;
import dev.letsgoaway.geyserextras.ServerType;
import dev.letsgoaway.geyserextras.core.ExtrasPlayer;
import dev.letsgoaway.geyserextras.core.GeyserExtras;
import dev.letsgoaway.geyserextras.core.parity.bedrock.EmoteUtils;
import dev.letsgoaway.geyserextras.core.preferences.JavaPreferencesData;
import dev.letsgoaway.geyserextras.core.protocol.ProtocolHandler;
import dev.letsgoaway.geyserextras.core.utils.IsAvailable;
import dev.letsgoaway.geyserextras.core.utils.TickUtil;
import dev.letsgoaway.geyserextras.spigot.SpigotCommandHandler;
import dev.letsgoaway.geyserextras.spigot.SpigotExtrasPlayer;
import dev.letsgoaway.geyserextras.spigot.SpigotListener;
import dev.letsgoaway.geyserextras.spigot.SpigotTickUtil;
import dev.letsgoaway.geyserextras.spigot.config.GeyserExtrasSpigotConfig;
import dev.letsgoaway.geyserextras.spigot.config.SpigotConfigLoader;
import io.github.retrooper.packetevents.factory.spigot.SpigotPacketEventsBuilder;
import java.nio.file.Path;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.geysermc.geyser.api.connection.GeyserConnection;

public class GeyserExtrasSpigot
extends JavaPlugin
implements Server {
    public static GeyserExtras CORE;
    public static GeyserExtrasSpigot SPIGOT;
    private static SpigotTickUtil spigotTickUtil;
    private GeyserExtrasSpigotConfig platformConfig;

    public GeyserExtrasSpigot() {
        ServerType.type = ServerType.SPIGOT;
        SPIGOT = this;
        spigotTickUtil = new SpigotTickUtil();
    }

    public void onLoad() {
        if (IsAvailable.packetevents()) {
            ProtocolHandler.load(SpigotPacketEventsBuilder.build((Plugin)this));
        }
    }

    public void onEnable() {
        PluginCommand emoteChatCommand;
        PluginCommand playerlistCommand;
        PluginCommand platformlistCommand;
        SpigotCommandHandler handler = new SpigotCommandHandler();
        PluginCommand geCommand = this.getCommand("geyserextras");
        if (geCommand != null) {
            geCommand.setExecutor((CommandExecutor)handler);
        }
        if ((platformlistCommand = this.getCommand("platformlist")) != null) {
            platformlistCommand.setExecutor((CommandExecutor)handler);
        }
        if ((playerlistCommand = this.getCommand("playerlist")) != null) {
            playerlistCommand.setExecutor((CommandExecutor)handler);
        }
        if ((emoteChatCommand = this.getCommand("emotechat")) != null) {
            emoteChatCommand.setExecutor((CommandExecutor)handler);
        }
        this.getServer().getPluginManager().registerEvents((Listener)new SpigotListener(), (Plugin)this);
        CORE = new GeyserExtras(this);
        Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this, () -> CORE.serverTick(), 0L, 0L);
        if (IsAvailable.packetevents()) {
            ProtocolHandler.init();
        }
    }

    @Override
    public void onConfigLoad() {
        SpigotConfigLoader.load();
    }

    public void onDisable() {
        CORE.autoReconnectAll();
        if (IsAvailable.packetevents()) {
            ProtocolHandler.terminate();
        }
    }

    @Override
    public TickUtil getTickUtil() {
        return spigotTickUtil;
    }

    @Override
    public ExtrasPlayer createPlayer(GeyserConnection connection) {
        return new SpigotExtrasPlayer(connection);
    }

    @Override
    public void log(String string) {
        this.getLogger().info(string);
    }

    @Override
    public void warn(String string) {
        this.getLogger().warning(string);
    }

    @Override
    public Path getPluginFolder() {
        return this.getDataFolder().toPath();
    }

    @Override
    public void sendEmoteChat(ExtrasPlayer player, String emoteChat) {
        SpigotExtrasPlayer spigotPlayer = (SpigotExtrasPlayer)player;
        spigotTickUtil.runSync(() -> {
            for (Player playerNear : spigotPlayer.player.getWorld().getEntitiesByClass(Player.class)) {
                JavaPreferencesData userPrefs;
                boolean isBedrockPlayer = GeyserExtras.GE.geyserApi.isBedrockPlayer(playerNear.getUniqueId());
                if (isBedrockPlayer || (userPrefs = GeyserExtras.GE.getJavaPreferencesData(playerNear.getUniqueId())) != null && userPrefs.muteEmoteChat || !((double)EmoteUtils.EMOTE_DISTANCE >= spigotPlayer.player.getLocation().distance(playerNear.getLocation()))) continue;
                playerNear.sendMessage(ChatColor.translateAlternateColorCodes((char)'\u00a7', (String)emoteChat));
            }
        }, player);
    }

    @Override
    public void sendRawMessage(UUID javaPlayer, String message) {
        Player player = Bukkit.getPlayer((UUID)javaPlayer);
        if (player == null) {
            return;
        }
        player.sendRawMessage(message);
    }

    @Override
    public void sendMessage(UUID javaPlayer, String message) {
        Player player = Bukkit.getPlayer((UUID)javaPlayer);
        if (player == null) {
            return;
        }
        player.sendMessage(ChatColor.translateAlternateColorCodes((char)'\u00a7', (String)message));
    }

    public GeyserExtrasSpigotConfig getPlatformConfig() {
        return this.platformConfig;
    }

    public void setPlatformConfig(GeyserExtrasSpigotConfig platformConfig) {
        this.platformConfig = platformConfig;
    }
}

