/*
 * Decompiled with CFR 0.152.
 */
package dev.letsgoaway.relocate.org.spongepowered.configurate.reactive;

import dev.letsgoaway.relocate.org.spongepowered.configurate.reactive.Disposable;
import dev.letsgoaway.relocate.org.spongepowered.configurate.reactive.Publisher;
import dev.letsgoaway.relocate.org.spongepowered.configurate.reactive.Subscriber;
import dev.letsgoaway.relocate.org.spongepowered.configurate.util.CheckedSupplier;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;

class ExecutePublisher<V>
implements Publisher<V> {
    private final CompletableFuture<V> actor = new CompletableFuture();
    private final Executor executor;

    ExecutePublisher(CheckedSupplier<V, ? extends Exception> action, Executor exec) {
        exec.execute(() -> {
            try {
                this.actor.complete(action.get());
            }
            catch (Exception ex) {
                this.actor.completeExceptionally(ex);
            }
        });
        this.executor = exec;
    }

    @Override
    public Disposable subscribe(Subscriber<? super V> subscriber) {
        AtomicBoolean subscribed = new AtomicBoolean();
        ((CompletableFuture)this.actor.whenCompleteAsync((value, err) -> {
            if (subscribed.compareAndSet(true, false)) {
                if (err != null) {
                    subscriber.onError((Throwable)err);
                } else {
                    try {
                        subscriber.submit(value);
                        subscriber.onClose();
                    }
                    catch (Exception t) {
                        subscriber.onError(t);
                    }
                }
            }
        }, this.executor)).exceptionally(ex -> {
            throw new Error((Throwable)ex);
        });
        return () -> subscribed.set(false);
    }

    @Override
    public boolean hasSubscribers() {
        return !this.actor.isDone() && this.actor.getNumberOfDependents() > 0;
    }

    @Override
    public Executor executor() {
        return this.executor;
    }
}

