/*
 * Decompiled with CFR 0.152.
 */
package dev.letsgoaway.geyserextras.core;

import dev.letsgoaway.geyserextras.core.GeyserExtras;
import dev.letsgoaway.geyserextras.core.features.skinsaver.SkinSaver;
import dev.letsgoaway.geyserextras.core.form.BedrockForm;
import dev.letsgoaway.geyserextras.core.form.BedrockMenu;
import dev.letsgoaway.geyserextras.core.form.BedrockModal;
import dev.letsgoaway.geyserextras.core.locale.GELocale;
import dev.letsgoaway.geyserextras.core.parity.bedrock.EmoteUtils;
import dev.letsgoaway.geyserextras.core.parity.java.combat.CooldownHandler;
import dev.letsgoaway.geyserextras.core.parity.java.menus.serverlinks.ServerLinksData;
import dev.letsgoaway.geyserextras.core.parity.java.menus.tablist.TabListData;
import dev.letsgoaway.geyserextras.core.preferences.PreferencesData;
import dev.letsgoaway.geyserextras.core.preferences.bindings.Remappable;
import dev.letsgoaway.geyserextras.core.utils.IdUtils;
import dev.letsgoaway.geyserextras.core.utils.IsAvailable;
import dev.letsgoaway.geyserextras.core.utils.StringUtils;
import dev.letsgoaway.geyserextras.core.utils.TickMath;
import java.io.File;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import lombok.Generated;
import net.kyori.adventure.text.Component;
import org.cloudburstmc.protocol.bedrock.packet.AnimatePacket;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacket;
import org.cloudburstmc.protocol.bedrock.packet.ServerboundDiagnosticsPacket;
import org.cloudburstmc.protocol.bedrock.packet.SetTitlePacket;
import org.cloudburstmc.protocol.bedrock.packet.ToastRequestPacket;
import org.geysermc.cumulus.form.Form;
import org.geysermc.floodgate.api.FloodgateApi;
import org.geysermc.geyser.api.bedrock.camera.GuiElement;
import org.geysermc.geyser.api.connection.GeyserConnection;
import org.geysermc.geyser.api.event.bedrock.ClientEmoteEvent;
import org.geysermc.geyser.level.JavaDimension;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.cache.BossBar;
import org.geysermc.geyser.text.MinecraftLocale;

public class ExtrasPlayer {
    private final CooldownHandler cooldownHandler;
    private final TabListData tabListData;
    private final ServerLinksData serverLinksData;
    private final PreferencesData preferences;
    public GeyserSession session;
    public float tickrate = 20.0f;
    public long ticks = 0L;
    private UUID javaUUID;
    private String bedrockXUID;
    private ArrayList<UUID> emotesList;
    private ScheduledFuture<?> combatTickThread;
    private ScheduledFuture<?> doubleClickShortcutFuture;
    private File userPrefs;
    private ServerboundDiagnosticsPacket diagnostics = null;
    private boolean packsUpdated = false;
    private boolean loggedIn = false;
    private Instant lastEmoteTime = Instant.now();
    private float lastInventoryClickTime = 0.0f;
    private Map<Integer, JavaDimension> playerDimensionsMap;
    private BossBar fpsBossBar;
    private boolean emoting = false;
    private UUID bossbarID;

    public ExtrasPlayer(GeyserConnection connection) {
        this.session = (GeyserSession)connection;
        this.javaUUID = connection.javaUuid();
        this.bedrockXUID = connection.xuid();
        this.cooldownHandler = new CooldownHandler(this);
        this.tabListData = new TabListData(this);
        this.serverLinksData = new ServerLinksData(this);
        this.preferences = new PreferencesData(this);
        this.emotesList = new ArrayList();
        this.userPrefs = PreferencesData.PREFERENCES_PATH.resolve(this.bedrockXUID + ".json").toFile();
        this.preferences.load();
        this.playerDimensionsMap = new HashMap<Integer, JavaDimension>();
    }

    public void startGame() {
        this.loggedIn = true;
        this.sendSystemToast(this.translateGE("ge.welcome_toast.line1"), this.translateGE("ge.welcome_toast.line2"));
        if (GeyserExtras.GE.getConfig().isEnableSkinSaving()) {
            SkinSaver.save(this);
        }
        this.startCombatTickThread(this.getPreferences().getIndicatorUpdateRate());
        this.javaUUID = this.session.javaUuid();
    }

    private void createFpsBossBar() {
        long entityId = this.session.getEntityCache().getNextEntityId().incrementAndGet();
        this.fpsBossBar = new BossBar(this.session, entityId, (Component)Component.text(this.getBossBarText()), 1.0f, 0, 1, 0);
        this.bossbarID = UUID.randomUUID();
        this.session.getEntityCache().addBossBar(this.bossbarID, this.fpsBossBar);
    }

    public String getBossBarText() {
        return this.diagnostics != null ? "FPS: " + Math.round(this.diagnostics.getAvgFps()) : "";
    }

    public void startCombatTickThread(float updateRate) {
        this.getPreferences().setIndicatorUpdateRate(updateRate);
        if (this.combatTickThread != null) {
            this.combatTickThread.cancel(false);
        }
        this.combatTickThread = this.session.getTickEventLoop().scheduleAtFixedRate(() -> {
            if (GeyserExtras.GE.getConfig().isEnableCustomCooldown()) {
                this.getCooldownHandler().tick();
            }
        }, TickMath.toNanos(updateRate), TickMath.toNanos(updateRate), TimeUnit.NANOSECONDS);
    }

    public void onDisconnect() {
        if (this.combatTickThread != null) {
            this.combatTickThread.cancel(false);
            this.combatTickThread = null;
        }
        if (this.doubleClickShortcutFuture != null) {
            this.doubleClickShortcutFuture.cancel(false);
            this.doubleClickShortcutFuture = null;
        }
        this.tabListData.getPlayers().clear();
        if (this.fpsBossBar != null) {
            this.session.getEntityCache().removeBossBar(this.bossbarID);
            this.fpsBossBar = null;
        }
    }

    public void reconnect() {
        this.session.transfer(this.session.joinAddress(), this.session.joinPort());
    }

    public void hungerSprintCancel() {
    }

    public void onEmoteEvent(ClientEmoteEvent ev) {
        UUID uuid = UUID.fromString(ev.emoteId());
        int id = this.emotesList.indexOf(uuid);
        if (id == -1) {
            GeyserExtras.SERVER.debugWarn("Emote with id: " + ev.emoteId() + " was not in emote list!");
            return;
        }
        if (this.preferences.isDefault(Remappable.values()[id])) {
            String emoteChat = EmoteUtils.getEmoteChatString(uuid, this);
            if (emoteChat != null && Duration.between(this.lastEmoteTime, Instant.now()).toMillis() >= 3000L) {
                GeyserExtras.SERVER.sendEmoteChat(this, emoteChat);
                this.lastEmoteTime = Instant.now();
            }
        } else {
            this.preferences.getAction(Remappable.values()[id]).run(this);
        }
    }

    public void tick() {
        ++this.ticks;
        if (GeyserExtras.GE.getConfig().isDisablePaperDoll() && !this.session.camera().isHudElementHidden(GuiElement.PAPER_DOLL)) {
            this.session.camera().hideElement(new GuiElement[]{GuiElement.PAPER_DOLL});
        }
        if (this.session.getDimensionType().isNetherLike() && this.session.camera().fogEffects().contains("minecraft:fog_hell")) {
            this.session.camera().removeFog(new String[]{"minecraft:fog_hell"});
        }
        if (this.fpsBossBar == null && this.preferences.isShowFPS() && this.diagnostics != null) {
            this.createFpsBossBar();
        }
    }

    public void sendTitle(String title, String subtitle, int fadeIn, int stay, int fadeOut) {
        SetTitlePacket timesPacket = new SetTitlePacket();
        timesPacket.setText((CharSequence)"");
        timesPacket.setType(SetTitlePacket.Type.TIMES);
        timesPacket.setFadeInTime(fadeIn);
        timesPacket.setStayTime(stay);
        timesPacket.setFadeOutTime(fadeOut);
        timesPacket.setXuid("");
        timesPacket.setPlatformOnlineId("");
        this.session.sendUpstreamPacket((BedrockPacket)timesPacket);
        SetTitlePacket titlePacket = new SetTitlePacket();
        titlePacket.setType(SetTitlePacket.Type.TITLE);
        titlePacket.setText((CharSequence)(title.isEmpty() ? " " : title));
        titlePacket.setXuid("");
        titlePacket.setPlatformOnlineId("");
        this.session.sendUpstreamPacket((BedrockPacket)titlePacket);
        SetTitlePacket subtitlePacket = new SetTitlePacket();
        subtitlePacket.setType(SetTitlePacket.Type.SUBTITLE);
        subtitlePacket.setText((CharSequence)subtitle);
        subtitlePacket.setXuid("");
        subtitlePacket.setPlatformOnlineId("");
        this.session.sendUpstreamPacket((BedrockPacket)subtitlePacket);
    }

    public void sendActionbarTitle(String title) {
        SetTitlePacket titlePacket = new SetTitlePacket();
        titlePacket.setType(SetTitlePacket.Type.ACTIONBAR_JSON);
        titlePacket.setText((CharSequence)("{ \"rawtext\": [ { \"text\":\"" + StringUtils.escape(title) + "\" } ] }"));
        titlePacket.setXuid("");
        titlePacket.setPlatformOnlineId("");
        this.session.sendUpstreamPacket((BedrockPacket)titlePacket);
    }

    public void sendToast(String title, String description) {
        ToastRequestPacket toastPacket = new ToastRequestPacket();
        toastPacket.setTitle((CharSequence)title);
        toastPacket.setContent((CharSequence)description);
        this.session.sendUpstreamPacket((BedrockPacket)toastPacket);
    }

    public void sendSystemToast(String title, String description) {
        if (this.preferences.isSendSystemToasts() && GeyserExtras.GE.getConfig().isEnableGeyserExtrasMenu()) {
            ToastRequestPacket toastPacket = new ToastRequestPacket();
            toastPacket.setTitle((CharSequence)title);
            toastPacket.setContent((CharSequence)description);
            this.session.sendUpstreamPacket((BedrockPacket)toastPacket);
        }
    }

    public void sendMessage(String text) {
        this.session.sendMessage(text);
    }

    public void resetTitle() {
        SetTitlePacket titlePacket = new SetTitlePacket();
        titlePacket.setType(SetTitlePacket.Type.CLEAR);
        titlePacket.setText((CharSequence)"");
        titlePacket.setXuid("");
        titlePacket.setPlatformOnlineId("");
        this.session.sendUpstreamPacket((BedrockPacket)titlePacket);
    }

    public void sendForm(BedrockForm form) {
        if (IsAvailable.floodgate()) {
            FloodgateApi.getInstance().getPlayer(this.javaUUID).sendForm(form.create(this).build());
        } else {
            this.session.sendForm(form.create(this).build());
        }
    }

    public void sendForm(BedrockMenu form) {
        if (IsAvailable.floodgate()) {
            FloodgateApi.getInstance().getPlayer(this.javaUUID).sendForm((Form)form.create(this));
        } else {
            this.session.sendForm((Form)form.create(this));
        }
    }

    public void sendForm(BedrockModal form) {
        if (IsAvailable.floodgate()) {
            FloodgateApi.getInstance().getPlayer(this.javaUUID).sendForm((Form)form.create(this));
        } else {
            this.session.sendForm((Form)form.create(this));
        }
    }

    public void setTickingState(float tickrate) {
        this.tickrate = tickrate;
    }

    public void swingArm() {
        AnimatePacket animatePacket = new AnimatePacket();
        animatePacket.setRuntimeEntityId(this.session.getPlayerEntity().getGeyserId());
        animatePacket.setAction(AnimatePacket.Action.SWING_ARM);
        this.session.sendUpstreamPacket((BedrockPacket)animatePacket);
    }

    public String translate(String lang) {
        return MinecraftLocale.getLocaleString((String)lang, (String)this.session.locale());
    }

    public String translateGE(String lang) {
        return GELocale.translate(lang, this.session.locale());
    }

    public String translateOtherwiseGE(String lang, String otherwise) {
        return GELocale.translateOtherwise(lang, otherwise, this.session.locale());
    }

    @Nullable
    public static ExtrasPlayer get(UUID javaUUID) {
        long XUID = IdUtils.getBedrockXUID(javaUUID);
        if (XUID != -1L) {
            return ExtrasPlayer.get(XUID);
        }
        for (ExtrasPlayer player : GeyserExtras.GE.connections.values()) {
            if (player.getJavaUUID() == null || !player.getJavaUUID().equals(javaUUID)) continue;
            return player;
        }
        return null;
    }

    public static ExtrasPlayer get(GeyserConnection connection) {
        return ExtrasPlayer.get(connection.xuid());
    }

    public static ExtrasPlayer get(long XUID) {
        return ExtrasPlayer.get(String.valueOf(XUID));
    }

    public static ExtrasPlayer get(String XUID) {
        return GeyserExtras.GE.connections.get(XUID);
    }

    public static boolean exists(GeyserConnection connection) {
        return ExtrasPlayer.exists(connection.xuid());
    }

    public static boolean exists(long XUID) {
        return ExtrasPlayer.exists(String.valueOf(XUID));
    }

    public static boolean exists(String XUID) {
        return GeyserExtras.GE.connections.containsKey(XUID);
    }

    @Generated
    public CooldownHandler getCooldownHandler() {
        return this.cooldownHandler;
    }

    @Generated
    public TabListData getTabListData() {
        return this.tabListData;
    }

    @Generated
    public ServerLinksData getServerLinksData() {
        return this.serverLinksData;
    }

    @Generated
    public PreferencesData getPreferences() {
        return this.preferences;
    }

    @Generated
    public GeyserSession getSession() {
        return this.session;
    }

    @Generated
    public void setTickrate(float tickrate) {
        this.tickrate = tickrate;
    }

    @Generated
    public float getTickrate() {
        return this.tickrate;
    }

    @Generated
    public UUID getJavaUUID() {
        return this.javaUUID;
    }

    @Generated
    public String getBedrockXUID() {
        return this.bedrockXUID;
    }

    @Generated
    public void setEmotesList(ArrayList<UUID> emotesList) {
        this.emotesList = emotesList;
    }

    @Generated
    public ArrayList<UUID> getEmotesList() {
        return this.emotesList;
    }

    @Generated
    public ScheduledFuture<?> getCombatTickThread() {
        return this.combatTickThread;
    }

    @Generated
    public ScheduledFuture<?> getDoubleClickShortcutFuture() {
        return this.doubleClickShortcutFuture;
    }

    @Generated
    public void setDoubleClickShortcutFuture(ScheduledFuture<?> doubleClickShortcutFuture) {
        this.doubleClickShortcutFuture = doubleClickShortcutFuture;
    }

    @Generated
    public File getUserPrefs() {
        return this.userPrefs;
    }

    @Generated
    public ServerboundDiagnosticsPacket getDiagnostics() {
        return this.diagnostics;
    }

    @Generated
    public void setDiagnostics(ServerboundDiagnosticsPacket diagnostics) {
        this.diagnostics = diagnostics;
    }

    @Generated
    public void setPacksUpdated(boolean packsUpdated) {
        this.packsUpdated = packsUpdated;
    }

    @Generated
    public boolean isPacksUpdated() {
        return this.packsUpdated;
    }

    @Generated
    public boolean isLoggedIn() {
        return this.loggedIn;
    }

    @Generated
    public void setLastInventoryClickTime(float lastInventoryClickTime) {
        this.lastInventoryClickTime = lastInventoryClickTime;
    }

    @Generated
    public float getLastInventoryClickTime() {
        return this.lastInventoryClickTime;
    }

    @Generated
    public Map<Integer, JavaDimension> getPlayerDimensionsMap() {
        return this.playerDimensionsMap;
    }

    @Generated
    public BossBar getFpsBossBar() {
        return this.fpsBossBar;
    }

    @Generated
    public void setFpsBossBar(BossBar fpsBossBar) {
        this.fpsBossBar = fpsBossBar;
    }

    @Generated
    public void setEmoting(boolean emoting) {
        this.emoting = emoting;
    }

    @Generated
    public boolean isEmoting() {
        return this.emoting;
    }
}

