/*
 * Decompiled with CFR 0.152.
 */
package dev.letsgoaway.geyserextras.core.cache;

import dev.letsgoaway.geyserextras.core.ExtrasPlayer;
import dev.letsgoaway.geyserextras.core.GeyserExtras;
import dev.letsgoaway.geyserextras.core.cache.Cache;
import dev.letsgoaway.geyserextras.core.cache.HTTP;
import dev.letsgoaway.geyserextras.core.parity.java.menus.packs.PackLoader;
import dev.letsgoaway.geyserextras.core.version.Version3;
import dev.letsgoaway.relocate.com.fasterxml.jackson.databind.JsonNode;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.geysermc.geyser.api.event.bedrock.SessionLoadResourcePacksEvent;
import org.geysermc.geyser.api.pack.PackCodec;
import org.geysermc.geyser.api.pack.ResourcePack;
import org.geysermc.geyser.api.pack.option.PriorityOption;
import org.geysermc.geyser.api.pack.option.ResourcePackOption;
import org.geysermc.geyser.api.pack.option.SubpackOption;

public class PackCacheUtils {
    public static Path PACKS_FOLDER;
    public static Path GEYSER_EXTRAS_PACK;
    public static ResourcePack RP_GEYSER_EXTRAS;

    public static void initialize() {
        File oldOptionalPack;
        File gopWorkaroundPack;
        PACKS_FOLDER = Cache.CACHE_FOLDER.resolve("packs/");
        GEYSER_EXTRAS_PACK = PACKS_FOLDER.resolve("GeyserExtrasPack.mcpack");
        GeyserExtras.SERVER.log("Checking for pack updates...");
        try {
            Files.createDirectories(PACKS_FOLDER, new FileAttribute[0]);
            boolean extrasPackNeedsUpdate = PackCacheUtils.checkExtrasPack();
            if (extrasPackNeedsUpdate) {
                Cache.saveCacheDates();
                GeyserExtras.SERVER.log("Downloading GeyserExtrasPack...");
                InputStream in = HTTP.request("https://raw.githubusercontent.com/GeyserExtras/GeyserExtrasPack/main/GeyserExtrasPack.mcpack");
                Files.copy(in, GEYSER_EXTRAS_PACK, StandardCopyOption.REPLACE_EXISTING);
                GeyserExtras.SERVER.log("GeyserExtrasPack downloaded!");
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error while downloading resources!", e);
        }
        GeyserExtras.SERVER.log("Loading resources...");
        RP_GEYSER_EXTRAS = ResourcePack.create((PackCodec)PackCodec.path((Path)GEYSER_EXTRAS_PACK));
        Path geyserMCPacks = GeyserExtras.GE.geyserApi.packDirectory();
        File geWorkaroundPack = geyserMCPacks.resolve("GeyserExtrasPack.mcpack").toFile();
        if (geWorkaroundPack.exists() && geWorkaroundPack.delete()) {
            GeyserExtras.SERVER.log("Deleted GeyserExtrasPack.mcpack from GeyserMC packs folder");
        }
        if ((gopWorkaroundPack = geyserMCPacks.resolve("GeyserOptionalPack.mcpack").toFile()).exists() && gopWorkaroundPack.delete()) {
            GeyserExtras.SERVER.log("Removed deprecated GeyserOptionalPack.mcpack from GeyserMC packs");
        }
        if ((oldOptionalPack = PACKS_FOLDER.resolve("GeyserOptionalPack.mcpack").toFile()).exists() && oldOptionalPack.delete()) {
            GeyserExtras.SERVER.log("Removed deprecated GeyserOptionalPack.mcpack from cache");
        }
    }

    private static boolean checkExtrasPack() {
        if (!GEYSER_EXTRAS_PACK.toFile().exists()) {
            return true;
        }
        if (!GeyserExtras.GE.getConfig().isCheckForUpdates()) {
            return false;
        }
        Version3 oldVersion = Version3.fromArray(Cache.CACHE_DATES.lastExtrasPackVersion);
        Version3 latestExtrasPackVersion = PackCacheUtils.getPackVersion("https://raw.githubusercontent.com/GeyserExtras/GeyserExtrasPack/main/src/pack/manifest.json");
        Cache.CACHE_DATES.lastExtrasPackVersion = latestExtrasPackVersion.asArray();
        return latestExtrasPackVersion.isNewer(oldVersion);
    }

    private static Version3 getPackVersion(String url) {
        try {
            byte[] data = new URL(url).openStream().readAllBytes();
            JsonNode manifestJson = Cache.JSON_MAPPER.readTree(data);
            ArrayList<Integer> versionArray = new ArrayList<Integer>();
            for (JsonNode node : manifestJson.get("header").get("version")) {
                versionArray.add(node.asInt());
            }
            return Version3.fromList(versionArray);
        }
        catch (Exception e) {
            return Version3.fromString("0.0.0");
        }
    }

    public static void onPackLoadEvent(ExtrasPlayer player, SessionLoadResourcePacksEvent ev) {
        try {
            if (!ev.resourcePacks().contains(RP_GEYSER_EXTRAS)) {
                int priority = GeyserExtras.GE.getConfig().getGeyserExtrasPackPriority();
                if (priority < -100 || priority > 100) {
                    GeyserExtras.SERVER.warn("GeyserExtrasPack priority " + priority + " is out of valid range (-100 to 100). Using default value of 100.");
                    priority = 100;
                }
                ev.register(RP_GEYSER_EXTRAS, new ResourcePackOption[]{PriorityOption.priority((int)priority)});
            }
        }
        catch (Exception priority) {
            // empty catch block
        }
        List<UUID> packsToLoad = player.getPreferences().getSelectedPacks();
        for (UUID pack : packsToLoad) {
            ResourcePack rp = PackLoader.PACKS.get(pack);
            try {
                if (ev.resourcePacks().contains(rp)) continue;
                String subpack = "";
                if (player.getPreferences().getSelectedSubpacks().containsKey(pack)) {
                    subpack = player.getPreferences().getSelectedSubpacks().get(pack);
                }
                ev.register(rp, new ResourcePackOption[]{PriorityOption.priority((int)(99 - packsToLoad.indexOf(pack))), SubpackOption.named((String)subpack)});
            }
            catch (Exception exception) {}
        }
    }
}

