/*
 * Decompiled with CFR 0.152.
 */
package dev.letsgoaway.geyserextras.core.config;

import dev.letsgoaway.relocate.org.spongepowered.configurate.objectmapping.ConfigSerializable;
import dev.letsgoaway.relocate.org.spongepowered.configurate.objectmapping.meta.Comment;
import lombok.Generated;

@ConfigSerializable
public final class GeyserExtrasConfig {
    @Comment(value="Enable the GeyserExtras menu, which can be opened by players by\ndouble-tapping inventory, or typing `/ge`.\n \nThe GeyserExtras Menu provides actions and configurable settings such as\n- Remapping certain actions (e.g emotes/pick block) to Java Edition only actions (e.g offhand)\n- Configurable HUD Visibility\n- Quick access to form remakes of Java Edition Menus\n  (e.g Player List, Advancements, Statistics).\n \nYou can configure default options for Bedrock Players at\n`preferences/default.json`\nand for Java Players at\n`preferences/java/default.json`.\n \nSetting this to `false` also disables saving of preferences.\n")
    private boolean enableGeyserExtrasMenu = true;
    @Comment(value="Enable the Java Edition styled cooldown.")
    private boolean enableCustomCooldown = true;
    @Comment(value="Enable the Java Edition combat sounds.")
    private boolean enableJavaCombatSounds = true;
    @Comment(value="Enable the Block Display entity workaround using FMBE. (EXPERIMENTAL)\nNote that the translation is not 100% accurate and some block types might be invisible (candles, doors, campfires),\nwhere as some blocks will render differently (fence, glass panes, some storage containers).\nBlock Display billboards do not work and X/Z scale are linked to which ever one is highest,\nmeaning that this should only be enabled for very simple usages of Block Displays.\n(https://wiki.bedrock.dev/commands/display-entities.html)\n")
    private boolean enableBlockDisplayWorkaround = false;
    @Comment(value="Requires PacketEvents and Java Edition clients on 1.21.9 or above.\nhttps://modrinth.com/plugin/packetevents\n\nEnables the cape workaround. (EXPERIMENTAL)\n\nThis shows Bedrock Edition player capes on Java Edition clients,\nby using fake mannequin player entities.\nIt copies the packets of the player, so the position is identical.\nThe hitbox of the mannequin is identical to the player and\nwhenever the mannequin is attacked by the player it is translated as an attack\nto the bedrock player.\n\nThis may break anti-cheats or plugins, and is not perfect.\n\nThe Bedrock Edition player's cape will sometimes slightly clip\ninside the Bedrock Player when wearing armor and if the player attacks.\n\nThe cape is visually removed when entering mounts that can support more than one\nplayer (including chest boats).\n\nThis only works with capes that are available on Java Edition, that are also on\nBedrock Edition.\n")
    private boolean enableBedrockCapesOnJavaWorkaround = true;
    @Comment(value="When the server closes or Geyser reloads, should GeyserExtras automatically reconnect players to the server.")
    private boolean autoReconnect = true;
    @Comment(value="The language that Java Edition players read when using a GeyserExtras command (e.g, `/muteemotechat`).\nThis is automatically set on Bedrock Edition from the player's settings.\nYou can see the list of all locale codes here:\nhttps://github.com/GeyserExtras/data/blob/main/langs/language_names.json\n")
    private String defaultLocale = "en_US";
    @Comment(value="Enables downloading of Bedrock Player skins.\nThis will download the Geometry, Animations, and Textures of your players skins/capes.\nPersona skins are currently bugged.\n")
    private boolean enableSkinSaving = false;
    @Comment(value="Whether to disable the Paper Doll or not.\nThe Paper Doll is the small player graphic in the top left of bedrock players screens\nThis can give players a competitive advantage over java in some cases, for example,\nyou can see what armor you have on without pressing the inventory key\nyou can see what armor has broken during combat\n")
    private boolean disablePaperDoll = false;
    @Comment(value="Whether to check for updates or not.\nThis also disables updating of the GeyserExtrasPack,\nhowever you can manually update them by deleting the 'GeyserExtras/cache/' folder.\n")
    private boolean checkForUpdates = true;
    @Comment(value="The priority level for the GeyserExtrasPack resource pack.\nHigher values = higher priority (packs with higher priority override files from lower-priority packs\nwhen file names conflict, and the client cannot easily merge them).\nValid range: -100 to 100\nCommon values:\n- -100: Lowest priority\n- 0: Normal priority\n- 100: Highest priority (default)\n\nOnly change this if you have other resource packs that need to override GeyserExtrasPack,\nor if GeyserExtrasPack needs lower priority than your custom packs.\n")
    private int geyserExtrasPackPriority = 100;
    @Comment(value="Only enable if you know what you are doing.")
    private boolean debugMode = false;
    @Comment(value="The version of the config. DO NOT CHANGE!")
    private int version = 4;

    @Generated
    public boolean isEnableGeyserExtrasMenu() {
        return this.enableGeyserExtrasMenu;
    }

    @Generated
    public boolean isEnableCustomCooldown() {
        return this.enableCustomCooldown;
    }

    @Generated
    public boolean isEnableJavaCombatSounds() {
        return this.enableJavaCombatSounds;
    }

    @Generated
    public boolean isEnableBlockDisplayWorkaround() {
        return this.enableBlockDisplayWorkaround;
    }

    @Generated
    public boolean isEnableBedrockCapesOnJavaWorkaround() {
        return this.enableBedrockCapesOnJavaWorkaround;
    }

    @Generated
    public boolean isAutoReconnect() {
        return this.autoReconnect;
    }

    @Generated
    public String getDefaultLocale() {
        return this.defaultLocale;
    }

    @Generated
    public boolean isEnableSkinSaving() {
        return this.enableSkinSaving;
    }

    @Generated
    public boolean isDisablePaperDoll() {
        return this.disablePaperDoll;
    }

    @Generated
    public boolean isCheckForUpdates() {
        return this.checkForUpdates;
    }

    @Generated
    public int getGeyserExtrasPackPriority() {
        return this.geyserExtrasPackPriority;
    }

    @Generated
    public boolean isDebugMode() {
        return this.debugMode;
    }

    @Generated
    public int getVersion() {
        return this.version;
    }
}

