/*
 * Decompiled with CFR 0.152.
 */
package dev.letsgoaway.geyserextras.core.features.platformlist;

import dev.letsgoaway.geyserextras.core.ExtrasPlayer;
import java.util.UUID;
import org.geysermc.api.util.BedrockPlatform;
import org.geysermc.geyser.api.connection.GeyserConnection;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.auth.BedrockClientData;

public class PlatformList {
    public Ecosystem getEcosystem(UUID uuid) {
        ExtrasPlayer player = ExtrasPlayer.get(uuid);
        if (player == null) {
            return Ecosystem.JAVA;
        }
        return this.getEcosystem((GeyserConnection)player.getSession());
    }

    public Ecosystem getEcosystem(GeyserConnection connection) {
        return switch (connection.platform()) {
            default -> throw new IncompatibleClassChangeError();
            case BedrockPlatform.UNKNOWN -> Ecosystem.UNKNOWN;
            case BedrockPlatform.GOOGLE, BedrockPlatform.GEARVR -> Ecosystem.ANDROID;
            case BedrockPlatform.NX -> Ecosystem.NINTENDO;
            case BedrockPlatform.OSX, BedrockPlatform.IOS, BedrockPlatform.TVOS -> Ecosystem.APPLE;
            case BedrockPlatform.AMAZON -> Ecosystem.AMAZON;
            case BedrockPlatform.PS4 -> Ecosystem.PLAYSTATION;
            case BedrockPlatform.UWP, BedrockPlatform.WIN32, BedrockPlatform.WINDOWS_PHONE, BedrockPlatform.HOLOLENS -> Ecosystem.WINDOWS;
            case BedrockPlatform.XBOX -> Ecosystem.XBOX;
            case BedrockPlatform.LINUX, BedrockPlatform.DEDICATED -> Ecosystem.SERVER;
        };
    }

    public Platform getPlatform(UUID uuid) {
        ExtrasPlayer player = ExtrasPlayer.get(uuid);
        if (player == null) {
            return Platform.DESKTOP;
        }
        return this.getPlatform((GeyserConnection)player.getSession());
    }

    public Platform getPlatform(GeyserConnection connection) {
        return switch (connection.platform()) {
            default -> throw new IncompatibleClassChangeError();
            case BedrockPlatform.UNKNOWN -> Platform.UNKNOWN;
            case BedrockPlatform.GOOGLE, BedrockPlatform.GEARVR, BedrockPlatform.IOS, BedrockPlatform.AMAZON, BedrockPlatform.WINDOWS_PHONE, BedrockPlatform.HOLOLENS -> Platform.MOBILE;
            case BedrockPlatform.OSX, BedrockPlatform.UWP, BedrockPlatform.WIN32, BedrockPlatform.DEDICATED -> Platform.DESKTOP;
            case BedrockPlatform.NX, BedrockPlatform.TVOS, BedrockPlatform.PS4, BedrockPlatform.XBOX, BedrockPlatform.LINUX -> Platform.CONSOLE;
        };
    }

    public Device getDevice(UUID uuid) {
        ExtrasPlayer player = ExtrasPlayer.get(uuid);
        if (player == null) {
            return Device.JAVA;
        }
        return this.getDevice(player.getSession());
    }

    public Device getDevice(GeyserSession session) {
        BedrockClientData data = session.getClientData();
        String model = data.getDeviceModel();
        switch (session.platform()) {
            case UNKNOWN: 
            case DEDICATED: {
                return Device.UNKNOWN;
            }
            case GOOGLE: {
                return Device.ANDROID_DEVICE;
            }
            case IOS: {
                return Device.IPAD;
            }
            case OSX: {
                return Device.IMAC;
            }
            case AMAZON: {
                return Device.AMAZON_FIRE;
            }
            case GEARVR: {
                return Device.ANDROID_DEVICE;
            }
            case UWP: 
            case WIN32: 
            case HOLOLENS: {
                return Device.WINDOWS_10_PC;
            }
            case TVOS: {
                return Device.APPLETV;
            }
            case PS4: {
                return Device.PS4;
            }
            case NX: {
                return Device.SWITCH;
            }
            case XBOX: {
                return Device.XBOX_ONE;
            }
            case WINDOWS_PHONE: {
                return Device.WINDOWS_PHONE;
            }
            case LINUX: {
                return Device.CHROMEBOOK;
            }
        }
        return Device.UNKNOWN;
    }

    public static enum Ecosystem {
        UNKNOWN,
        JAVA,
        WINDOWS,
        APPLE,
        ANDROID,
        AMAZON,
        PLAYSTATION,
        XBOX,
        NINTENDO,
        SERVER;

    }

    public static enum Platform {
        UNKNOWN,
        CONSOLE,
        DESKTOP,
        MOBILE;

    }

    public static enum Device {
        UNKNOWN,
        JAVA,
        PS4,
        PS5,
        SWITCH,
        SWITCH_2,
        XBOX_ONE,
        XBOX_SERIES,
        LINUX,
        WINDOWS_PHONE,
        WINDOWS_10_PC,
        WINDOWS_11_PC,
        ANDROID_DEVICE,
        AMAZON_FIRE,
        CHROMEBOOK,
        IPHONE,
        IPAD,
        IMAC,
        APPLETV;

    }
}

