/*
 * Decompiled with CFR 0.152.
 */
package dev.letsgoaway.geyserextras.core.features.skinsaver;

import dev.letsgoaway.geyserextras.core.ExtrasPlayer;
import dev.letsgoaway.geyserextras.core.GeyserExtras;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Base64;
import javax.imageio.ImageIO;
import org.geysermc.geyser.session.auth.BedrockClientData;
import org.geysermc.geyser.util.FileUtils;

public class SkinSaver {
    public static void save(ExtrasPlayer player) {
        try {
            String animationData;
            BedrockClientData data = player.getSession().getClientData();
            Path skinsFolder = Files.createDirectories(GeyserExtras.SERVER.getPluginFolder().resolve("skins/" + data.getSkinId().replace(data.getCapeId(), "") + "/"), new FileAttribute[0]);
            File skinFile = skinsFolder.resolve("skin.png").toFile();
            byte[] skinBytes = Base64.getDecoder().decode(data.getSkinData().getBytes(StandardCharsets.UTF_8));
            ImageIO.write((RenderedImage)SkinSaver.getFromSkinData(data.getSkinImageWidth(), data.getSkinImageHeight(), skinBytes), "png", skinFile);
            String geometryName = new String(Base64.getDecoder().decode(data.getGeometryName().getBytes(StandardCharsets.UTF_8)));
            String geometryData = new String(Base64.getDecoder().decode(data.getGeometryData().getBytes(StandardCharsets.UTF_8)));
            String rawAnimData = data.getSkinAnimationData();
            if (!(rawAnimData.isEmpty() || rawAnimData.isBlank() || (animationData = new String(Base64.getDecoder().decode(rawAnimData.getBytes(StandardCharsets.UTF_8)))).isEmpty() || animationData.isBlank())) {
                FileUtils.writeFile((File)skinsFolder.resolve("skin.animation.json").toFile(), (char[])animationData.toCharArray());
            }
            FileUtils.writeFile((File)skinsFolder.resolve("skin.geometry.json").toFile(), (char[])geometryData.toCharArray());
            FileUtils.writeFile((File)skinsFolder.resolve("skin.geometry_name.json").toFile(), (char[])geometryName.toCharArray());
            if (!data.getCapeId().isEmpty()) {
                Path capesFolder = Files.createDirectories(GeyserExtras.SERVER.getPluginFolder().resolve("capes/" + data.getCapeId() + "/"), new FileAttribute[0]);
                File capeFile = capesFolder.resolve("cape.png").toFile();
                byte[] capeBytes = data.getCapeData();
                ImageIO.write((RenderedImage)SkinSaver.getFromSkinData(data.getCapeImageWidth(), data.getCapeImageHeight(), capeBytes), "png", capeFile);
            }
        }
        catch (IOException e) {
            GeyserExtras.SERVER.warn("Could not save skin data for player " + player.getBedrockXUID() + ", " + e.getLocalizedMessage());
        }
    }

    private static BufferedImage getFromSkinData(int width, int height, byte[] pixelData) {
        BufferedImage argbImage = new BufferedImage(width, height, 2);
        int[] pixels = new int[width * height];
        for (int i = 0; i < pixels.length; ++i) {
            int a = (pixelData[i * 4 + 3] & 0xFF) << 24;
            int r = (pixelData[i * 4] & 0xFF) << 16;
            int g = (pixelData[i * 4 + 1] & 0xFF) << 8;
            int b = pixelData[i * 4 + 2] & 0xFF;
            pixels[i] = a | r | g | b;
        }
        argbImage.setRGB(0, 0, width, height, pixels, 0, width);
        return argbImage;
    }
}

