/*
 * Decompiled with CFR 0.152.
 */
package dev.letsgoaway.geyserextras.core.injectors.bedrock;

import dev.letsgoaway.geyserextras.core.ExtrasPlayer;
import dev.letsgoaway.geyserextras.core.GeyserExtras;
import java.util.concurrent.TimeUnit;
import org.cloudburstmc.protocol.bedrock.packet.MobEquipmentPacket;
import org.geysermc.geyser.api.connection.GeyserConnection;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.item.Items;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.geyser.translator.protocol.bedrock.BedrockMobEquipmentTranslator;
import org.geysermc.mcprotocollib.network.packet.Packet;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.Hand;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.player.ServerboundSetCarriedItemPacket;

@Translator(packet=MobEquipmentPacket.class)
public class BedrockMobEquipmentInjector
extends BedrockMobEquipmentTranslator {
    public void translate(GeyserSession session, MobEquipmentPacket packet) {
        if (GeyserExtras.GE.getConfig().isEnableCustomCooldown()) {
            ExtrasPlayer player = ExtrasPlayer.get((GeyserConnection)session);
            int newSlot = packet.getHotbarSlot();
            if (!session.isSpawned() || newSlot > 8 || packet.getContainerId() != 0 || session.getPlayerInventory().getHeldItemSlot() == newSlot) {
                return;
            }
            session.getBookEditCache().checkForSend();
            GeyserItemStack oldItem = session.getPlayerInventory().getItemInHand();
            session.getPlayerInventory().setHeldItemSlot(newSlot);
            ServerboundSetCarriedItemPacket setCarriedItemPacket = new ServerboundSetCarriedItemPacket(newSlot);
            session.sendDownstreamGamePacket((Packet)setCarriedItemPacket);
            GeyserItemStack newItem = session.getPlayerInventory().getItemInHand();
            if (session.isSneaking() && newItem.asItem() == Items.SHIELD) {
                session.scheduleInEventLoop(() -> session.useItem(Hand.MAIN_HAND), 50L, TimeUnit.MILLISECONDS);
            }
            if (oldItem.getJavaId() != newItem.getJavaId()) {
                player.getCooldownHandler().setDigTicks(-1);
                if (newItem.asItem().equals(Items.AIR)) {
                    player.getCooldownHandler().setLastSwingTime(System.currentTimeMillis());
                } else {
                    player.getCooldownHandler().setLastHotbarTime(System.currentTimeMillis());
                }
            }
            if (session.getMouseoverEntity() != null) {
                session.getMouseoverEntity().updateInteractiveTag();
            }
        } else {
            super.translate(session, packet);
        }
    }
}

