/*
 * Decompiled with CFR 0.152.
 */
package dev.letsgoaway.geyserextras.core.menus;

import dev.letsgoaway.geyserextras.core.ExtrasPlayer;
import dev.letsgoaway.geyserextras.core.GeyserExtras;
import dev.letsgoaway.geyserextras.core.form.BedrockMenu;
import dev.letsgoaway.geyserextras.core.form.elements.Button;
import dev.letsgoaway.geyserextras.core.menus.settings.menus.SettingsMenu;
import dev.letsgoaway.geyserextras.core.parity.java.menus.packs.PackLoader;
import dev.letsgoaway.geyserextras.core.parity.java.menus.packs.PackMenu;
import dev.letsgoaway.geyserextras.core.parity.java.menus.serverlinks.ServerLinksMenu;
import dev.letsgoaway.geyserextras.core.preferences.bindings.Action;
import org.geysermc.cumulus.form.SimpleForm;
import org.geysermc.cumulus.util.FormImage;

public class MainMenu
extends BedrockMenu {
    @Override
    public SimpleForm create(ExtrasPlayer player) {
        this.setTitle(player.translateGE("ge.menu"));
        this.add(new Button(Action.SWAP_OFFHAND.translate(player), FormImage.Type.PATH, "textures/ui/move.png", () -> Action.SWAP_OFFHAND.run(player)));
        this.add(new Button(Action.RECONNECT.translate(player), FormImage.Type.PATH, "textures/ui/refresh_hover.png", () -> Action.RECONNECT.run(player)));
        this.add(new Button("%menu.settings", FormImage.Type.PATH, "textures/ui/settings_glyph_color_2x.png", () -> player.sendForm(new SettingsMenu())));
        this.add(new Button(Action.OPEN_ADVANCEMENTS.translate(player), FormImage.Type.PATH, "textures/ui/achievements.png", () -> Action.OPEN_ADVANCEMENTS.run(player)));
        this.add(new Button(Action.OPEN_STATISTICS.translate(player), FormImage.Type.PATH, "textures/ui/world_glyph_color_2x_black_outline.png", () -> Action.OPEN_STATISTICS.run(player)));
        this.add(new Button(Action.PLAYER_LIST.translate(player), FormImage.Type.PATH, "textures/ui/Local.png", () -> Action.PLAYER_LIST.run(player)));
        if (!player.getServerLinksData().getServerLinks().isEmpty()) {
            this.add(new Button(player.translate("menu.server_links.title"), FormImage.Type.PATH, "textures/ui/external_link.png", () -> player.sendForm(new ServerLinksMenu())));
        }
        if (!PackLoader.PACKS.isEmpty()) {
            this.add(new Button("%menu.resourcepacks", FormImage.Type.PATH, "textures/ui/glyph_resource_pack.png", () -> player.sendForm(new PackMenu())));
        }
        if (GeyserExtras.GE.getConfig().isDebugMode()) {
            // empty if block
        }
        return super.create(player);
    }
}

