/*
 * Decompiled with CFR 0.152.
 */
package dev.letsgoaway.geyserextras.core.menus.settings.sections;

import dev.letsgoaway.geyserextras.core.ExtrasPlayer;
import dev.letsgoaway.geyserextras.core.form.BedrockForm;
import dev.letsgoaway.geyserextras.core.form.elements.Dropdown;
import dev.letsgoaway.geyserextras.core.form.elements.MappedDropdown;
import dev.letsgoaway.geyserextras.core.form.elements.Slider;
import dev.letsgoaway.geyserextras.core.form.elements.Toggle;
import dev.letsgoaway.geyserextras.core.menus.settings.sections.Section;
import dev.letsgoaway.geyserextras.core.preferences.Perspectives;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.geysermc.cumulus.util.FormImage;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.text.GeyserLocale;
import org.geysermc.geyser.util.CooldownUtils;

public class VideoSection
extends Section {
    private static String translateCooldown(CooldownUtils.CooldownType cooldownType, ExtrasPlayer player) {
        switch (cooldownType) {
            case TITLE: {
                return "%options.interactionmodel.crosshair";
            }
            case ACTIONBAR: {
                return player.translate("options.attack.hotbar");
            }
            case DISABLED: {
                return "%options.off";
            }
        }
        return "";
    }

    @Override
    public void build(BedrockForm menu, GeyserSession session, ExtrasPlayer player) {
        if (session.getGeyser().config().gameplay().showCooldown() != CooldownUtils.CooldownType.DISABLED) {
            LinkedHashMap<String, CooldownUtils.CooldownType> cooldownTypes = new LinkedHashMap<String, CooldownUtils.CooldownType>();
            for (CooldownUtils.CooldownType cooldownType : CooldownUtils.CooldownType.values()) {
                cooldownTypes.put(VideoSection.translateCooldown(cooldownType, player), cooldownType);
            }
            String playerOption = VideoSection.translateCooldown(session.getPreferencesCache().getCooldownPreference(), player);
            menu.add(new Dropdown(player.translate("options.attackIndicator"), new ArrayList<String>(cooldownTypes.keySet()), playerOption, str -> session.getPreferencesCache().setCooldownPreference((CooldownUtils.CooldownType)cooldownTypes.get(str))));
            menu.add(new Slider(player.translateGE("ge.settings.video.attackIndicatorFPS"), 5.0f, 250.0f, 5.0f, player.getPreferences().getIndicatorUpdateRate(), player::startCombatTickThread));
            menu.add(new Toggle(player.translateGE("ge.settings.video.adjustCooldownWithPing"), player.getPreferences().isAdjustCooldownWithPing(), b -> player.getPreferences().setAdjustCooldownWithPing((boolean)b)));
        }
        menu.add(new MappedDropdown<Perspectives>(player.translateGE("ge.settings.video.lockedCameraPerspective"), Perspectives.buildTranslations(session), player.getPreferences().getLockedPerspective(), pov -> player.getPreferences().setLockedPerspective((Perspectives)((Object)pov))));
        if (session.getPreferencesCache().isAllowShowCoordinates()) {
            menu.add(new Toggle("%createWorldScreen.showCoordinates", session.getPreferencesCache().isPrefersShowCoordinates(), b -> {
                session.getPreferencesCache().setPrefersShowCoordinates(b.booleanValue());
                session.getPreferencesCache().updateShowCoordinates();
            }));
        }
        if (player.getDiagnostics() != null) {
            menu.add(new Toggle(player.translateGE("ge.settings.video.showFPS"), player.getPreferences().isShowFPS(), b -> {
                player.getPreferences().setShowFPS((boolean)b);
                if (!b.booleanValue() && player.getFpsBossBar() != null) {
                    player.getFpsBossBar().removeBossBar();
                    player.setFpsBossBar(null);
                }
            }));
        }
        menu.add(new Toggle(player.translateGE("ge.settings.video.advancedTooltips"), session.isAdvancedTooltips(), b -> {
            if (b.booleanValue() != session.isAdvancedTooltips()) {
                session.setAdvancedTooltips(b.booleanValue());
                String onOrOff = session.isAdvancedTooltips() ? "on" : "off";
                session.sendMessage("\u00a7l\u00a7e" + player.translate("debug.prefix") + " \u00a7r" + player.translate("debug.advanced_tooltips." + onOrOff));
                session.getPlayerInventoryHolder().updateInventory();
            }
        }));
        menu.add(new Toggle(GeyserLocale.getPlayerLocaleString((String)"geyser.settings.option.customSkulls", (String)session.locale()), session.getPreferencesCache().isPrefersCustomSkulls(), b -> session.getPreferencesCache().setPrefersCustomSkulls(b.booleanValue())));
    }

    @Override
    public List<String> getHeader(ExtrasPlayer player) {
        return List.of("%options.video", "");
    }

    @Override
    public FormImage getImage() {
        return FormImage.of((FormImage.Type)FormImage.Type.PATH, (String)"textures/ui/video_glyph_2x.png");
    }
}

