/*
 * Decompiled with CFR 0.152.
 */
package dev.letsgoaway.geyserextras.core.parity.java.menus.tablist;

import dev.letsgoaway.geyserextras.core.ExtrasPlayer;
import dev.letsgoaway.geyserextras.core.form.BedrockMenu;
import dev.letsgoaway.geyserextras.core.form.elements.Button;
import dev.letsgoaway.geyserextras.core.parity.java.menus.tablist.TabListData;
import dev.letsgoaway.geyserextras.core.utils.IdUtils;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacket;
import org.cloudburstmc.protocol.bedrock.packet.ShowProfilePacket;
import org.geysermc.cumulus.form.SimpleForm;
import org.geysermc.cumulus.util.FormImage;
import org.geysermc.mcprotocollib.protocol.data.game.PlayerListEntry;

public class PlayerListMenu
extends BedrockMenu {
    private static String fixUnreadable(String text) {
        return text.replace("\u00a77", "\u00a78");
    }

    @Override
    public SimpleForm create(ExtrasPlayer player) {
        this.setTitle(player.translate("key.playerlist"));
        this.setHeader(player.getTabListData().getHeader() + "\n\n" + player.getTabListData().getFooter());
        for (PlayerListEntry entry : player.getTabListData().getPlayers().values()) {
            if (!entry.isListed()) continue;
            String name = PlayerListMenu.fixUnreadable(this.createPlayerName(entry));
            this.add(new Button(name, FormImage.Type.URL, TabListData.getPlayerListHead(entry), () -> {
                long XUID = IdUtils.getBedrockXUID(entry.getProfileId());
                if (XUID != -1L) {
                    ShowProfilePacket showProfilePacket = new ShowProfilePacket();
                    showProfilePacket.setXuid(String.valueOf(XUID));
                    player.getSession().sendUpstreamPacket((BedrockPacket)showProfilePacket);
                } else {
                    player.sendForm(new PlayerListMenu());
                }
            }));
        }
        return super.create(player);
    }

    private String createPlayerName(PlayerListEntry entry) {
        StringBuilder builder = new StringBuilder(TabListData.getPlayerListName(entry));
        while (builder.length() < 30) {
            builder.append(" ");
        }
        builder.append(TabListData.getPingIcon(entry));
        return builder.toString();
    }
}

