/*
 * Decompiled with CFR 0.152.
 */
package dev.letsgoaway.geyserextras.core.protocol;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.PacketEventsAPI;
import com.github.retrooper.packetevents.event.PacketListener;
import com.github.retrooper.packetevents.event.PacketListenerPriority;
import com.github.retrooper.packetevents.event.PacketReceiveEvent;
import com.github.retrooper.packetevents.event.PacketSendEvent;
import com.github.retrooper.packetevents.event.UserDisconnectEvent;
import com.github.retrooper.packetevents.event.UserLoginEvent;
import com.github.retrooper.packetevents.protocol.player.User;
import dev.letsgoaway.geyserextras.core.protocol.CapeLoader;
import dev.letsgoaway.geyserextras.core.protocol.JavaPlayer;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;

public class ProtocolHandler
implements PacketListener {
    static ProtocolHandler PE;
    static Map<UUID, JavaPlayer> connections;

    public static void load(PacketEventsAPI<?> builder) {
        PacketEvents.setAPI(builder);
        PacketEvents.getAPI().load();
        PE = new ProtocolHandler();
        PacketEvents.getAPI().getEventManager().registerListener((PacketListener)PE, PacketListenerPriority.HIGHEST);
    }

    public static void init() {
        PacketEvents.getAPI().init();
        CapeLoader.init();
    }

    public static void terminate() {
        PacketEvents.getAPI().terminate();
    }

    @Nullable
    public static JavaPlayer getJavaPlayer(UUID uuid) {
        return connections.get(uuid);
    }

    public static boolean javaPlayerExists(UUID uuid) {
        return connections.containsKey(uuid);
    }

    public static void add(User user) {
        if (!ProtocolHandler.javaPlayerExists(user.getUUID())) {
            connections.put(user.getUUID(), new JavaPlayer(user));
        }
    }

    public static void remove(User user) {
        connections.remove(user.getUUID());
    }

    public void onUserLogin(UserLoginEvent event) {
        ProtocolHandler.add(event.getUser());
    }

    public void onUserDisconnect(UserDisconnectEvent event) {
        ProtocolHandler.remove(event.getUser());
    }

    public void onPacketSend(PacketSendEvent event) {
        JavaPlayer player = ProtocolHandler.getJavaPlayer(event.getUser().getUUID());
        if (player == null) {
            return;
        }
        player.onPacketSend(event);
    }

    public void onPacketReceive(PacketReceiveEvent event) {
        JavaPlayer player = ProtocolHandler.getJavaPlayer(event.getUser().getUUID());
        if (player == null) {
            return;
        }
        player.onPacketReceive(event);
    }

    static {
        connections = new HashMap<UUID, JavaPlayer>();
    }
}

