/*
 * Decompiled with CFR 0.152.
 */
package dev.letsgoaway.relocate.org.spongepowered.configurate.yaml;

import dev.letsgoaway.relocate.org.spongepowered.configurate.CommentedConfigurationNode;
import dev.letsgoaway.relocate.org.spongepowered.configurate.ConfigurationNode;
import dev.letsgoaway.relocate.org.spongepowered.configurate.ConfigurationOptions;
import dev.letsgoaway.relocate.org.spongepowered.configurate.RepresentationHint;
import dev.letsgoaway.relocate.org.spongepowered.configurate.loader.AbstractConfigurationLoader;
import dev.letsgoaway.relocate.org.spongepowered.configurate.loader.CommentHandler;
import dev.letsgoaway.relocate.org.spongepowered.configurate.loader.CommentHandlers;
import dev.letsgoaway.relocate.org.spongepowered.configurate.loader.LoaderOptionSource;
import dev.letsgoaway.relocate.org.spongepowered.configurate.util.UnmodifiableCollections;
import dev.letsgoaway.relocate.org.spongepowered.configurate.yaml.NodeStyle;
import dev.letsgoaway.relocate.org.spongepowered.configurate.yaml.ScalarStyle;
import dev.letsgoaway.relocate.org.spongepowered.configurate.yaml.YamlConstructor;
import dev.letsgoaway.relocate.org.spongepowered.configurate.yaml.YamlRepresenter;
import dev.letsgoaway.relocate.org.spongepowered.configurate.yaml.internal.snakeyaml.DumperOptions;
import dev.letsgoaway.relocate.org.spongepowered.configurate.yaml.internal.snakeyaml.LoaderOptions;
import dev.letsgoaway.relocate.org.spongepowered.configurate.yaml.internal.snakeyaml.Yaml;
import dev.letsgoaway.relocate.org.spongepowered.configurate.yaml.internal.snakeyaml.constructor.BaseConstructor;
import dev.letsgoaway.relocate.org.spongepowered.configurate.yaml.internal.snakeyaml.representer.Representer;
import java.io.BufferedReader;
import java.io.Writer;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class YamlConfigurationLoader
extends AbstractConfigurationLoader<CommentedConfigurationNode> {
    private static final Set<Class<?>> NATIVE_TYPES = UnmodifiableCollections.toSet(Boolean.class, Integer.class, Long.class, BigInteger.class, Double.class, byte[].class, String.class, java.util.Date.class, Date.class, Timestamp.class);
    public static final RepresentationHint<ScalarStyle> SCALAR_STYLE = RepresentationHint.of("configurate:yaml/scalarstyle", ScalarStyle.class);
    public static final RepresentationHint<NodeStyle> NODE_STYLE = RepresentationHint.of("configurate:yaml/nodestyle", NodeStyle.class);
    private final ThreadLocal<YamlConstructor> constructor;
    private final ThreadLocal<Yaml> yaml;

    public static Builder builder() {
        return new Builder();
    }

    private YamlConfigurationLoader(Builder builder) {
        super(builder, new CommentHandler[]{CommentHandlers.HASH});
        LoaderOptions loaderOpts = new LoaderOptions().setAcceptTabs(true).setProcessComments(builder.commentsEnabled());
        loaderOpts.setCodePointLimit(Integer.MAX_VALUE);
        DumperOptions opts = builder.options;
        opts.setDefaultFlowStyle(NodeStyle.asSnakeYaml(builder.style));
        opts.setProcessComments(builder.commentsEnabled());
        opts.setWidth(builder.lineLength());
        opts.setIndicatorIndent(builder.indent());
        opts.setIndentWithIndicator(true);
        this.constructor = ThreadLocal.withInitial(() -> new YamlConstructor(loaderOpts));
        this.yaml = ThreadLocal.withInitial(() -> new Yaml((BaseConstructor)this.constructor.get(), (Representer)new YamlRepresenter(true, opts), opts, loaderOpts));
    }

    @Override
    protected void loadInternal(CommentedConfigurationNode node, BufferedReader reader) {
        this.constructor.get().options = node.options();
        @Nullable CommentedConfigurationNode loaded = (CommentedConfigurationNode)this.yaml.get().load(reader);
        if (loaded == null) {
            loaded = CommentedConfigurationNode.root(node.options());
        }
        node.from(loaded);
    }

    @Override
    protected void saveInternal(ConfigurationNode node, Writer writer) {
        this.yaml.get().dump(node, writer);
    }

    @Override
    public CommentedConfigurationNode createNode(ConfigurationOptions options) {
        return CommentedConfigurationNode.root(options);
    }

    public static final class Builder
    extends AbstractConfigurationLoader.Builder<Builder, YamlConfigurationLoader> {
        private final DumperOptions options = new DumperOptions();
        private @Nullable NodeStyle style;
        private boolean enableComments;
        private int lineLength;

        Builder() {
            this.indent(4);
            this.defaultOptions(o -> o.nativeTypes(NATIVE_TYPES));
            this.from(DEFAULT_OPTIONS_SOURCE);
        }

        @Override
        protected void populate(LoaderOptionSource options) {
            @Nullable NodeStyle declared = options.getEnum(NodeStyle.class, "yaml", "node-style");
            if (declared != null) {
                this.style = declared;
            }
            this.enableComments = options.getBoolean(true, "yaml", "comments-enabled");
            this.lineLength = options.getInt(150, "yaml", "line-length");
        }

        public Builder indent(int indent) {
            this.options.setIndent(indent);
            return this;
        }

        public int indent() {
            return this.options.getIndent();
        }

        public Builder nodeStyle(@Nullable NodeStyle style) {
            this.style = style;
            return this;
        }

        public @Nullable NodeStyle nodeStyle() {
            return this.style;
        }

        public Builder commentsEnabled(boolean enableComments) {
            this.enableComments = enableComments;
            return this;
        }

        public boolean commentsEnabled() {
            return this.enableComments;
        }

        public Builder lineLength(int lineLength) {
            this.lineLength = lineLength;
            return this;
        }

        public int lineLength() {
            return this.lineLength;
        }

        @Override
        public YamlConfigurationLoader build() {
            return new YamlConfigurationLoader(this);
        }
    }
}

