/*
 * Decompiled with CFR 0.152.
 */
package dev.letsgoaway.geyserextras.core.cache;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import dev.letsgoaway.geyserextras.core.GeyserExtras;
import dev.letsgoaway.geyserextras.core.cache.CacheDates;
import dev.letsgoaway.geyserextras.core.cache.HTTP;
import dev.letsgoaway.geyserextras.core.cache.PackCacheUtils;
import dev.letsgoaway.geyserextras.core.locale.GELocale;
import dev.letsgoaway.geyserextras.core.parity.java.menus.packs.PackLoader;
import dev.letsgoaway.relocate.com.fasterxml.jackson.databind.DeserializationFeature;
import dev.letsgoaway.relocate.com.fasterxml.jackson.databind.ObjectMapper;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;

public class Cache {
    public static final ObjectMapper JSON_MAPPER = new ObjectMapper().disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    public static final Gson GSON = new Gson();
    public static Path CACHE_FOLDER;
    public static CacheDates CACHE_DATES;
    public static Path DATES_PATH;
    public static Path CREDITS_PATH;
    public static Path LANGUAGE_FOLDER;
    private static final String REPO = "https://raw.githubusercontent.com/GeyserExtras/data/main/";
    public static String CREDITS_TEXT;
    private static final SimpleDateFormat dateFormat;

    public static void initialize() {
        CACHE_FOLDER = GeyserExtras.SERVER.getPluginFolder().resolve("cache/");
        DATES_PATH = CACHE_FOLDER.resolve("dates.json");
        CREDITS_PATH = CACHE_FOLDER.resolve("credits.txt");
        LANGUAGE_FOLDER = CACHE_FOLDER.resolve("langs/");
        try {
            Files.createDirectories(CACHE_FOLDER, new FileAttribute[0]);
            Files.createDirectories(LANGUAGE_FOLDER, new FileAttribute[0]);
            if (Files.exists(DATES_PATH, new LinkOption[0])) {
                FileInputStream data = new FileInputStream(DATES_PATH.toFile());
                CACHE_DATES = JSON_MAPPER.convertValue((Object)JSON_MAPPER.readTree(data.readAllBytes()), CacheDates.class);
            } else {
                CACHE_DATES = new CacheDates();
                Cache.saveCacheDates();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Cache.downloadAll();
        GeyserExtras.SERVER.log("Loading cache...");
        Cache.loadData();
        GeyserExtras.SERVER.log("Loading resources...");
        PackCacheUtils.initialize();
        PackLoader.initialize();
    }

    public static void saveCacheDates() {
        try {
            JSON_MAPPER.writeValue(DATES_PATH.toFile(), (Object)CACHE_DATES);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void downloadAll() {
        boolean dataNeedsUpdate = Cache.checkData();
        if (dataNeedsUpdate || !CREDITS_PATH.toFile().exists()) {
            Cache.downloadCredits();
        }
        if (dataNeedsUpdate) {
            GeyserExtras.SERVER.log("Downloading languages...");
            Cache.downloadLanguages();
        }
    }

    public static void loadData() {
        try (FileInputStream data = new FileInputStream(CREDITS_PATH.toFile());){
            CREDITS_TEXT = new String(data.readAllBytes()).replaceAll("&", "\u00a7");
        }
        catch (Exception e) {
            CREDITS_TEXT = "Error loading credits :/";
        }
        GELocale.loadAll();
    }

    private static void downloadCredits() {
        InputStream in = HTTP.request("https://raw.githubusercontent.com/GeyserExtras/data/main/credits.txt");
        try {
            Files.copy(in, CREDITS_PATH, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void downloadLanguages() {
        String langNames = HTTP.asText("https://raw.githubusercontent.com/GeyserExtras/data/main/langs/language_names.json");
        try {
            String[][] langs;
            PrintWriter out = new PrintWriter(LANGUAGE_FOLDER.resolve("language_names.json").toFile());
            out.println(langNames);
            out.close();
            for (String[] lang : langs = (String[][])GSON.fromJson(langNames, String[][].class)) {
                InputStream langJson = HTTP.request("https://raw.githubusercontent.com/GeyserExtras/data/main/langs/" + lang[0] + ".json");
                Files.copy(langJson, LANGUAGE_FOLDER.resolve(lang[0] + ".json"), StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static boolean checkData() {
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        try {
            if (Cache.isDirEmpty(LANGUAGE_FOLDER)) {
                return true;
            }
            if (!GeyserExtras.GE.getConfig().isCheckForUpdates()) {
                return false;
            }
            JsonObject clientDataJson = (JsonObject)GSON.fromJson(HTTP.asText("https://api.github.com/repos/GeyserExtras/data/branches/main"), JsonObject.class);
            long githubDataTime = dateFormat.parse(clientDataJson.get("commit").getAsJsonObject().get("commit").getAsJsonObject().get("author").getAsJsonObject().get("date").getAsString()).toInstant().getEpochSecond();
            if (githubDataTime > CACHE_DATES.getDataUpdateTime()) {
                CACHE_DATES.setDataUpdateTime(githubDataTime);
                JSON_MAPPER.writeValue(DATES_PATH.toFile(), (Object)CACHE_DATES);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean isDirEmpty(Path directory) throws IOException {
        try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(directory);){
            boolean bl = !dirStream.iterator().hasNext();
            return bl;
        }
    }

    static {
        CREDITS_TEXT = "";
        dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.US);
    }
}

